/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadOnlyPipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.MessageFormatter;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Pipe
extends ReadOnlyPipe
implements ReadablePipe,
WritablePipe {
    private ListenableDocumentSequence documents = null;
    private boolean writeSeqOk = false;
    private int size = 0;
    private Step writer = null;

    public Pipe(XProcRuntime xproc) {
        this(xproc, new ListenableDocumentSequence(xproc));
    }

    private Pipe(XProcRuntime xproc, ListenableDocumentSequence documents) {
        super(xproc, documents);
        this.documents = documents;
        this.size = 0;
    }

    @Override
    public void setWriter(Step step) {
        this.writer = step;
    }

    @Override
    public void canWriteSequence(boolean sequence) {
        this.writeSeqOk = sequence;
    }

    @Override
    public void resetWriter() {
        this.documents.reset();
        this.size = 0;
        this.pos = 0;
    }

    @Override
    public boolean writeSequence() {
        return this.writeSeqOk;
    }

    public boolean closed() {
        return this.documents.closed();
    }

    @Override
    public void close() {
        this.documents.close();
    }

    @Override
    public void write(XdmNode doc) {
        if (this.writer != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.writer.getNode(), this.writer.getName() + " wrote '" + (doc == null ? "null" : doc.getBaseURI()) + "' to " + this));
        }
        this.documents.add(doc);
        ++this.size;
        if (this.size > 1 && !this.writeSeqOk) {
            this.dynamicError(7);
        }
    }

    public void onRead(XProcRunnable runnable) {
        if (this.documents.runOnRead == null) {
            this.documents.runOnRead = new ArrayList<XProcRunnable>();
        }
        this.documents.runOnRead.add(runnable);
    }

    private static class ListenableDocumentSequence
    extends DocumentSequence {
        List<XProcRunnable> runOnRead = null;

        ListenableDocumentSequence(XProcRuntime xproc) {
            super(xproc);
        }

        @Override
        void beforeRead() throws SaxonApiException {
            if (this.runOnRead != null) {
                ArrayList<XProcRunnable> r = new ArrayList<XProcRunnable>(this.runOnRead);
                this.runOnRead = null;
                for (XProcRunnable rr : r) {
                    rr.run();
                }
                if (this.runOnRead != null) {
                    this.beforeRead();
                }
                if (this.runOnRead != null) {
                    r.addAll(this.runOnRead);
                }
                this.runOnRead = r;
            }
            this.close();
        }

        @Override
        public void reset() {
            super.reset();
            this.runOnRead = null;
        }
    }
}

