/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.io.DataStore;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;

public class URLDataStore
implements DataStore {
    private final DataStore fallback;

    public URLDataStore(DataStore fallback) {
        this.fallback = fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI writeEntry(String href, String base, String media, DataStore.DataWriter handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        URLConnection conn = uri.toURL().openConnection();
        conn.setRequestProperty("Content-Type", media);
        conn.setDoOutput(true);
        conn.setDoInput(false);
        try (OutputStream stream = conn.getOutputStream();){
            handler.store(stream);
        }
        String location = conn.getHeaderField("Content-Location");
        URI url = URI.create(conn.getURL().toExternalForm());
        if (location == null) {
            return url;
        }
        return url.resolve(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readEntry(String href, String base, String accept, String overrideContentType, DataStore.DataReader handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URL url = baseURI.resolve(href).toURL();
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("Accept", accept);
        try (InputStream stream = connection.getInputStream();){
            String type = connection.getContentType();
            if (overrideContentType != null) {
                type = overrideContentType;
            }
            URI id = URI.create(connection.getURL().toExternalForm());
            long len = 0L;
            try {
                Method lenMethod = connection.getClass().getDeclaredMethod("getContentLengthLong", new Class[0]);
                lenMethod.invoke((Object)connection, new Object[0]);
            }
            catch (Exception e) {
                len = connection.getContentLength();
            }
            handler.load(id, type, stream, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void infoEntry(String href, String base, String accept, DataStore.DataInfo handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URL url = baseURI.resolve(href).toURL();
        URLConnection connection = url.openConnection();
        connection.setRequestProperty("Accept", accept);
        try (InputStream stream = connection.getInputStream();){
            String type = connection.getContentType();
            URI id = URI.create(connection.getURL().toExternalForm());
            handler.list(id, type, connection.getLastModified());
        }
    }

    @Override
    public void listEachEntry(String href, String base, String accept, DataStore.DataInfo handler) throws MalformedURLException, FileNotFoundException, IOException {
        this.fallback.listEachEntry(href, base, accept, handler);
    }

    @Override
    public URI createList(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        return this.fallback.createList(href, base);
    }

    @Override
    public void deleteEntry(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        this.fallback.deleteEntry(href, base);
    }
}

