/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import java.util.Hashtable;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;

@XMLCalabash(name="p:add-attribute", type="{http://www.w3.org/ns/xproc}add-attribute")
public class AddAttribute
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _attribute_name = new QName("", "attribute-name");
    private static final QName _attribute_value = new QName("", "attribute-value");
    private static final QName _attribute_prefix = new QName("", "attribute-prefix");
    private static final QName _attribute_namespace = new QName("", "attribute-namespace");
    private QName attrName = null;
    private String attrValue = null;
    private ProcessMatch matcher = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public AddAttribute(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue attrNameValue = this.getOption(_attribute_name);
        String attrNameStr = attrNameValue.getString();
        String apfx = this.getOption(_attribute_prefix, (String)null);
        String ans = this.getOption(_attribute_namespace, (String)null);
        if (apfx != null && ans == null) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a prefix without a namespace");
        }
        if (ans != null && attrNameStr.contains(":")) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a namespace if the attribute name contains a colon");
        }
        this.attrName = attrNameStr.contains(":") ? new QName(attrNameStr, attrNameValue.getNode()) : new QName(apfx == null ? "" : apfx, ans, attrNameStr);
        this.attrValue = this.getOption(_attribute_value).getString();
        if ("xmlns".equals(this.attrName.getLocalName()) || "xmlns".equals(this.attrName.getPrefix()) || "http://www.w3.org/2000/xmlns/".equals(this.attrName.getNamespaceURI()) || !"xml".equals(this.attrName.getPrefix()) && "http://www.w3.org/XML/1998/namespace".equals(this.attrName.getNamespaceURI()) || "xml".equals(this.attrName.getPrefix()) && !"http://www.w3.org/XML/1998/namespace".equals(this.attrName.getNamespaceURI())) {
            throw XProcException.stepError(59);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        try {
            this.matcher.match(this.source.read(), this.getOption(_match));
        }
        catch (XProcException e) {
            throw new XProcException((XStep)this.step, "Failed to apply match pattern: " + this.getOption(_match).getString(), e);
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(13);
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(13);
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        Hashtable<QName, String> attrs = new Hashtable<QName, String>();
        XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            String value = child.getStringValue();
            if (child.getNodeName().equals((Object)this.attrName)) continue;
            attrs.put(child.getNodeName(), value);
        }
        QName instanceAttrName = this.attrName;
        if (this.attrName.getNamespaceURI() != null && !"".equals(this.attrName.getNamespaceURI())) {
            String prefix = this.attrName.getPrefix();
            for (QName attr : attrs.keySet()) {
                if (!prefix.equals(attr.getPrefix()) || this.attrName.getNamespaceURI().equals(attr.getNamespaceURI())) continue;
                prefix = "";
            }
            if ("".equals(prefix)) {
                int acount = 0;
                String aprefix = "_0";
                boolean done = false;
                while (!done) {
                    aprefix = "_" + ++acount;
                    done = true;
                    for (QName attr : attrs.keySet()) {
                        if (!aprefix.equals(attr.getPrefix())) continue;
                        done = false;
                    }
                }
                instanceAttrName = new QName(aprefix, this.attrName.getNamespaceURI(), this.attrName.getLocalName());
            }
        }
        attrs.put(instanceAttrName, this.attrValue);
        this.matcher.addStartElement(node);
        for (QName attr : attrs.keySet()) {
            this.matcher.addAttribute(attr, (String)attrs.get(attr));
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }
}

