/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="p:error", type="{http://www.w3.org/ns/xproc}error")
public class Error
extends DefaultStep {
    private static final QName _code = new QName("code");
    private static final QName _code_prefix = new QName("code-prefix");
    private static final QName _code_namespace = new QName("code-namespace");
    private ReadablePipe source = null;

    public Error(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
    }

    @Override
    public void reset() {
        this.source.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode doc = this.source.read();
        if (doc == null) {
            this.logger.trace("Error step read empty");
        } else {
            this.logger.trace("Error step read " + doc.getDocumentURI());
        }
        RuntimeValue codeNameValue = this.getOption(_code);
        String codeNameStr = codeNameValue.getString();
        String cpfx = this.getOption(_code_prefix, (String)null);
        String cns = this.getOption(_code_namespace, (String)null);
        if (cpfx == null && cns != null) {
            cpfx = "ERR";
        }
        if (cpfx != null && cns == null) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a prefix without a namespace");
        }
        if (cns != null && codeNameStr.contains(":")) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a namespace if the code name contains a colon");
        }
        QName errorCode = null;
        errorCode = codeNameStr.contains(":") ? codeNameValue.getQName() : new QName(cpfx == null ? "" : cpfx, cns, codeNameStr);
        cpfx = errorCode.getPrefix();
        cns = errorCode.getNamespaceURI();
        XProcException e = doc == null ? new XProcException(errorCode, (XStep)this.step, errorCode.getLocalName()) : new XProcException(errorCode, (XStep)this.step, doc);
        this.step.reportError(e);
        throw e;
    }
}

