/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.XProcCollectionFinder;
import java.util.Iterator;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;

@XMLCalabash(name="p:label-elements", type="{http://www.w3.org/ns/xproc}label-elements")
public class LabelElements
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _attribute = new QName("attribute");
    private static final QName _attribute_prefix = new QName("attribute-prefix");
    private static final QName _attribute_namespace = new QName("attribute-namespace");
    private static final QName _match = new QName("match");
    private static final QName _label = new QName("label");
    private static final QName _replace = new QName("replace");
    private static final QName p_index = new QName("p", "http://www.w3.org/ns/xproc", "index");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private QName attribute = null;
    private RuntimeValue label = null;
    private boolean replace = true;
    private int count = 1;

    public LabelElements(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue attrNameValue = this.getOption(_attribute);
        String attrNameStr = attrNameValue.getString();
        String apfx = this.getOption(_attribute_prefix, (String)null);
        String ans = this.getOption(_attribute_namespace, (String)null);
        if (apfx != null && ans == null) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a prefix without a namespace");
        }
        if (ans != null && attrNameStr.contains(":")) {
            throw XProcException.dynamicError(34, this.step, "You can't specify a namespace if the attribute name contains a colon");
        }
        if (attrNameStr.contains(":")) {
            this.attribute = new QName(attrNameStr, attrNameValue.getNode());
        } else {
            if (apfx == null && ans != null) {
                apfx = "_1";
            }
            this.attribute = new QName(apfx == null ? "" : apfx, ans, attrNameStr);
        }
        this.label = this.getOption(_label);
        this.replace = this.getOption(_replace).getBoolean();
        this.matcher = new ProcessMatch(this.runtime, this);
        XdmNode doc = this.source.read();
        CollectionFinder resetCollectionFinder = null;
        if (this.runtime.getAllowSequenceAsContext()) {
            Vector<XdmNode> defaultCollection = new Vector<XdmNode>();
            defaultCollection.add(doc);
            Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
            CollectionFinder finder = config.getCollectionFinder();
            config.setDefaultCollection("http://xmlcalabash.com/saxon-default-collection");
            config.setCollectionFinder((CollectionFinder)new XProcCollectionFinder(this.runtime, defaultCollection, finder));
            resetCollectionFinder = finder;
        }
        try {
            this.matcher.match(doc, this.getOption(_match));
        }
        finally {
            if (resetCollectionFinder != null) {
                this.runtime.getProcessor().getUnderlyingConfiguration().setCollectionFinder(resetCollectionFinder);
            }
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(24);
    }

    @Override
    public void processEndDocument(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(24);
    }

    @Override
    public boolean processStartElement(XdmNode node) throws SaxonApiException {
        this.matcher.addStartElement(node);
        boolean found = false;
        XdmSequenceIterator iter = node.axisIterator(Axis.ATTRIBUTE);
        while (iter.hasNext()) {
            XdmNode attr = (XdmNode)iter.next();
            if (this.attribute.equals((Object)attr.getNodeName())) {
                found = true;
                if (this.replace) {
                    this.matcher.addAttribute(attr, this.computedLabel(node));
                    continue;
                }
                this.matcher.addAttribute(attr);
                continue;
            }
            this.matcher.addAttribute(attr);
        }
        if (!found) {
            this.matcher.addAttribute(this.attribute, this.computedLabel(node));
        }
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) throws SaxonApiException {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    @Override
    public void processAttribute(XdmNode node) throws SaxonApiException {
        throw XProcException.stepError(23);
    }

    private String computedLabel(XdmNode node) throws SaxonApiException {
        XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
        xcomp.setBaseURI(this.step.getNode().getBaseURI());
        for (String prefix : this.label.getNamespaceBindings().keySet()) {
            xcomp.declareNamespace(prefix, this.label.getNamespaceBindings().get(prefix));
        }
        xcomp.declareVariable(p_index);
        XPathExecutable xexec = xcomp.compile(this.label.getString());
        XPathSelector selector = xexec.load();
        selector.setVariable(p_index, (XdmValue)new XdmAtomicValue(this.count++));
        selector.setContextItem((XdmItem)node);
        Iterator values = selector.iterator();
        XdmItem item = (XdmItem)values.next();
        return item.getStringValue();
    }
}

