/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.SequenceType;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class Option
extends EndPoint
implements ComputableValue {
    private QName name = null;
    private boolean required = false;
    private String select = null;
    private String type = null;
    private QName typeAsQName = null;
    private SequenceType sequenceType = null;
    private Vector<NamespaceBinding> nsBindings = new Vector();

    public Option(XProcRuntime xproc, XdmNode node) {
        super(xproc, node);
    }

    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    public void setType(String type) {
        this.setType(type, null);
    }

    public void setType(String type, QName typeAsQName) {
        this.type = type;
        this.typeAsQName = typeAsQName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public QName getTypeAsQName() {
        return this.typeAsQName;
    }

    public void setSequenceType(SequenceType sequenceType) {
        this.sequenceType = sequenceType;
    }

    @Override
    public SequenceType getSequenceType() {
        return this.sequenceType;
    }

    public void setRequired(String required) {
        this.required = "true".equals(required);
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean getRequired() {
        return this.required;
    }

    public void setSelect(String select) {
        this.select = select;
    }

    @Override
    public String getSelect() {
        return this.select;
    }

    @Override
    public void addNamespaceBinding(NamespaceBinding binding) {
        this.nsBindings.add(binding);
    }

    @Override
    public Vector<NamespaceBinding> getNamespaceBindings() {
        return this.nsBindings;
    }

    public boolean valid(Environment env) {
        boolean valid = true;
        if (this.bindings.size() > 1) {
            this.error(XProcException.dynamicError(8, "Option can have at most one binding."));
            valid = false;
        }
        if (this.required && this.select != null) {
            this.error(XProcException.staticError(17, "You can't specify a default value on a required option"));
        }
        return valid;
    }

    public String toString() {
        if (XProcConstants.p_option.equals((Object)this.node.getNodeName())) {
            return "with-option " + this.name;
        }
        return "option " + this.name;
    }

    protected void dump(int depth) {
        String indent = "";
        for (int count = 0; count < depth; ++count) {
            indent = indent + " ";
        }
        if (this.select != null) {
            this.logger.trace(indent + "option " + this.getName() + " select=" + this.select);
        } else {
            this.logger.trace(indent + "option " + this.getName());
            if (this.getBinding().size() == 0 && !XProcConstants.p_option.equals((Object)this.node.getNodeName())) {
                this.logger.trace(indent + "  no binding");
            }
        }
        for (Binding binding : this.getBinding()) {
            binding.dump(depth + 2);
        }
    }
}

