/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclarationScope;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Step;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;

public class PipelineLibrary
extends Step
implements DeclarationScope {
    Hashtable<QName, DeclareStep> declaredSteps = new Hashtable();
    Vector<DeclareStep> steps = new Vector();
    private List<PipelineLibrary> importedLibs = new ArrayList<PipelineLibrary>();
    private boolean circularImportGuard = false;

    public PipelineLibrary(XProcRuntime xproc, XdmNode node) {
        super(xproc, node, XProcConstants.p_library);
    }

    public void addStep(DeclareStep step) {
        QName type = step.getDeclaredType();
        if (type == null) {
            return;
        }
        if (this.declaredSteps.contains(type)) {
            throw new XProcException(step.getNode(), "You aren't allowed to do this");
        }
        this.steps.add(step);
        this.declareStep(type, step);
    }

    public QName firstStep() {
        if (this.steps.size() > 0) {
            return this.steps.get(0).getDeclaredType();
        }
        return null;
    }

    @Override
    public void declareStep(QName type, DeclareStep step) {
        DeclareStep d = this.getDeclaration(type);
        if (d != null) {
            if (!d.equals(step)) {
                throw new XProcException(step, "Duplicate step type: " + type);
            }
        } else {
            this.declaredSteps.put(type, step);
        }
    }

    public void addImport(PipelineLibrary lib) {
        this.importedLibs.add(lib);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeclareStep getDeclaration(QName type) {
        DeclareStep decl = null;
        if (!this.circularImportGuard) {
            this.circularImportGuard = true;
            try {
                for (PipelineLibrary lib : this.importedLibs) {
                    DeclareStep d = lib.getDeclaration(type);
                    if (d == null) continue;
                    if (decl == null) {
                        decl = d;
                        continue;
                    }
                    if (decl.equals(d)) continue;
                    throw new XProcException(d, "Duplicate step type: " + type);
                }
                DeclareStep d = this.declaredSteps.get(type);
                if (d != null) {
                    if (decl == null) {
                        decl = d;
                    } else if (!decl.equals(d)) {
                        throw new XProcException(d, "Duplicate step type: " + type);
                    }
                }
            }
            finally {
                this.circularImportGuard = false;
            }
        }
        return decl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QName> getInScopeTypes() {
        HashSet<QName> decls = new HashSet<QName>();
        if (!this.circularImportGuard) {
            this.circularImportGuard = true;
            try {
                decls.addAll(this.declaredSteps.keySet());
                for (PipelineLibrary lib : this.importedLibs) {
                    decls.addAll(lib.getInScopeTypes());
                }
            }
            finally {
                this.circularImportGuard = false;
            }
        }
        return decls;
    }
}

