/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import java.net.URI;
import java.util.Hashtable;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;

public class RuntimeValue {
    private XdmValue value = null;
    private String stringValue = null;
    private XdmNode node = null;
    private boolean initialized = false;
    private Hashtable<String, String> nsBindings = null;

    public RuntimeValue() {
    }

    public RuntimeValue(String stringValue, XdmNode node) {
        this.stringValue = stringValue;
        this.node = node;
        this.initialized = true;
        this.nsBindings = new Hashtable();
        XdmSequenceIterator nsIter = node.axisIterator(Axis.NAMESPACE);
        while (nsIter.hasNext()) {
            XdmNode ns = (XdmNode)nsIter.next();
            QName nodeName = ns.getNodeName();
            String uri = ns.getStringValue();
            if (nodeName == null) {
                this.nsBindings.put("", uri);
                continue;
            }
            String localName = nodeName.getLocalName();
            this.nsBindings.put(localName, uri);
        }
    }

    public RuntimeValue(String stringValue, XdmNode node, Hashtable<String, String> nsBindings) {
        this.stringValue = stringValue;
        this.node = node;
        this.nsBindings = nsBindings;
        this.initialized = true;
    }

    public RuntimeValue(String stringValue, XdmValue value, XdmNode node, Hashtable<String, String> nsBindings) {
        this.stringValue = stringValue;
        this.value = value;
        this.node = node;
        this.nsBindings = nsBindings;
        this.initialized = true;
    }

    public RuntimeValue(String stringValue) {
        this.stringValue = stringValue;
        this.initialized = true;
    }

    public boolean initialized() {
        return this.initialized;
    }

    public XdmAtomicValue getUntypedAtomic(XProcRuntime runtime) {
        try {
            ItemTypeFactory itf = new ItemTypeFactory(runtime.getProcessor());
            ItemType untypedAtomic = itf.getAtomicType(new QName("http://www.w3.org/2001/XMLSchema", "xs:untypedAtomic"));
            XdmAtomicValue val = new XdmAtomicValue(this.stringValue, untypedAtomic);
            return val;
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
    }

    public String getString() {
        return this.stringValue;
    }

    public boolean hasGeneralValue() {
        return this.value != null;
    }

    public XdmValue getValue() {
        if (this.value == null) {
            return new XdmAtomicValue(this.stringValue);
        }
        return this.value;
    }

    public StringValue getStringValue() {
        return new StringValue((CharSequence)this.stringValue);
    }

    public QName getQName() {
        if (this.value != null && this.value.size() == 1 && this.value.itemAt(0).getUnderlyingValue() instanceof QNameValue) {
            return new QName(((QNameValue)this.value.itemAt(0).getUnderlyingValue()).getStructuredQName());
        }
        if (this.stringValue.contains(":")) {
            return new QName(this.stringValue, this.node);
        }
        return new QName("", this.stringValue);
    }

    public XdmNode getNode() {
        return this.node;
    }

    public URI getBaseURI() {
        return this.node.getBaseURI();
    }

    public Hashtable<String, String> getNamespaceBindings() {
        return this.nsBindings;
    }

    public boolean getBoolean() {
        if ("true".equals(this.stringValue) || "1".equals(this.stringValue)) {
            return true;
        }
        if ("false".equals(this.stringValue) || "0".equals(this.stringValue)) {
            return false;
        }
        throw new XProcException(this.node, "Non boolean string: " + this.stringValue);
    }

    public int getInt() {
        int result = Integer.parseInt(this.stringValue);
        return result;
    }

    public long getLong() {
        long result = Long.parseLong(this.stringValue);
        return result;
    }

    public XdmSequenceIterator getNamespaces() {
        return this.node.axisIterator(Axis.NAMESPACE);
    }
}

