/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import java.util.Hashtable;
import java.util.Set;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SourceArtifact {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected XdmNode node = null;
    protected XProcRuntime runtime = null;
    protected Hashtable<QName, String> extnAttrs = null;

    public SourceArtifact(XProcRuntime runtime, XdmNode node) {
        this.runtime = runtime;
        this.node = node;
    }

    public XProcRuntime getXProc() {
        return this.runtime;
    }

    public XdmNode getNode() {
        return this.node;
    }

    public String xplFile() {
        if (this.node == null) {
            return "";
        }
        if (this.node.getDocumentURI() == null) {
            return "";
        }
        return this.node.getDocumentURI().toASCIIString();
    }

    public int xplLine() {
        if (this.node == null) {
            return -1;
        }
        return this.node.getLineNumber();
    }

    public void addExtensionAttribute(XdmNode attr) {
        if (this.extnAttrs == null) {
            this.extnAttrs = new Hashtable();
        }
        this.extnAttrs.put(attr.getNodeName(), attr.getStringValue());
    }

    public String getExtensionAttribute(QName name) {
        if (this.extnAttrs == null || !this.extnAttrs.containsKey(name)) {
            return null;
        }
        return this.extnAttrs.get(name);
    }

    public Set<QName> getExtensionAttributes() {
        if (this.extnAttrs == null) {
            this.extnAttrs = new Hashtable();
        }
        return this.extnAttrs.keySet();
    }

    public void error(XProcException error) {
        this.runtime.error(null, error);
    }
}

