/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.EmptyBinding;
import com.xmlcalabash.model.EndPoint;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.ErrorBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeBinding;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Port;
import com.xmlcalabash.model.SourceArtifact;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.util.MessageFormatter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;

public class Step
extends SourceArtifact {
    private static final QName cx_depend = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depend");
    private static final QName cx_depends = new QName("cx", "http://xmlcalabash.com/ns/extensions", "depends");
    private static final QName cx_dependson = new QName("cx", "http://xmlcalabash.com/ns/extensions", "dependson");
    private static final QName cx_message = new QName("cx", "http://xmlcalabash.com/ns/extensions", "message");
    private static final String NS_DAISY_PIPELINE_XPROC = "http://www.daisy.org/ns/pipeline/xproc";
    private static final QName px_message = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "message");
    private static final QName px_progress = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "progress");
    protected QName stepType = null;
    protected String stepName = null;
    private boolean anonymous = false;
    private Optional<Boolean> pure = null;
    protected Vector<Input> inputs = new Vector();
    protected Vector<Output> outputs = new Vector();
    private Vector<Option> options = new Vector();
    private Vector<Log> logs = new Vector();
    private Vector<Parameter> params = new Vector();
    private HashSet<String> dependsOn = new HashSet();
    protected Environment env = null;
    protected Step parent = null;
    private int depth = -1;
    private boolean ordered = false;
    private static HashSet<String> anonNames = new HashSet();
    Vector<Step> subpipeline = new Vector();
    protected DeclareStep declaration = null;
    protected Double version = null;

    public Step(XProcRuntime xproc, XdmNode node, QName type) {
        super(xproc, node);
        this.stepType = type;
        this.stepName = this.anonymousName(node);
    }

    public Step(XProcRuntime xproc, XdmNode node, QName type, String name) {
        super(xproc, node);
        this.stepType = type;
        this.stepName = name;
        if (this.stepName == null) {
            this.stepName = this.anonymousName(node);
        }
    }

    public boolean isPipeline() {
        return false;
    }

    private synchronized String anonymousName(XdmNode node) {
        String stepName = this.recursiveAnonymousName(node);
        anonNames.add(stepName);
        return stepName;
    }

    private String recursiveAnonymousName(XdmNode node) {
        if (node.getParent().getNodeKind() == XdmNodeKind.DOCUMENT) {
            return "!1";
        }
        XdmSequenceIterator iter = node.axisIterator(Axis.PRECEDING_SIBLING);
        int count = 1;
        while (iter.hasNext()) {
            XdmNode pnode = (XdmNode)iter.next();
            if (pnode.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            ++count;
        }
        return this.anonymousName(node.getParent()) + "." + count;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public Optional<Boolean> isPure() {
        if (this.pure == null) {
            XProcException warning;
            String attr = this.getExtensionAttribute(XProcConstants.cx_pure);
            Optional<Boolean> pureAttr = attr != null ? Optional.of(Boolean.parseBoolean(attr)) : Optional.empty();
            boolean containsImpureSteps = false;
            for (Step s : this.subpipeline) {
                if (s.isPure().orElse(true).booleanValue()) continue;
                containsImpureSteps = true;
                break;
            }
            if (containsImpureSteps) {
                if (pureAttr.orElse(false).booleanValue()) {
                    warning = new XProcException(this, "Pipeline was marked with cx:pure=\"true\" but contains impure steps");
                    this.logger.warn(warning.toString());
                }
                this.pure = Optional.of(false);
            } else if (this.getExtensionAttribute(cx_message) != null) {
                if (pureAttr.orElse(false).booleanValue()) {
                    warning = new XProcException(this, "Step was marked with cx:pure=\"true\" but is impure because it has a cx:message attribute");
                    this.logger.warn(warning.toString());
                }
                this.pure = Optional.of(false);
            } else if (this.getExtensionAttribute(px_message) != null) {
                if (pureAttr.orElse(false).booleanValue()) {
                    warning = new XProcException(this, "Step was marked with cx:pure=\"true\" but is impure because it has a px:message attribute");
                    this.logger.warn(warning.toString());
                }
                this.pure = Optional.of(false);
            } else if (this.getExtensionAttribute(px_progress) != null) {
                if (pureAttr.orElse(false).booleanValue()) {
                    warning = new XProcException(this, "Step was marked with cx:pure=\"true\" but is impure because it has a px:progress attribute");
                    this.logger.warn(warning.toString());
                }
                this.pure = Optional.of(false);
            } else {
                this.pure = pureAttr;
            }
        }
        return this.pure;
    }

    public void setDeclaration(DeclareStep decl) {
        this.declaration = decl;
    }

    public DeclareStep getDeclaration() {
        return this.declaration;
    }

    public boolean isPipelineCall() {
        return !this.declaration.isAtomic();
    }

    public QName getType() {
        return this.stepType;
    }

    public Step getStep() {
        return this;
    }

    protected void setVersion(Double version) {
        this.version = version;
    }

    public Double getVersion() {
        if (this.version == null) {
            if (this.parent != null) {
                return this.parent.getVersion();
            }
            throw new UnsupportedOperationException("Step with no version or inherited version!?");
        }
        return this.version;
    }

    public QName getDeclaredType() {
        return this.stepType;
    }

    public String getName() {
        return this.stepName;
    }

    @Override
    public XdmNode getNode() {
        return this.node;
    }

    public Step getPipeline() {
        Step parent = this;
        while (parent != null && parent.stepType != XProcConstants.p_declare_step) {
            parent = parent.parent;
        }
        return parent;
    }

    public boolean containsStep(String stepName) {
        return false;
    }

    public void addStep(Step step) {
        step.parent = this;
        this.subpipeline.add(step);
    }

    public void setSubpipeline(Vector<Step> pipeline) {
        this.subpipeline = pipeline;
    }

    public Vector<Step> subpipeline() {
        return this.subpipeline;
    }

    public void addVariable(Variable variable) {
        throw new UnsupportedOperationException("You can only call addVariable() on a compound step");
    }

    public Collection<Variable> getVariables() {
        return new Vector<Variable>();
    }

    public void addInput(Input input) {
        input.setStep(this);
        for (Input current : this.inputs) {
            if (!current.getPort().equals(input.getPort())) continue;
            throw XProcException.staticError(11, input.getNode(), "Input port name '" + input.getPort() + "' appears more than once.");
        }
        this.inputs.add(input);
    }

    public Vector<Input> inputs() {
        return this.inputs;
    }

    public Input getInput(String portName) {
        for (Input input : this.inputs) {
            if (!portName.equals(input.getPort())) continue;
            return input;
        }
        return null;
    }

    public void addOutput(Output output) {
        output.setStep(this);
        for (Output current : this.outputs) {
            if (!current.getPort().equals(output.getPort())) continue;
            throw XProcException.staticError(11, output.getNode(), "Output port name '" + output.getPort() + "' appears more than once.");
        }
        this.outputs.add(output);
    }

    public Vector<Output> outputs() {
        return this.outputs;
    }

    public Output getPrimaryOutput() {
        int count = 0;
        Output defPrimary = null;
        for (Output output : this.outputs) {
            if ("#current".equals(output.getPort())) continue;
            if (output.getPrimary() || !output.getPrimarySet()) {
                defPrimary = output;
            }
            ++count;
            if (!output.getPrimary()) continue;
            return output;
        }
        if (count == 1) {
            return defPrimary;
        }
        return null;
    }

    public Output getOutput(String portName) {
        for (Output output : this.outputs) {
            if (!portName.equals(output.getPort())) continue;
            return output;
        }
        return null;
    }

    public void addOption(Option option) {
        QName optName = option.getName();
        for (Option exoption : this.options) {
            if (!optName.equals((Object)exoption.getName())) continue;
            this.error(XProcException.staticError(4, option.getNode(), "Duplication option name: " + optName));
        }
        this.options.add(option);
    }

    public Vector<Option> options() {
        return this.options;
    }

    public Option getOption(QName name) {
        for (Option option : this.options) {
            if (!name.equals((Object)option.getName())) continue;
            return option;
        }
        return null;
    }

    public List<QName> getOptions() {
        Vector<QName> names = new Vector<QName>();
        for (Option option : this.options) {
            names.add(option.getName());
        }
        return names;
    }

    public void addLog(Log log) {
        this.logs.add(log);
    }

    public Log getLog(String port) {
        for (Log log : this.logs) {
            if (!port.equals(log.getPort())) continue;
            return log;
        }
        return null;
    }

    public void addParameter(Parameter param) {
        this.params.add(param);
    }

    public Parameter getParameter(QName name) {
        for (Parameter param : this.params) {
            if (!name.equals((Object)param.getName())) continue;
            return param;
        }
        return null;
    }

    public List<QName> getParameters() {
        Vector<QName> names = new Vector<QName>();
        for (Parameter param : this.params) {
            names.add(param.getName());
        }
        return names;
    }

    public Vector<Parameter> parameters() {
        return this.params;
    }

    public boolean loops() {
        return false;
    }

    public boolean insideALoop() {
        if (this.parent == null) {
            return false;
        }
        return this.parent.loops() || this.parent.insideALoop();
    }

    public Output getDefaultOutput() {
        Port defout = null;
        for (Output output : this.outputs) {
            if (output.getPort().startsWith("#") || !output.getPrimary()) continue;
            if (!output.getPort().endsWith("|")) {
                return output;
            }
            defout = output;
        }
        if (defout != null) {
            return defout;
        }
        int count = 0;
        for (Output output : this.outputs) {
            if (output.getPort().startsWith("#") || output.getPort().endsWith("|")) continue;
            if (++count > 1) {
                return null;
            }
            defout = output;
        }
        if (defout != null && !defout.getPrimarySet()) {
            return defout;
        }
        return null;
    }

    protected void addDependency(String stepName) {
        this.dependsOn.add(stepName);
    }

    protected HashSet<String> getDependencies() {
        return this.dependsOn;
    }

    protected boolean dependsOn(String stepName) {
        return this.dependsOn.contains(stepName);
    }

    protected boolean matchesDeclaration() {
        boolean valid = true;
        DeclareStep decl = this.declaration;
        if (decl == null) {
            return true;
        }
        Hashtable<String, Input> declInputs = new Hashtable<String, Input>();
        for (Input input : decl.inputs()) {
            declInputs.put(input.getPort(), input);
        }
        for (Input input : this.inputs()) {
            String port = input.getPort();
            if (port.startsWith("|")) continue;
            if (!declInputs.containsKey(port)) {
                if (this.getVersion() != 1.0) continue;
                this.error(XProcException.staticError(10, "Undeclared input port '" + port + "' on " + this));
                valid = false;
                continue;
            }
            input.setPrimary(((Input)declInputs.get(port)).getPrimary());
        }
        Hashtable<String, Output> declOutputs = new Hashtable<String, Output>();
        for (Output output : decl.outputs()) {
            declOutputs.put(output.getPort(), output);
        }
        for (Output output : this.outputs()) {
            String port = output.getPort();
            if (port.endsWith("|")) continue;
            if (!declOutputs.containsKey(port) && !declOutputs.containsKey("*")) {
                this.error(XProcException.staticError(10, "Undeclared output port: " + port));
                valid = false;
                continue;
            }
            output.setPrimary(((Output)declOutputs.get(port)).getPrimary());
        }
        return valid;
    }

    protected boolean validOptions() {
        HashSet<QName> names = new HashSet<QName>();
        boolean valid = true;
        for (Option option : this.options) {
            valid = valid && option.valid(this.env);
            QName pName = option.getName();
            if (pName == null) {
                valid = false;
                this.error(XProcException.staticError(38, "Option without name"));
                continue;
            }
            if (names.contains(pName)) {
                valid = false;
                this.error(XProcException.staticError(4, "Duplicate option name: " + pName));
                continue;
            }
            names.add(pName);
        }
        DeclareStep decl = this.declaration;
        if (decl != null) {
            for (Option doption : decl.options()) {
                if (!doption.getRequired() || this.getOption(doption.getName()) != null) continue;
                valid = false;
                this.error(XProcException.staticError(18, "Required option not specified: " + doption.getName()));
            }
            Vector<Option> vector = new Vector<Option>();
            for (Option option : this.options()) {
                Option doption = decl.getOption(option.getName());
                if (doption == null) {
                    if (this.getVersion() > 1.0) continue;
                    valid = false;
                    this.error(XProcException.staticError(10, "Undeclared option specified: " + option.getName()));
                    continue;
                }
                vector.add(option);
            }
            this.options = vector;
        }
        return valid;
    }

    protected boolean validParams() {
        HashSet<QName> names = new HashSet<QName>();
        boolean valid = true;
        for (Parameter p : this.params) {
            valid = valid && p.valid(this.env);
            QName pName = p.getName();
            if (pName == null) {
                valid = false;
                this.error(XProcException.staticError(38, "Parameter without name"));
            } else if (names.contains(pName)) {
                valid = false;
                this.error(XProcException.staticError(4, "Duplicate parameter name: " + pName));
            } else {
                names.add(pName);
            }
            String port = p.getPort();
            if (port == null) {
                for (Input input : this.inputs()) {
                    if (!input.getParameterInput() || !input.getPrimary()) continue;
                    port = input.getPort();
                }
                if (port == null) {
                    for (Input input : this.inputs()) {
                        if (!input.getParameterInput()) continue;
                        if (port != null) {
                            this.error(new XProcException(XProcException.err_E0001, "Port not specified and multiple parameter input ports"));
                        }
                        port = input.getPort();
                    }
                }
            }
            if (port == null) {
                valid = false;
                this.error(new XProcException(XProcException.err_E0001, "Port not specified and no primary parameter input port"));
                continue;
            }
            Input input = this.getInput(port);
            if (input != null && input.getParameterInput()) continue;
            valid = false;
            this.error(new XProcException(XProcException.err_E0001, "Port is not a parameter input port: " + port));
        }
        return valid;
    }

    protected boolean validBindings() {
        boolean valid = true;
        boolean seenPrimaryDoc = false;
        boolean seenPrimaryParam = false;
        for (Input input : this.inputs()) {
            if (!input.getPort().startsWith("|") && input.getPrimary()) {
                if (input.getParameterInput()) {
                    if (seenPrimaryParam) {
                        this.error(XProcException.staticError(30, "At most one primary parameter input port is allowed"));
                    }
                    seenPrimaryParam = true;
                } else {
                    if (seenPrimaryDoc) {
                        this.error(XProcException.staticError(30, "At most one primary input port is allowed"));
                    }
                    seenPrimaryDoc = true;
                }
            }
            if (this.checkBinding(input)) continue;
            valid = false;
        }
        for (Option option : this.options()) {
            if (!XProcConstants.p_with_option.equals((Object)option.getNode().getNodeName()) || this.checkOptionBinding(option, true)) continue;
            valid = false;
        }
        for (Parameter param : this.parameters()) {
            if (this.checkOptionBinding(param, true)) continue;
            valid = false;
        }
        return valid;
    }

    protected void checkDuplicateVars(HashSet<QName> vars) {
        for (Variable var : this.getVariables()) {
            if (vars.contains(var.getName())) {
                throw XProcException.staticError(4, this.getNode(), "Duplicate variable name: " + var.getName());
            }
            vars.add(var.getName());
        }
    }

    protected boolean checkBinding(Input input) {
        boolean valid = true;
        this.logger.trace(MessageFormatter.nodeMessage(this.node, "Check bindings for " + input.getPort() + " on " + this.getName()));
        if (input.getBinding().size() == 0) {
            Binding binding3;
            if (input.getParameterInput()) {
                if (input.getPrimary()) {
                    Step pipeline = this.getPipeline();
                    Port paramsin = null;
                    int count = 0;
                    for (Input pinput : pipeline.inputs()) {
                        if (!pinput.getParameterInput()) continue;
                        ++count;
                        if (paramsin != null && !pinput.getPrimary()) continue;
                        paramsin = pinput;
                    }
                    if (paramsin == null || !paramsin.getPrimary() && count > 1) {
                        if (this.params.size() > 0) {
                            binding3 = new EmptyBinding(this.runtime, this.node);
                            input.addBinding(binding3);
                        } else {
                            valid = false;
                            this.error(XProcException.staticError(55, "Parameter input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available."));
                        }
                    } else {
                        binding3 = new PipeNameBinding(this.runtime, this.node);
                        ((PipeNameBinding)binding3).setStep(pipeline.getName());
                        ((PipeNameBinding)binding3).setPort(paramsin.getPort());
                        input.addBinding(binding3);
                    }
                } else {
                    EmptyBinding binding2 = new EmptyBinding(this.runtime, this.node);
                    input.addBinding(binding2);
                }
            } else {
                Port port = this.env.getDefaultReadablePort();
                if (input.getPort().startsWith("|")) {
                    if (this.subpipeline.size() > 0) {
                        Step substep = this.subpipeline.get(this.subpipeline.size() - 1);
                        port = substep.getDefaultOutput();
                    } else if (this.isPipelineCall()) {
                        return true;
                    }
                }
                if (input.getPrimary() && port != null) {
                    String stepName = port.getStep().getName();
                    String portName = port.getPort();
                    binding3 = new PipeNameBinding(this.runtime, this.node);
                    ((PipeNameBinding)binding3).setStep(stepName);
                    ((PipeNameBinding)binding3).setPort(portName);
                    input.addBinding(binding3);
                } else {
                    Input declIn = this.declaration.getInput(input.getPort());
                    if (declIn.getBinding().size() != 0) {
                        input.setSelect(declIn.getSelect());
                        for (Binding binding3 : declIn.getBinding()) {
                            input.addBinding(binding3);
                        }
                    } else {
                        valid = false;
                        this.error(XProcException.staticError(32, "Input " + input.getPort() + " unbound on " + this.getType() + " step named " + this.getName() + " and no default binding available."));
                    }
                }
            }
        }
        boolean catchErrors = false;
        for (Binding binding : input.getBinding()) {
            Step step;
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipe = (PipeNameBinding)binding;
            Output output = this.env.readablePort(pipe.getStep(), pipe.getPort());
            if (output == null) {
                Step fromstep = this.env.visibleStep(pipe.getStep());
                if (fromstep == null) {
                    throw XProcException.staticError(22, binding.getNode(), "No step named \"" + pipe.getStep() + "\" is visible here.");
                }
                if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals((Object)fromstep.getType())) {
                    catchErrors = true;
                    continue;
                }
                if ("http://www.w3.org/ns/xproc".equals(fromstep.getType().getNamespaceURI()) && this.getVersion() > 1.0) {
                    input.setSequence(true);
                    continue;
                }
                this.error(XProcException.staticError(22, binding.getNode(), "No port named \"" + pipe.getPort() + "\" on step named \"" + pipe.getStep() + "\""));
                valid = false;
                continue;
            }
            if (pipe.getPort().equals(output.getPort()) || !XProcConstants.p_viewport.equals((Object)(step = this.env.visibleStep(pipe.getStep())).getType())) continue;
            pipe.setPort(output.getPort());
        }
        if (catchErrors) {
            Vector<Binding> newBindings = new Vector<Binding>();
            SourceArtifact fromstep = null;
            for (Binding binding : input.getBinding()) {
                PipeNameBinding pipe;
                Output output;
                catchErrors = false;
                if (binding.getBindingType() == 1 && (output = this.env.readablePort((pipe = (PipeNameBinding)binding).getStep(), pipe.getPort())) == null) {
                    fromstep = this.env.visibleStep(pipe.getStep());
                    if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals((Object)((Step)fromstep).getType())) {
                        catchErrors = true;
                    }
                }
                if (catchErrors) {
                    newBindings.add(new ErrorBinding(fromstep.getXProc(), ((Step)fromstep).getNode()));
                    continue;
                }
                newBindings.add(binding);
            }
            input.clearBindings();
            for (Binding binding : newBindings) {
                input.addBinding(binding);
            }
        }
        return valid;
    }

    protected boolean checkOptionBinding(EndPoint endpoint) {
        return this.checkOptionBinding(endpoint, false);
    }

    protected boolean checkOptionBinding(EndPoint endpoint, boolean defEmpty) {
        boolean valid = true;
        this.logger.trace(MessageFormatter.nodeMessage(this.node, "Check bindings for " + endpoint + " on " + this.getName()));
        if (endpoint.getBinding().size() == 0) {
            Port port = this.env.getDefaultReadablePort();
            if (port == null) {
                if (defEmpty) {
                    EmptyBinding empty = new EmptyBinding(this.runtime, this.node);
                    endpoint.addBinding(empty);
                } else {
                    valid = false;
                    this.error(XProcException.staticError(32, "" + endpoint + " unbound on " + this.getType() + " step named " + this.getName() + " and no default readable port."));
                }
            } else {
                String stepName = port.getStep().getName();
                String portName = port.getPort();
                PipeNameBinding binding = new PipeNameBinding(this.runtime, this.node);
                binding.setStep(stepName);
                binding.setPort(portName);
                endpoint.addBinding(binding);
            }
        }
        boolean catchErrors = false;
        for (Binding binding : endpoint.getBinding()) {
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipe = (PipeNameBinding)binding;
            Output output = this.env.readablePort(pipe.getStep(), pipe.getPort());
            if (output == null) {
                Step fromstep = this.env.visibleStep(pipe.getStep());
                if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals((Object)fromstep.getType())) {
                    catchErrors = true;
                    continue;
                }
                this.error(XProcException.staticError(22, "Unreadable port: " + pipe.getPort() + " on " + pipe.getStep()));
                valid = false;
                continue;
            }
            if (!XProcConstants.p_variable.equals((Object)endpoint.getNode().getNodeName())) continue;
            Step pipeStep = this.env.visibleStep(pipe.getStep());
            Step container = pipeStep.parent;
            if (container != this) continue;
            throw XProcException.staticError(19, endpoint.getNode(), "Variable binding to " + pipe.getPort() + " on " + pipe.getStep() + " not allowed.");
        }
        if (catchErrors) {
            Vector<Binding> newBindings = new Vector<Binding>();
            SourceArtifact fromstep = null;
            for (Binding binding : endpoint.getBinding()) {
                PipeNameBinding pipe;
                Output output;
                catchErrors = false;
                if (binding.getBindingType() == 1 && (output = this.env.readablePort((pipe = (PipeNameBinding)binding).getStep(), pipe.getPort())) == null) {
                    fromstep = this.env.visibleStep(pipe.getStep());
                    if ("error".equals(pipe.getPort()) && XProcConstants.p_catch.equals((Object)((Step)fromstep).getType())) {
                        catchErrors = true;
                    }
                }
                if (catchErrors) {
                    newBindings.add(new ErrorBinding(fromstep.getXProc(), ((Step)fromstep).getNode()));
                    continue;
                }
                newBindings.add(binding);
            }
            endpoint.clearBindings();
            for (Binding binding : newBindings) {
                endpoint.addBinding(binding);
            }
        }
        return valid;
    }

    protected void checkForBindings(HashSet<Output> outputs) {
        PipeNameBinding b;
        Output output;
        for (Input input : this.inputs()) {
            for (Binding binding : input.bindings) {
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
        for (Option option : this.options()) {
            for (Binding binding : option.bindings) {
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
        for (Parameter param : this.parameters()) {
            for (Binding binding : param.bindings) {
                if (binding.getBindingType() != 1 || !outputs.contains(output = this.env.readablePort((b = (PipeNameBinding)binding).getStep(), b.getPort()))) continue;
                outputs.remove(output);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean orderSteps() {
        PipeNameBinding pipe;
        boolean valid = true;
        if (this.ordered) {
            return true;
        }
        this.ordered = true;
        for (Step step : this.subpipeline) {
            if (step.orderSteps()) continue;
            valid = false;
        }
        this.logger.trace(MessageFormatter.nodeMessage(this.node, "Checking step order for " + this.getName()));
        if (this.getExtensionAttribute(cx_depend) != null || this.getExtensionAttribute(cx_depends) != null || this.getExtensionAttribute(cx_dependson) != null) {
            throw new XProcException(this, "The correct spelling of the depends-on attribute is cx:depends-on.");
        }
        String dependsOn = this.getExtensionAttribute(XProcConstants.cx_depends_on);
        if (dependsOn != null) {
            Step step = this.env.visibleStep(dependsOn);
            if (step == null) {
                throw new XProcException(this, "The value of cx:depends-on must be the name of an in-scope step: " + dependsOn);
            }
            this.addDependency(dependsOn);
        }
        for (Input input : this.inputs) {
            for (Binding binding : input.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipe = (PipeNameBinding)binding;
                this.logger.trace(MessageFormatter.nodeMessage(this.node, this.getName() + " input " + input.getPort() + " depends on " + pipe.getStep()));
                this.addDependency(pipe.getStep());
            }
        }
        for (Parameter parameter : this.params) {
            for (Binding binding : parameter.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipe = (PipeNameBinding)binding;
                this.logger.trace(MessageFormatter.nodeMessage(this.node, this.getName() + " param depends on " + pipe.getStep()));
                this.addDependency(pipe.getStep());
            }
        }
        for (Option option : this.options) {
            for (Binding binding : option.getBinding()) {
                if (binding.getBindingType() != 1) continue;
                pipe = (PipeNameBinding)binding;
                this.logger.trace(MessageFormatter.nodeMessage(this.node, this.getName() + " option depends on " + pipe.getStep()));
                this.addDependency(pipe.getStep());
            }
        }
        this.checkVariables();
        Vector<Step> vector = new Vector<Step>();
        for (Step step : this.subpipeline) {
            HashSet<String> deps = step.getDependencies();
            boolean root = true;
            for (String string : deps) {
                if (!string.equals(this.getName())) {
                    this.logger.trace(MessageFormatter.nodeMessage(this.node, this.getName() + " step " + step.getName() + " depends on " + string));
                    this.addDependency(string);
                }
                if (!this.containsStep(string)) continue;
                root = false;
            }
            if (!root) continue;
            this.logger.trace(MessageFormatter.nodeMessage(this.node, "==> " + step.getName() + " is a graph root of " + this.getName()));
            vector.add(step);
            step.depth = 0;
        }
        if (this.subpipeline.size() > 0) {
            if (vector.size() == 0) {
                this.error(XProcException.staticError(1, "No roots in " + this.getName()));
                valid = false;
            } else {
                int n;
                void var3_10;
                boolean bl = true;
                boolean noloops = true;
                while (noloops && var3_10.size() > 0) {
                    Vector nextWave = new Vector();
                    for (Step root2 : var3_10) {
                        for (Step step : this.subpipeline) {
                            if (step.dependsOn(root2.getName())) {
                                this.logger.trace(MessageFormatter.nodeMessage(this.node, "XProcStep " + step.getName() + " depends on " + root2.getName() + "(step.depth=" + step.depth + ", depth=" + n + ")"));
                                if (step.depth < 0 || n >= step.depth) {
                                    step.depth = n;
                                    this.logger.trace(MessageFormatter.nodeMessage(this.node, step.getName() + " gets depth " + n));
                                    nextWave.add(step);
                                    continue;
                                }
                                noloops = false;
                                this.error(XProcException.staticError(1, "Loop in subpipeline: " + step.getName() + " points back to " + root2.getName()));
                                continue;
                            }
                            this.logger.trace(MessageFormatter.nodeMessage(this.node, "XProcStep " + step.getName() + " does not depend on " + root2.getName()));
                        }
                    }
                    Object object = nextWave;
                    ++n;
                }
                if (noloops) {
                    for (Step step : this.subpipeline) {
                        if (step.depth >= 0) continue;
                        noloops = false;
                        this.error(XProcException.staticError(1, "Closed loop in subpipeline involves: " + step.getName()));
                    }
                }
                boolean bl2 = valid = valid && noloops;
                if (valid) {
                    Vector<Step> sorted = new Vector<Step>();
                    for (int wave = 0; wave < n; ++wave) {
                        for (Step step : this.subpipeline) {
                            if (step.depth != wave) continue;
                            sorted.add(step);
                        }
                    }
                    this.subpipeline = sorted;
                }
            }
        }
        return valid;
    }

    public void checkVariables() {
    }

    public boolean valid() {
        boolean valid = this.validParams();
        if (!this.matchesDeclaration()) {
            valid = false;
        }
        if (!this.validOptions()) {
            valid = false;
        }
        if (!this.validBindings()) {
            valid = false;
        }
        for (Log log : this.logs) {
            Output output = this.getOutput(log.getPort());
            if (output != null) continue;
            this.error(XProcException.staticError(26, "A p:log specified for a bad port: " + log.getPort()));
            valid = false;
        }
        if (this.env.countVisibleSteps(this.getName()) > 1) {
            this.error(XProcException.staticError(2, "Duplicate step name: " + this.getName()));
            valid = false;
        }
        return valid;
    }

    protected void augmentIO() {
        DeclareStep decl = this.declaration;
        if (decl == null) {
            throw new UnsupportedOperationException("Unexpected step type.");
        }
        Hashtable<String, Input> declInputs = new Hashtable<String, Input>();
        for (Input input : decl.inputs()) {
            declInputs.put(input.getPort(), input);
        }
        int position = 0;
        for (Input input : this.inputs()) {
            ++position;
        }
        for (Parameter param : this.parameters()) {
            ++position;
        }
        for (String portName : declInputs.keySet()) {
            Input dinput = (Input)declInputs.get(portName);
            Input input = this.getInput(portName);
            if (input == null) {
                this.logger.trace(MessageFormatter.nodeMessage(this.node, "Added " + portName + " input to " + this.getName()));
                input = new Input(this.runtime, this.node);
                input.setPort(portName);
                input.setParameterInput(dinput.getParameterInput());
                if (dinput.getPrimarySet()) {
                    input.setPrimary(dinput.getPrimary());
                }
                input.setSequence(dinput.getSequence());
                input.setPosition(++position);
                this.addInput(input);
                continue;
            }
            input.setParameterInput(dinput.getParameterInput());
            input.setPrimary(dinput.getPrimary());
            input.setSequence(dinput.getSequence());
        }
        Hashtable<String, Output> hashtable = new Hashtable<String, Output>();
        for (Output output : decl.outputs()) {
            hashtable.put(output.getPort(), output);
        }
        for (String portName : hashtable.keySet()) {
            Output doutput = (Output)hashtable.get(portName);
            Output output = this.getOutput(portName);
            if (output != null) continue;
            this.logger.trace(MessageFormatter.nodeMessage(this.node, "Added " + portName + " output to " + this.getName()));
            output = new Output(this.runtime, this.node);
            output.setPort(portName);
            output.setSequence(doutput.getSequence());
            if (doutput.getPrimarySet()) {
                output.setPrimary(doutput.getPrimary());
            }
            this.addOutput(output);
        }
    }

    protected void augmentOptions() {
        DeclareStep decl = this.declaration;
        if (decl == null) {
            throw new UnsupportedOperationException("Unexpected step type: " + this.getType());
        }
        Hashtable<QName, Option> declOptions = new Hashtable<QName, Option>();
        for (Option option : decl.options()) {
            declOptions.put(option.getName(), option);
        }
        for (QName oname : declOptions.keySet()) {
            Option doption = (Option)declOptions.get(oname);
            Option option = this.getOption(oname);
            if (option == null) {
                if (doption.getSelect() == null && doption.getBinding().size() == 0) continue;
                this.addOption(doption);
                continue;
            }
            option.setType(doption.getType(), doption.getTypeAsQName());
            option.setSequenceType(doption.getSequenceType());
        }
    }

    public void augment() {
        this.augmentIO();
        this.augmentOptions();
    }

    public void patchPipeBindings() {
        for (Input input : this.inputs) {
            this.patchInputBindings(input);
        }
        for (Parameter param : this.params) {
            this.patchInputBindings(param);
        }
        for (Option option : this.options) {
            this.patchInputBindings(option);
        }
        for (Variable var : this.getVariables()) {
            this.patchInputBindings(var);
        }
        for (Step step : this.subpipeline) {
            step.patchPipeBindings();
        }
    }

    protected void patchInputBindings(EndPoint endpoint) {
        Vector<Binding> bindings = endpoint.getBinding();
        for (int bpos = 0; bpos < bindings.size(); ++bpos) {
            Binding binding = bindings.get(bpos);
            if (binding.getBindingType() != 1) continue;
            PipeNameBinding pipename = (PipeNameBinding)binding;
            PipeBinding pipe = new PipeBinding(this.runtime, pipename.node);
            Output source = this.env.readablePort(pipename.getStep(), pipename.getPort());
            pipe.setOutput(source);
            pipe.setInput(endpoint);
            bindings.set(bpos, pipe);
            if (source == null) continue;
            source.addBinding(pipe);
        }
    }

    protected void setEnvironment(Environment newEnvironment) {
        this.env = newEnvironment;
    }

    protected void patchEnvironment(Environment env) {
    }

    public Environment getEnvironment() {
        return this.env;
    }

    public String toString() {
        String str = null;
        str = this.stepName.startsWith("#") ? "anonymous step " + this.stepType : "step " + this.stepType + " named " + this.stepName;
        str = this.node.getLineNumber() > 0 ? str + " at " + this.node.getDocumentURI() + ":" + this.node.getLineNumber() : str + " in " + this.node.getDocumentURI();
        return str;
    }

    public void dump() {
        this.logger.trace("============================================================================");
        this.dump(0);
    }

    protected void dump(int depth) {
        String indent = "";
        for (int count = 0; count < depth; ++count) {
            indent = indent + " ";
        }
        if (this.getType().getNamespaceURI().equals("http://www.w3.org/ns/xproc")) {
            this.logger.trace(indent + this.getType().getLocalName() + " " + this.getName());
        } else {
            this.logger.trace(indent + "XProcStep " + this.getName() + " (" + this.getType() + ")");
        }
        for (Input input : this.inputs) {
            input.dump(depth + 2);
        }
        for (Output output : this.outputs) {
            output.dump(depth + 2);
        }
        for (Parameter param : this.params) {
            param.dump(depth + 2);
        }
        for (Option option : this.options) {
            option.dump(depth + 2);
        }
        for (Variable var : this.getVariables()) {
            var.dump(depth + 2);
        }
        for (Step step : this.subpipeline) {
            step.dump(depth + 2);
        }
    }
}

