/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.piperack;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.piperack.BaseResource;
import com.xmlcalabash.piperack.PipelineConfiguration;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.TreeWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.regex.Matcher;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.xml.sax.InputSource;

public class Pipeline
extends BaseResource {
    protected Representation get(Variant variant) {
        String id = (String)this.getRequest().getAttributes().get("id");
        if (!this.getPipelines().containsKey(id)) {
            return this.badRequest(Status.CLIENT_ERROR_NOT_FOUND, "no pipeline: " + this.pipelineUri(id), variant.getMediaType());
        }
        TreeWriter tree = new TreeWriter(this.getGlobalRuntime());
        tree.startDocument(URI.create("http://example.com/"));
        PipelineConfiguration pipeconfig = (PipelineConfiguration)this.getPipelines().get(id);
        tree.addStartElement(pr_pipeline);
        tree.startContent();
        tree.addStartElement(pr_uri);
        tree.startContent();
        tree.addText(this.pipelineUri(id));
        tree.addEndElement();
        this.formatExpires(tree, pipeconfig.expires);
        tree.addStartElement(pr_has_run);
        tree.startContent();
        tree.addText("" + pipeconfig.ran);
        tree.addEndElement();
        if (pipeconfig.ran) {
            for (String port : pipeconfig.outputPorts) {
                tree.addStartElement(pr_output);
                if (port.equals(pipeconfig.defoutput)) {
                    tree.addAttribute(_primary, "true");
                }
                tree.addAttribute(_documents, "" + pipeconfig.outputs.get(port).size());
                tree.startContent();
                tree.addText(port);
                tree.addEndElement();
            }
        } else {
            XPipeline xpipeline = pipeconfig.pipeline;
            DeclareStep pipeline = xpipeline.getDeclareStep();
            for (String port : pipeconfig.inputPorts) {
                tree.addStartElement(pr_input);
                if (port.equals(pipeconfig.definput)) {
                    tree.addAttribute(_primary, "true");
                }
                tree.addAttribute(_documents, "" + pipeconfig.documentCount(port));
                tree.startContent();
                tree.addText(port);
                tree.addEndElement();
            }
            for (QName name : pipeline.getOptions()) {
                tree.addStartElement(pr_option);
                tree.startContent();
                tree.addStartElement(pr_name);
                if (!"".equals(name.getPrefix())) {
                    tree.addNamespace(name.getPrefix(), name.getNamespaceURI());
                }
                tree.startContent();
                tree.addText(name.toString());
                tree.addEndElement();
                tree.addStartElement(pr_value);
                if (pipeconfig.options.containsKey(name)) {
                    tree.startContent();
                    tree.addText(pipeconfig.options.get(name));
                } else if (pipeconfig.gvOptions.contains(name)) {
                    tree.addAttribute(_initialized, "true");
                    tree.startContent();
                } else {
                    tree.addAttribute(_default, "true");
                    tree.startContent();
                }
                tree.addEndElement();
                tree.addEndElement();
            }
            for (QName name : pipeconfig.parameters.keySet()) {
                tree.addStartElement(pr_parameter);
                tree.startContent();
                tree.addStartElement(pr_name);
                if (!"".equals(name.getPrefix())) {
                    tree.addNamespace(name.getPrefix(), name.getNamespaceURI());
                }
                tree.startContent();
                tree.addText(name.toString());
                tree.addEndElement();
                tree.addStartElement(pr_value);
                tree.startContent();
                tree.addText(pipeconfig.parameters.get(name));
                tree.addEndElement();
                tree.addEndElement();
            }
            for (QName name : pipeconfig.gvParameters) {
                tree.addStartElement(pr_parameter);
                tree.startContent();
                tree.addStartElement(pr_name);
                tree.startContent();
                tree.addText(name.toString());
                tree.addEndElement();
                tree.addStartElement(pr_value);
                tree.addAttribute(_initialized, "true");
                tree.startContent();
                tree.addEndElement();
                tree.addEndElement();
            }
        }
        tree.addEndElement();
        tree.endDocument();
        return new StringRepresentation((CharSequence)this.serialize(tree.getResult(), variant.getMediaType()), variant.getMediaType());
    }

    protected Representation post(Representation entity, Variant variant) {
        String id = (String)this.getRequest().getAttributes().get("id");
        if (!this.getPipelines().containsKey(id)) {
            return this.badRequest(Status.CLIENT_ERROR_NOT_FOUND, "no pipeline: " + this.pipelineUri(id), variant.getMediaType());
        }
        PipelineConfiguration pipeconfig = (PipelineConfiguration)this.getPipelines().get(id);
        XPipeline xpipeline = pipeconfig.pipeline;
        XProcRuntime runtime = pipeconfig.runtime;
        if (pipeconfig.ran) {
            pipeconfig.reset();
            xpipeline.reset();
        }
        try {
            if (MediaType.MULTIPART_FORM_DATA.equals((Object)entity.getMediaType(), true)) {
                this.processMultipartForm(pipeconfig, entity, variant);
            } else {
                if (pipeconfig.definput == null) {
                    return this.badRequest(Status.CLIENT_ERROR_BAD_REQUEST, "No primary input port", variant.getMediaType());
                }
                if (pipeconfig.documentCount(pipeconfig.definput) == 0) {
                    xpipeline.clearInputs(pipeconfig.definput);
                }
                pipeconfig.writeTo(pipeconfig.definput);
                XdmNode doc = null;
                if (this.isXml(entity.getMediaType())) {
                    doc = runtime.parse(new InputSource(entity.getStream()));
                    this.logger.debug("Posting XML document to " + pipeconfig.definput + " for " + id);
                } else {
                    ReadableData pipe = null;
                    pipe = new ReadableData(runtime, XProcConstants.c_data, entity.getStream(), entity.getMediaType().toString());
                    doc = pipe.read();
                    this.logger.debug("Posting non-XML document to " + pipeconfig.definput + " for " + id);
                }
                xpipeline.writeTo(pipeconfig.definput, doc);
                HashMap<String, String> nsBindings = this.bindingsFromForm(this.getQuery());
                HashMap<String, String> options = this.convertFormStrings(this.getQuery());
                DeclareStep pipeline = xpipeline.getDeclareStep();
                for (String fieldName : options.keySet()) {
                    RuntimeValue value = new RuntimeValue(options.get(fieldName));
                    if (fieldName.startsWith("-p")) {
                        fieldName = fieldName.substring(2);
                        String port = null;
                        Matcher matcher = portRE.matcher(fieldName);
                        if (matcher.matches()) {
                            port = matcher.group(1);
                            fieldName = matcher.group(2);
                        }
                        if (port == null) {
                            for (String iport : xpipeline.getInputs()) {
                                Input input = pipeline.getInput(iport);
                                if (!input.getParameterInput() || !input.getPrimary()) continue;
                                port = iport;
                            }
                        }
                        if (port == null) {
                            throw new XProcException("No primary parameter input port.");
                        }
                        this.logger.debug("Parameter " + fieldName + "=" + value.getString() + " for " + id);
                        QName qname = this.qnameFromForm(fieldName, nsBindings);
                        xpipeline.setParameter(port, qname, value);
                        pipeconfig.setParameter(qname, value.getString());
                        continue;
                    }
                    this.logger.debug("Option " + fieldName + "=" + value.getString() + " for " + id);
                    QName qname = this.qnameFromForm(fieldName, nsBindings);
                    xpipeline.passOption(qname, value);
                    pipeconfig.setGVOption(qname);
                }
            }
        }
        catch (Exception e) {
            pipeconfig.reset();
            xpipeline.reset();
            return this.badRequest(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage(), variant.getMediaType());
        }
        return this.runPipeline(id);
    }

    protected Representation delete(Variant variant) {
        String id = (String)this.getRequest().getAttributes().get("id");
        if (!this.getPipelines().containsKey(id)) {
            return this.badRequest(Status.CLIENT_ERROR_NOT_FOUND, "no pipeline: " + this.pipelineUri(id), variant.getMediaType());
        }
        this.getPipelines().remove(id);
        this.setStatus(Status.SUCCESS_OK);
        return new EmptyRepresentation();
    }
}

