/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadOnlyPipe;
import com.xmlcalabash.io.ReadableDocument;
import com.xmlcalabash.io.ReadableInline;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.ComputableValue;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.InlineBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.SequenceType;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XCatch;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XSelect;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.XProcCollectionFinder;
import com.xmlcalabash.util.XProcMessageListenerHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;

public class XAtomicStep
extends XStep {
    private static final QName _name = new QName("", "name");
    private static final QName _namespace = new QName("", "namespace");
    private static final QName _value = new QName("", "value");
    private static final QName _type = new QName("", "type");
    private static final QName cx_item = new QName("cx", "http://xmlcalabash.com/ns/extensions", "item");

    public XAtomicStep(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step);
        this.parent = parent;
        if (parent != null) {
            this.parentLocation = parent.getLocation();
        }
    }

    @Override
    public XCompoundStep getParent() {
        return this.parent;
    }

    public boolean hasReadablePipes(String port) {
        if (this.inputs.containsKey(port)) {
            return ((Vector)this.inputs.get(port)).size() > 0;
        }
        return false;
    }

    public boolean hasWriteablePipe(String port) {
        return this.outputs.containsKey(port);
    }

    @Override
    public RuntimeValue optionAvailable(QName optName) {
        if (!this.inScopeOptions.containsKey(optName)) {
            return null;
        }
        return (RuntimeValue)this.inScopeOptions.get(optName);
    }

    protected ReadablePipe getPipeFromBinding(Binding binding) {
        ReadablePipe pipe = null;
        if (binding.getBindingType() == 1) {
            PipeNameBinding pnbinding = (PipeNameBinding)binding;
            XCompoundStep start = this.parent;
            if (this instanceof XCompoundStep) {
                start = (XCompoundStep)this;
            }
            pipe = start.getBinding(pnbinding.getStep(), pnbinding.getPort());
            pipe.setNames(pnbinding.getStep(), pnbinding.getPort());
        } else if (binding.getBindingType() == 2) {
            InlineBinding ibinding = (InlineBinding)binding;
            pipe = new ReadableInline(this.runtime, ibinding.nodes(), ibinding.getExcludedNamespaces());
        } else if (binding.getBindingType() == 5) {
            pipe = new ReadableDocument(this.runtime);
        } else if (binding.getBindingType() == 3) {
            DocumentBinding dbinding = (DocumentBinding)binding;
            pipe = this.runtime.getConfigurer().getXMLCalabashConfigurer().makeReadableDocument(this.runtime, dbinding);
        } else if (binding.getBindingType() == 8) {
            DataBinding dbinding = (DataBinding)binding;
            pipe = this.runtime.getConfigurer().getXMLCalabashConfigurer().makeReadableData(this.runtime, dbinding);
        } else if (binding.getBindingType() == 7) {
            XCompoundStep step = this.parent;
            while (!(step instanceof XCatch)) {
                step = step.getParent();
            }
            pipe = step.getBinding(step.getName(), "error");
        } else {
            throw new XProcException(binding.getNode(), "Unknown binding type: " + binding.getBindingType());
        }
        pipe.setReader(this.step);
        return pipe;
    }

    protected void instantiateReaders(Step step) {
        for (Input input : step.inputs()) {
            String port = input.getPort();
            if (port.startsWith("|")) continue;
            Vector readers = null;
            if (this.inputs.containsKey(port)) {
                readers = (Vector)this.inputs.get(port);
            } else {
                readers = new Vector();
                this.inputs.put(port, readers);
            }
            for (Binding binding : input.getBinding()) {
                ReadablePipe pipe = this.getPipeFromBinding(binding);
                pipe.canReadSequence(input.getSequence());
                if (input.getSelect() != null) {
                    this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), step.getName() + " selects from " + pipe + " for " + port));
                    pipe = new XSelect(this.runtime, this, pipe, input.getSelect(), input.getNode());
                }
                readers.add(pipe);
                this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), step.getName() + " reads from " + pipe + " for " + port));
            }
            XInput xinput = new XInput(this.runtime, input);
            this.addInput(xinput);
        }
    }

    @Override
    public void instantiate(Step step) {
        this.instantiateReaders(step);
        for (Output output : step.outputs()) {
            String port = output.getPort();
            XOutput xoutput = new XOutput(this.runtime, output);
            xoutput.setLogger(step.getLog(port));
            this.addOutput(xoutput);
            Pipe wpipe = xoutput.getWriter();
            wpipe.canWriteSequence(output.getSequence());
            this.outputs.put(port, wpipe);
            this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), step.getName() + " writes to " + wpipe + " for " + port));
        }
        this.parent.addStep(this);
    }

    protected void computeParameters(XProcStep xstep) throws SaxonApiException {
        Vector<String> paramPorts = new Vector<String>();
        boolean primaryParamPort = false;
        for (Input input : this.step.inputs()) {
            if (!input.getParameterInput()) continue;
            primaryParamPort |= input.getPrimary();
            paramPorts.add(input.getPort());
        }
        int position = 0;
        boolean loopdone = false;
        while (!loopdone) {
            ++position;
            loopdone = true;
            for (Parameter p : this.step.parameters()) {
                if ("http://www.w3.org/ns/xproc".equals(p.getName().getNamespaceURI())) {
                    throw XProcException.dynamicError(31);
                }
                boolean bl = loopdone = p.getPosition() <= position;
                if (p.getPosition() != position) continue;
                loopdone = false;
                if (!primaryParamPort) {
                    String port = p.getPort();
                    if (port == null) {
                        throw XProcException.staticError(34, this.step.getNode(), "No parameter input port.");
                    }
                    xstep.setParameter(p.getPort(), p.getName(), this.computeValue(p));
                    continue;
                }
                xstep.setParameter(p.getName(), this.computeValue(p));
            }
            for (String port : paramPorts) {
                Input input = this.step.getInput(port);
                boolean bl = loopdone = loopdone && input.getPosition() <= position;
                if (input.getPosition() != position) continue;
                for (ReadablePipe source : (Vector)this.inputs.get(port)) {
                    while (source.moreDocuments()) {
                        XdmNode node = source.read();
                        XdmNode docelem = S9apiUtils.getDocumentElement(node);
                        if (XProcConstants.c_param_set.equals((Object)docelem.getNodeName())) {
                            for (XdmNode attr : new AxisNodes(docelem, Axis.ATTRIBUTE)) {
                                QName aname = attr.getNodeName();
                                if (!"".equals(aname.getNamespaceURI()) && !"http://www.w3.org/ns/xproc".equals(aname.getNamespaceURI())) continue;
                                throw XProcException.dynamicError(14, this.step.getNode(), "Attribute not allowed");
                            }
                            for (XdmNode child : new AxisNodes(this.runtime, docelem, Axis.CHILD, 7)) {
                                if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                                if (!child.getNodeName().equals((Object)XProcConstants.c_param)) {
                                    throw XProcException.dynamicError(18, this.step.getNode(), "Element not allowed: " + child.getNodeName());
                                }
                                this.parseParameterNode(xstep, child);
                            }
                            continue;
                        }
                        if (XProcConstants.c_param.equals((Object)docelem.getNodeName())) {
                            this.parseParameterNode(xstep, docelem);
                            continue;
                        }
                        throw new XProcException(this.step, docelem.getNodeName() + " found where c:param or c:param-set expected");
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
        for (String port : this.inputs.keySet()) {
            for (ReadablePipe rpipe : (Vector)this.inputs.get(port)) {
                rpipe.resetReader();
            }
        }
        for (String port : this.outputs.keySet()) {
            WritablePipe wpipe = (WritablePipe)this.outputs.get(port);
            wpipe.resetWriter();
        }
        this.clearOptions();
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws SaxonApiException {
        XdmNode doc;
        XProcStep xstep = this.runtime.getConfiguration().newStep(this.runtime, this);
        for (String port : this.inputs.keySet()) {
            int totalDocs = 0;
            Input input = this.step.getInput(port);
            if (!input.getParameterInput()) {
                ReadablePipe pipe;
                int readerCount = ((Vector)this.inputs.get(port)).size();
                if (readerCount > 1) {
                    pipe = new Pipe(this.runtime);
                    ((Pipe)pipe).setWriter(this.step);
                    ((ReadOnlyPipe)pipe).setReader(this.step);
                    ((Pipe)pipe).canWriteSequence(true);
                    ((ReadOnlyPipe)pipe).canReadSequence(input.getSequence());
                    for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                        if (reader.moreDocuments()) {
                            while (reader.moreDocuments()) {
                                doc = reader.read();
                                ((Pipe)pipe).write(doc);
                                ++totalDocs;
                            }
                            continue;
                        }
                        if (!(reader instanceof ReadableDocument)) continue;
                        ++totalDocs;
                    }
                    xstep.setInput(port, pipe);
                } else if (readerCount == 1) {
                    pipe = (ReadablePipe)((Vector)this.inputs.get(port)).firstElement();
                    pipe.setReader(this.step);
                    if (pipe.moreDocuments()) {
                        totalDocs += pipe.documentCount();
                    } else if (pipe instanceof ReadableDocument) {
                        ++totalDocs;
                    }
                    xstep.setInput(port, pipe);
                }
            }
            if (totalDocs == true || input.getSequence()) continue;
            throw XProcException.dynamicError(6, this, totalDocs + " documents appear on the '" + port + "' port.");
        }
        for (String port : this.outputs.keySet()) {
            xstep.setOutput(port, (WritablePipe)this.outputs.get(port));
        }
        DeclareStep decl = this.step.getDeclaration();
        this.inScopeOptions = this.parent.getInScopeOptions();
        Hashtable<QName, RuntimeValue> futureOptions = new Hashtable<QName, RuntimeValue>();
        for (QName name : this.step.getOptions()) {
            String type;
            Option option = this.step.getOption(name);
            RuntimeValue value = this.computeValue(option);
            Option optionDecl = decl.getOption(name);
            if (optionDecl.getTypeAsQName() != null) {
                TypeUtils.checkType(this.runtime, value.hasGeneralValue() ? value.getValue() : null, value.getString(), optionDecl.getTypeAsQName(), option.getNode());
            } else if (optionDecl.getType() != null && (type = optionDecl.getType()).contains("|")) {
                TypeUtils.checkLiteral(value.getString(), type);
            }
            xstep.setOption(name, value);
            futureOptions.put(name, value);
        }
        for (QName opt : futureOptions.keySet()) {
            this.inScopeOptions.put(opt, futureOptions.get(opt));
        }
        xstep.reset();
        this.computeParameters(xstep);
        if (XProcConstants.p_in_scope_names.equals((Object)this.step.getType())) {
            for (QName name : this.inScopeOptions.keySet()) {
                xstep.setParameter(name, (RuntimeValue)this.inScopeOptions.get(name));
            }
        }
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        this.runtime.start(this);
        try {
            XProcMessageListenerHelper.openStep(this.runtime, this);
            try {
                xstep.run();
            }
            catch (RuntimeException e) {
                if (!(e instanceof XProcException)) {
                    this.logger.error("An unexpected runtime exception happened: " + XProcException.fromException(e).rebase(this.getLocation(), new RuntimeException().getStackTrace()).toString());
                }
                throw e;
            }
            finally {
                this.runtime.getMessageListener().closeStep();
            }
            String cache = this.getInheritedExtensionAttribute(XProcConstants.cx_cache);
            if ("true".equals(cache)) {
                for (String port : this.outputs.keySet()) {
                    WritablePipe wpipe = (WritablePipe)this.outputs.get(port);
                    if (!(wpipe instanceof Pipe)) continue;
                    ReadOnlyPipe rpipe = new ReadOnlyPipe(this.runtime, ((Pipe)wpipe).documents());
                    rpipe.canReadSequence(true);
                    rpipe.setReader(this.step);
                    while (rpipe.moreDocuments()) {
                        doc = rpipe.read();
                        this.runtime.cache(doc, this.step.getNode().getBaseURI());
                    }
                }
            } else if (!"false".equals(cache) && cache != null) {
                throw XProcException.dynamicError(19);
            }
        }
        finally {
            this.runtime.finish(this);
            data.closeFrame();
        }
    }

    public void reportError(XdmNode doc) {
        this.parent.reportError(doc);
    }

    public void reportError(XProcException exception) {
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.getNode().getBaseURI());
        exception.serialize(treeWriter);
        treeWriter.endDocument();
        this.reportError(treeWriter.getResult());
    }

    private void parseParameterNode(XProcStep impl, XdmNode pnode) {
        String value = pnode.getAttributeValue(_value);
        if (value == null && this.runtime.getAllowGeneralExpressions()) {
            this.parseParameterValueNode(impl, pnode);
            return;
        }
        Parameter p = new Parameter(this.step.getXProc(), pnode);
        String port = p.getPort();
        String name = pnode.getAttributeValue(_name);
        String ns = pnode.getAttributeValue(_namespace);
        QName pname = null;
        if (ns == null) {
            pname = name.contains(":") ? new QName(name, pnode) : new QName(name);
        } else {
            QName testNode;
            int pos = name.indexOf(":");
            if (pos > 0 && !ns.equals((testNode = new QName(name = name.substring(pos), pnode)).getNamespaceURI())) {
                throw XProcException.dynamicError(25);
            }
            pname = new QName(ns, name);
        }
        if ("http://www.w3.org/ns/xproc".equals(pname.getNamespaceURI())) {
            throw XProcException.dynamicError(31);
        }
        p.setName(pname);
        for (XdmNode attr : new AxisNodes(pnode, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (!"".equals(aname.getNamespaceURI()) || aname.equals((Object)_name) || aname.equals((Object)_namespace) || aname.equals((Object)_value)) continue;
            throw XProcException.dynamicError(14);
        }
        if (port != null) {
            impl.setParameter(port, pname, new RuntimeValue(value, pnode));
        } else {
            impl.setParameter(pname, new RuntimeValue(value, pnode));
        }
    }

    private void parseParameterValueNode(XProcStep impl, XdmNode pnode) {
        Parameter p = new Parameter(this.step.getXProc(), pnode);
        String port = p.getPort();
        String name = pnode.getAttributeValue(_name);
        String ns = pnode.getAttributeValue(_namespace);
        QName pname = null;
        if (ns == null) {
            pname = new QName(name, pnode);
        } else {
            QName testNode;
            int pos = name.indexOf(":");
            if (pos > 0 && !ns.equals((testNode = new QName(name = name.substring(pos), pnode)).getNamespaceURI())) {
                throw XProcException.dynamicError(25);
            }
            pname = new QName(ns, name);
        }
        p.setName(pname);
        for (XdmNode attr : new AxisNodes(pnode, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if (!"".equals(aname.getNamespaceURI()) || aname.equals((Object)_name) || aname.equals((Object)_namespace)) continue;
            throw XProcException.dynamicError(14);
        }
        String stringValue = "";
        Vector<Object> items = new Vector<Object>();
        for (XdmNode child : new AxisNodes(this.runtime, pnode, Axis.CHILD, 31)) {
            if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            if (!child.getNodeName().equals((Object)cx_item)) {
                throw XProcException.dynamicError(18, this.step.getNode(), "Element not allowed: " + child.getNodeName());
            }
            String type = child.getAttributeValue(_type);
            if (type == null) {
                Vector<XdmValue> nodes = new Vector<XdmValue>();
                URI baseURI = null;
                XdmSequenceIterator iter = child.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    XdmNode gchild = (XdmNode)iter.next();
                    if (baseURI == null && gchild.getNodeKind() == XdmNodeKind.ELEMENT) {
                        baseURI = gchild.getBaseURI();
                    }
                    nodes.add((XdmValue)gchild);
                }
                XdmDestination dest = new XdmDestination();
                try {
                    if (baseURI == null) {
                        baseURI = new URI("http://example.com/");
                    }
                    S9apiUtils.writeXdmValue(this.runtime.getProcessor(), nodes, (Destination)dest, baseURI);
                    XdmNode doc = dest.getXdmNode();
                    stringValue = stringValue + doc.getStringValue();
                    items.add(doc);
                    continue;
                }
                catch (URISyntaxException use) {
                    throw new XProcException(use);
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            }
            stringValue = stringValue + child.getStringValue();
            items.add(new XdmAtomicValue(child.getStringValue()));
        }
        RuntimeValue value = new RuntimeValue(stringValue, new XdmValue(items), pnode, new Hashtable<String, String>());
        if (port != null) {
            impl.setParameter(port, pname, value);
        } else {
            impl.setParameter(pname, value);
        }
    }

    protected RuntimeValue computeValue(ComputableValue var) throws SaxonApiException {
        String string;
        XdmItem xdmItem;
        Hashtable<String, String> nsBindings = new Hashtable<String, String>();
        Hashtable globals = this.inScopeOptions;
        XdmNode doc = null;
        Vector<XdmNode> defaultCollection = null;
        if (this.runtime.getAllowSequenceAsContext()) {
            defaultCollection = new Vector<XdmNode>();
        }
        try {
            if (var.getBinding().size() > 0) {
                Binding binding = var.getBinding().firstElement();
                ReadablePipe pipe = null;
                if (binding.getBindingType() == 7) {
                    XAtomicStep step = this;
                    while (!(step instanceof XCatch)) {
                        step = ((XStep)step).getParent();
                    }
                    pipe = ((XCatch)step).errorPipe;
                } else {
                    pipe = this.getPipeFromBinding(binding);
                    pipe.canReadSequence(this.runtime.getAllowSequenceAsContext());
                }
                if (pipe.readSequence()) {
                    while (pipe.moreDocuments()) {
                        if (defaultCollection != null) {
                            if (doc == null) {
                                doc = pipe.read();
                                defaultCollection.add(doc);
                                continue;
                            }
                            defaultCollection.add(pipe.read());
                            continue;
                        }
                        if (doc == null) {
                            doc = pipe.read();
                            continue;
                        }
                        pipe.read();
                    }
                } else {
                    doc = pipe.read();
                    if (pipe.moreDocuments()) {
                        throw XProcException.dynamicError(8, this, "More than one document in context for parameter '" + var.getName() + "'");
                    }
                }
            }
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        for (NamespaceBinding nsbinding : var.getNamespaceBindings()) {
            Iterator<Object> lclnsBindings;
            Hashtable<Object, Object> localBindings = new Hashtable();
            if (nsbinding.getBinding() != null) {
                QName binding = new QName(nsbinding.getBinding(), nsbinding.getNode());
                RuntimeValue nsv = (RuntimeValue)globals.get(binding);
                if (nsv == null) {
                    throw new XProcException(var.getNode(), "No in-scope option or variable named: " + binding);
                }
                localBindings = nsv.getNamespaceBindings();
            } else if (nsbinding.getXPath() != null) {
                try {
                    XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
                    xcomp.setBaseURI(this.step.getNode().getBaseURI());
                    for (QName qName : globals.keySet()) {
                        xcomp.declareVariable(qName);
                    }
                    lclnsBindings = new Hashtable();
                    NodeInfo nodeInfo = nsbinding.getNode().getUnderlyingNode();
                    NamePool pool = nodeInfo.getConfiguration().getNamePool();
                    InscopeNamespaceResolver inscopeNamespaceResolver = new InscopeNamespaceResolver(nodeInfo);
                    Iterator pfxiter = inscopeNamespaceResolver.iteratePrefixes();
                    while (pfxiter.hasNext()) {
                        String nspfx = (String)pfxiter.next();
                        String nsuri = inscopeNamespaceResolver.getURIForPrefix(nspfx, "".equals(nspfx));
                        ((Hashtable)((Object)lclnsBindings)).put(nspfx, nsuri);
                    }
                    for (String prefix : ((Hashtable)((Object)lclnsBindings)).keySet()) {
                        xcomp.declareNamespace(prefix, (String)((Hashtable)((Object)lclnsBindings)).get(prefix));
                    }
                    XPathExecutable xexec = xcomp.compile(nsbinding.getXPath());
                    XPathSelector selector = xexec.load();
                    for (QName varname : globals.keySet()) {
                        XdmAtomicValue avalue = new XdmAtomicValue(((RuntimeValue)globals.get(varname)).getString());
                        selector.setVariable(varname, (XdmValue)avalue);
                    }
                    if (doc != null) {
                        selector.setContextItem((XdmItem)doc);
                    }
                    XdmNode element = null;
                    for (XdmItem item : selector) {
                        if (element != null || item.isAtomicValue()) {
                            throw XProcException.dynamicError(9);
                        }
                        element = (XdmNode)item;
                        if (element.getNodeKind() == XdmNodeKind.ELEMENT) continue;
                        throw XProcException.dynamicError(9);
                    }
                    if (element == null) {
                        throw XProcException.dynamicError(9);
                    }
                    XdmSequenceIterator nsIter = element.axisIterator(Axis.NAMESPACE);
                    while (nsIter.hasNext()) {
                        XdmNode ns = (XdmNode)nsIter.next();
                        QName prefix = ns.getNodeName();
                        localBindings.put(prefix == null ? "" : prefix.getLocalName(), ns.getStringValue());
                    }
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            } else if (nsbinding.getNamespaceBindings() != null) {
                Hashtable<String, String> bindings = nsbinding.getNamespaceBindings();
                for (String string2 : bindings.keySet()) {
                    if ("".equals(string2) || string2 == null) continue;
                    localBindings.put(string2, bindings.get(string2));
                }
            }
            HashSet prefixes = new HashSet();
            for (String string3 : nsbinding.getExcludedNamespaces()) {
                for (String string4 : localBindings.keySet()) {
                    if (!string3.equals(localBindings.get(string4))) continue;
                    prefixes.add(string4);
                }
            }
            lclnsBindings = prefixes.iterator();
            while (lclnsBindings.hasNext()) {
                String string5 = lclnsBindings.next();
                localBindings.remove(string5);
            }
            for (String string6 : localBindings.keySet()) {
                if (nsBindings.containsKey(string6) && !nsBindings.get(string6).equals(localBindings.get(string6))) {
                    throw XProcException.dynamicError(13);
                }
                nsBindings.put(string6, (String)localBindings.get(string6));
            }
        }
        String select = var.getSelect();
        Object value = new XdmValue(this.evaluateXPath(doc, defaultCollection, nsBindings, select, globals));
        String stringValue = "";
        try {
            for (XdmItem item : value) {
                if (item.isAtomicValue()) {
                    stringValue = stringValue + item.getStringValue();
                    continue;
                }
                if (item instanceof XdmNode) {
                    XdmNode xdmNode = (XdmNode)item;
                    if (xdmNode.getNodeKind() == XdmNodeKind.ATTRIBUTE || xdmNode.getNodeKind() == XdmNodeKind.NAMESPACE) {
                        stringValue = stringValue + xdmNode.getStringValue();
                        continue;
                    }
                    XdmDestination dest = new XdmDestination();
                    S9apiUtils.writeXdmValue(this.runtime, item, (Destination)dest, null);
                    stringValue = stringValue + dest.getXdmNode().getStringValue();
                    continue;
                }
                if (this.runtime.getAllowGeneralExpressions()) continue;
                throw new XProcException("Can not evaluate expression when not in 'general-values' mode: " + select);
            }
        }
        catch (SaxonApiUncheckedException saue) {
            Throwable sae = saue.getCause();
            if (sae instanceof XPathException) {
                XPathException xPathException = (XPathException)sae;
                if ("http://www.w3.org/2005/xqt-errors".equals(xPathException.getErrorCodeNamespace()) && "XPDY0002".equals(xPathException.getErrorCodeLocalPart())) {
                    throw XProcException.dynamicError(26, this.step.getNode(), "The expression for $" + var.getName() + " refers to the context item.");
                }
                throw saue;
            }
            throw saue;
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        Pattern varrefpat = Pattern.compile("^\\s*\\$([^\\s=]+)\\s*$");
        Matcher varref = varrefpat.matcher(select);
        if (varref.matches()) {
            String string7 = varref.group(1);
            QName varname = null;
            try {
                String[] stringArray = NameChecker.checkQNameParts((CharSequence)string7);
                String vpfx = stringArray[0];
                String vlocal = stringArray[1];
                if (vpfx == null || "".equals(vpfx)) {
                    varname = new QName("", vlocal);
                } else {
                    String vns = nsBindings.get(vpfx);
                    varname = new QName(vpfx, vns, vlocal);
                }
                RuntimeValue val = (RuntimeValue)globals.get(varname);
                nsBindings = val.getNamespaceBindings();
            }
            catch (XPathException vpfx) {
                // empty catch block
            }
        }
        if (value.size() > 0 && (xdmItem = value.iterator().next()) instanceof XdmNode) {
            XdmNode node = (XdmNode)xdmItem;
            nsBindings.clear();
            XdmSequenceIterator xdmSequenceIterator = node.axisIterator(Axis.NAMESPACE);
            while (xdmSequenceIterator.hasNext()) {
                XdmNode ns = (XdmNode)xdmSequenceIterator.next();
                nsBindings.put(ns.getNodeName() == null ? "" : ns.getNodeName().getLocalName(), ns.getStringValue());
            }
        }
        if (this.runtime.getAllowGeneralExpressions()) {
            if (var.getSequenceType() != null) {
                value = SequenceType.XS_STRING.equals(var.getSequenceType()) ? null : var.getSequenceType().cast((XdmValue)value, var.getNode());
            }
        } else {
            value = null;
        }
        if (var.getTypeAsQName() != null) {
            try {
                TypeUtils.checkType(this.runtime, value, stringValue, var.getTypeAsQName(), var.getNode());
            }
            catch (XProcException xProcException) {
                throw new XProcException(xProcException.getErrorCode(), (XStep)this, (Throwable)xProcException);
            }
        } else if (var.getType() != null && (string = var.getType()).contains("|")) {
            TypeUtils.checkLiteral(stringValue, string);
        }
        if (value != null) {
            return new RuntimeValue(stringValue, (XdmValue)value, var.getNode(), nsBindings);
        }
        return new RuntimeValue(stringValue, var.getNode(), nsBindings);
    }

    protected Vector<XdmItem> evaluateXPath(XdmNode doc, Vector<XdmNode> defaultCollection, Hashtable<String, String> nsBindings, String xpath, Hashtable<QName, RuntimeValue> globals) {
        Vector<XdmItem> results = new Vector<XdmItem>();
        Hashtable<QName, RuntimeValue> boundOpts = new Hashtable<QName, RuntimeValue>();
        for (QName name : globals.keySet()) {
            RuntimeValue v = globals.get(name);
            if (!v.initialized()) continue;
            boundOpts.put(name, v);
        }
        CollectionFinder collectionFinder = null;
        if (defaultCollection != null) {
            Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
            collectionFinder = config.getCollectionFinder();
            config.setDefaultCollection("http://xmlcalabash.com/saxon-default-collection");
            config.setCollectionFinder((CollectionFinder)new XProcCollectionFinder(this.runtime, defaultCollection, collectionFinder));
        }
        try {
            XPathCompiler xcomp = this.runtime.getProcessor().newXPathCompiler();
            URI baseURI = this.step.getNode().getBaseURI();
            if (baseURI == null || !baseURI.isAbsolute()) {
                if (this.runtime.getBaseURI() != null) {
                    xcomp.setBaseURI(this.runtime.getBaseURI().resolve(baseURI));
                }
            } else {
                xcomp.setBaseURI(baseURI);
            }
            for (QName varname : boundOpts.keySet()) {
                xcomp.declareVariable(varname);
            }
            for (String prefix : nsBindings.keySet()) {
                xcomp.declareNamespace(prefix, nsBindings.get(prefix));
            }
            XPathExecutable xexec = null;
            try {
                xexec = xcomp.compile(xpath);
            }
            catch (SaxonApiException sae) {
                XPathException xe;
                Throwable t = sae.getCause();
                if (t instanceof XPathException && (xe = (XPathException)t).getMessage().contains("Undeclared (or unbound?) variable")) {
                    throw XProcException.dynamicError(26, this.step.getNode(), xe.getMessage());
                }
                throw sae;
            }
            XPathSelector selector = xexec.load();
            for (QName varname : boundOpts.keySet()) {
                Object value = null;
                RuntimeValue rval = (RuntimeValue)boundOpts.get(varname);
                value = this.runtime.getAllowGeneralExpressions() && rval.hasGeneralValue() ? rval.getValue() : rval.getUntypedAtomic(this.runtime);
                selector.setVariable(varname, (XdmValue)value);
            }
            if (doc != null) {
                selector.setContextItem((XdmItem)doc);
            }
            try {
                Iterator values = selector.iterator();
                while (values.hasNext()) {
                    results.add((XdmItem)values.next());
                }
            }
            catch (SaxonApiUncheckedException saue) {
                Throwable sae = saue.getCause();
                if (sae instanceof XPathException) {
                    XPathException xe = (XPathException)sae;
                    if ("http://www.w3.org/2005/xqt-errors".equals(xe.getErrorCodeNamespace()) && "XPDY0002".equals(xe.getErrorCodeLocalPart())) {
                        throw XProcException.dynamicError(26, this.step.getNode(), "Expression refers to context when none is available: " + xpath);
                    }
                    Throwable cause = sae.getCause();
                    if (cause != null) {
                        throw new XProcException((XStep)this, sae, XProcException.fromException(cause).rebase(null, new RuntimeException().getStackTrace()).rebase(this));
                    }
                    throw saue;
                }
                throw saue;
            }
        }
        catch (SaxonApiException sae) {
            if (S9apiUtils.xpathSyntaxError(sae)) {
                throw XProcException.dynamicError(23, this, sae.getCause().getMessage());
            }
            throw new XProcException((XStep)this, (Throwable)sae);
        }
        catch (SaxonApiUncheckedException saue) {
            throw new XProcException((XStep)this, (Throwable)saue);
        }
        finally {
            if (defaultCollection != null) {
                this.runtime.getProcessor().getUnderlyingConfiguration().setCollectionFinder(collectionFinder);
            }
        }
        return results;
    }
}

