/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.TreeWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.style.StylesheetFunctionLibrary;

public class XPipeline
extends XCompoundStep {
    private static final QName c_param_set = new QName("c", "http://www.w3.org/ns/xproc-step", "param-set");
    private static final QName c_param = new QName("c", "http://www.w3.org/ns/xproc-step", "param");
    private static final QName _name = new QName("name");
    private static final QName _namespace = new QName("namespace");
    private static final QName _value = new QName("value");
    private Vector<XdmNode> errors = new Vector();
    private Hashtable<QName, RuntimeValue> optionsPassedIn = null;
    private List<FunctionLibrary> importedXsltFunctionLibraries = null;

    public XPipeline(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    public XPipeline(XProcRuntime runtime, Step step, XCompoundStep parent, SourceLocator[] callingLocation) {
        super(runtime, step, parent);
        this.parentLocation = callingLocation;
    }

    @Override
    public DeclareStep getDeclareStep() {
        return this.step.getDeclaration();
    }

    public void passOption(QName name, RuntimeValue value) {
        if (this.optionsPassedIn == null) {
            this.optionsPassedIn = new Hashtable();
        }
        this.optionsPassedIn.put(name, value);
    }

    @Override
    public Hashtable<QName, RuntimeValue> getInScopeOptions() {
        Hashtable<QName, RuntimeValue> globals = new Hashtable<QName, RuntimeValue>();
        if (this.inScopeOptions != null) {
            for (QName name : this.inScopeOptions.keySet()) {
                globals.put(name, (RuntimeValue)this.inScopeOptions.get(name));
            }
        }
        if (this.optionsPassedIn != null) {
            for (QName name : this.optionsPassedIn.keySet()) {
                globals.put(name, this.optionsPassedIn.get(name));
            }
        }
        return globals;
    }

    public Set<String> getInputs() {
        HashSet<String> ports = new HashSet<String>();
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            ports.add(port);
        }
        return ports;
    }

    public void clearInputs(String port) {
        Vector v = (Vector)this.inputs.get(port);
        v.clear();
    }

    public void writeTo(String port, XdmNode node) {
        WritablePipe pipe = (WritablePipe)this.outputs.get(port + "|");
        this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "writesTo " + pipe + " for " + port));
        pipe.write(node);
    }

    public Set<String> getOutputs() {
        HashSet<String> ports = new HashSet<String>();
        for (String port : this.outputs.keySet()) {
            if (port.endsWith("|")) continue;
            ports.add(port);
        }
        return ports;
    }

    public ReadablePipe readFrom(String port) {
        ReadablePipe rpipe = null;
        XOutput output = this.getOutput(port);
        rpipe = output.getReader();
        rpipe.canReadSequence(true);
        return rpipe;
    }

    public Serialization getSerialization(String port) {
        Output output = this.step.getOutput(port);
        return output.getSerialization();
    }

    private void setupParameters() {
        Vector<String> ports = new Vector<String>();
        Iterator<String> portIter = this.getParameterPorts().iterator();
        while (portIter.hasNext()) {
            ports.add(portIter.next());
        }
        for (String port : ports) {
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(c_param_set);
            tree.startContent();
            for (QName name : this.getParameters(port)) {
                String value = this.getParameter(port, name).getString();
                tree.addStartElement(c_param);
                tree.addAttribute(_name, name.getLocalName());
                if (name.getNamespaceURI() != null) {
                    tree.addAttribute(_namespace, name.getNamespaceURI());
                }
                tree.addAttribute(_value, value);
                tree.startContent();
                tree.addEndElement();
            }
            tree.addEndElement();
            tree.endDocument();
            this.writeTo(port, tree.getResult());
        }
    }

    @Override
    protected void doRun() throws SaxonApiException {
        QName infoName = XProcConstants.p_pipeline;
        this.logger.trace("Running " + infoName + " " + this.step.getName());
        if (this.runtime.getAllowGeneralExpressions()) {
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Running with the 'general-values' extension enabled."));
        }
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        this.runtime.start(this);
        try {
            String wport;
            for (String string : this.inputs.keySet()) {
                if (string.startsWith("|")) continue;
                wport = string + "|";
                WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
                for (ReadablePipe reader : (Vector)this.inputs.get(string)) {
                    while (reader.moreDocuments()) {
                        XdmNode doc = reader.read();
                        pipe.write(doc);
                        this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Pipeline input copy from " + reader + " to " + pipe));
                    }
                }
            }
            this.setupParameters();
            this.inScopeOptions = this.parent.getInScopeOptions();
            for (QName qName : this.step.getOptions()) {
                Option option = this.step.getOption(qName);
                RuntimeValue value = null;
                if (this.optionsPassedIn != null && this.optionsPassedIn.containsKey(qName)) {
                    value = this.optionsPassedIn.get(qName);
                } else {
                    if (option.getRequired() && option.getSelect() == null) {
                        throw XProcException.staticError(18, option.getNode(), "No value provided for required option \"" + option.getName() + "\"");
                    }
                    value = option.getSelect() == null ? new RuntimeValue() : this.computeValue(option);
                }
                this.setOption(qName, value);
                this.inScopeOptions.put(qName, value);
            }
            if (this.importedXsltFunctionLibraries == null) {
                Iterator<Object> decl = this.getDeclareStep();
                for (XdmNode n : ((DeclareStep)((Object)decl)).getXsltFunctionImports()) {
                    if (this.importedXsltFunctionLibraries == null) {
                        this.importedXsltFunctionLibraries = new ArrayList<FunctionLibrary>();
                    }
                    XsltCompiler compiler = this.runtime.getProcessor().newXsltCompiler();
                    compiler.setSchemaAware(this.runtime.getProcessor().isSchemaAware());
                    this.importedXsltFunctionLibraries.add((FunctionLibrary)new StylesheetFunctionLibrary(compiler.compile(n.asSource()).getUnderlyingCompiledStylesheet().getTopLevelPackage(), true));
                }
            }
            if (this.importedXsltFunctionLibraries != null) {
                this.runtime.getConfiguration().inscopeXsltFunctions.addAll(this.importedXsltFunctionLibraries);
            }
            for (Variable variable : this.step.getVariables()) {
                RuntimeValue value = this.computeValue(variable);
                this.inScopeOptions.put(variable.getName(), value);
            }
            for (XStep xStep : this.subpipeline) {
                xStep.run();
            }
            if (this.importedXsltFunctionLibraries != null) {
                this.runtime.getConfiguration().inscopeXsltFunctions.removeAll(this.importedXsltFunctionLibraries);
            }
            for (final String string : this.inputs.keySet()) {
                if (!string.startsWith("|")) continue;
                wport = string.substring(1);
                ((Pipe)this.outputs.get(wport)).onRead(new XProcRunnable(){
                    private boolean done = false;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() throws SaxonApiException {
                        if (this.done) {
                            return;
                        }
                        this.done = true;
                        try (WritablePipe pipe = (WritablePipe)XPipeline.this.outputs.get(wport);){
                            for (ReadablePipe reader : (Vector)XPipeline.this.inputs.get(string)) {
                                if (!reader.moreDocuments() && !pipe.writeSequence()) {
                                    throw XProcException.dynamicError(7, "Reading " + wport + " on " + XPipeline.this.name);
                                }
                                while (reader.moreDocuments()) {
                                    XdmNode doc = reader.read();
                                    pipe.write(doc);
                                    XPipeline.this.logger.trace(MessageFormatter.nodeMessage(XPipeline.this.step.getNode(), "Pipeline output copy from " + reader + " to " + pipe));
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (XProcException ex) {
            throw ex;
        }
        catch (SaxonApiException ex) {
            this.runtime.error(ex);
            throw ex;
        }
        finally {
            this.runtime.finish(this);
            data.closeFrame();
        }
    }

    @Override
    public void reportError(XdmNode doc) {
        this.errors.add(doc);
    }

    public List<XdmNode> errors() {
        return this.errors;
    }

    @Override
    public SourceLocator[] getLocation() {
        return this.parentLocation;
    }
}

