/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.runtime.XRootStep;
import com.xmlcalabash.util.XProcMessageListenerHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XPipelineCall
extends XAtomicStep {
    private DeclareStep decl = null;
    private XPipeline pipeline = null;
    private HashSet<QName> pipeOpts = null;

    public XPipelineCall(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
        this.decl = step.getDeclaration();
    }

    @Override
    public XCompoundStep getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() throws SaxonApiException {
        RuntimeValue value;
        this.logger.trace("Running " + this.step.getType());
        this.decl.setup();
        if (this.runtime.getError() != null) {
            throw this.runtime.getError().copy();
        }
        if (this.pipeline == null) {
            Iterator<QName> root = new XRootStep(this.runtime);
            this.pipeline = new XPipeline(this.runtime, this.decl, (XCompoundStep)((Object)root), this.getLocation());
            this.pipeline.instantiate(this.decl);
            this.pipeOpts = new HashSet();
            for (QName name : this.pipeline.step.getOptions()) {
                this.pipeOpts.add(name);
            }
            for (String port : this.inputs.keySet()) {
                if (port.startsWith("|")) continue;
                this.pipeline.inputs.put(port, this.inputs.get(port));
            }
            for (String port : this.outputs.keySet()) {
                if (port.endsWith("|")) continue;
                this.pipeline.outputs.put(port, this.outputs.get(port));
            }
        } else {
            this.pipeline.reset();
        }
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (QName name : this.step.getOptions()) {
            Option option = this.step.getOption(name);
            value = this.computeValue(option);
            this.setOption(name, value);
            if (this.pipeOpts.contains(name)) {
                this.pipeline.passOption(name, value);
            }
            this.inScopeOptions.put(name, value);
        }
        for (QName name : this.step.getParameters()) {
            Parameter param = this.step.getParameter(name);
            value = this.computeValue(param);
            String port = param.getPort();
            if (port == null) {
                this.pipeline.setParameter(name, value);
                continue;
            }
            this.pipeline.setParameter(port, name, value);
        }
        this.runtime.start(this);
        XProcMessageListenerHelper.openStep(this.runtime, this);
        ArrayList<FunctionLibrary> inscopeXsltFunctions = new ArrayList<FunctionLibrary>(this.runtime.getConfiguration().inscopeXsltFunctions);
        this.runtime.getConfiguration().inscopeXsltFunctions.clear();
        try {
            this.pipeline.run();
            this.runtime.getConfiguration().inscopeXsltFunctions.addAll(inscopeXsltFunctions);
        }
        catch (Throwable throwable) {
            this.runtime.getConfiguration().inscopeXsltFunctions.addAll(inscopeXsltFunctions);
            for (XdmNode doc : this.pipeline.errors()) {
                this.reportError(doc);
            }
            this.runtime.getMessageListener().closeStep();
            throw throwable;
        }
        for (XdmNode doc : this.pipeline.errors()) {
            this.reportError(doc);
        }
        this.runtime.getMessageListener().closeStep();
        this.runtime.finish(this);
    }
}

