/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XStep;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XProcMessageListenerHelper {
    private static final String NS_DAISY_PIPELINE_XPROC = "http://www.daisy.org/ns/pipeline/xproc";
    private static final QName px_message = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "message");
    private static final QName cx_message = new QName("cx", "http://xmlcalabash.com/ns/extensions", "message");
    private static final QName px_message_severity = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "message-severity");
    private static final QName px_progress = new QName("px", "http://www.daisy.org/ns/pipeline/xproc", "progress");
    private static final Logger logger = LoggerFactory.getLogger(XProcMessageListenerHelper.class);
    private static final DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.###", symbols);
    private static final DecimalFormat percentFormat;
    private static final Pattern ratioPattern;

    public static void openStep(XProcRuntime runtime, XStep step) {
        XProcMessageListenerHelper.openStep(runtime, step, null, step.getInScopeOptions());
    }

    public static void openStep(XProcRuntime runtime, XStep step, BigDecimal fixedPortion, Hashtable<QName, RuntimeValue> globals) {
        BigDecimal portion;
        String msg = XProcMessageListenerHelper.evaluateExtensionAttribute(px_message, runtime, step, globals);
        if (msg == null) {
            msg = XProcMessageListenerHelper.evaluateExtensionAttribute(cx_message, runtime, step, globals);
        }
        String s = XProcMessageListenerHelper.evaluateExtensionAttribute(px_progress, runtime, step, globals);
        if (fixedPortion != null) {
            portion = fixedPortion;
            if (s != null) {
                logger.debug("px:progress attribute ignored: " + s);
            }
        } else if (s == null) {
            portion = BigDecimal.ZERO;
        } else {
            try {
                portion = XProcMessageListenerHelper.parseNumber(s);
            }
            catch (ArithmeticException e) {
                logger.debug("Could not compute px:progress, ignoring: " + s, (Throwable)e);
                portion = BigDecimal.ZERO;
            }
            catch (NumberFormatException e) {
                throw new XProcException("Not a valid number: " + s);
            }
        }
        String severity = msg == null ? null : step.getExtensionAttribute(px_message_severity);
        XProcMessageListener listener = runtime.getMessageListener();
        listener.openStep(step, step.getNode(), msg, severity, portion);
    }

    public static String evaluateExtensionAttribute(QName attName, XProcRuntime runtime, XStep step, Hashtable<QName, RuntimeValue> globals) {
        String val = step.getExtensionAttribute(attName);
        if (val != null && val.contains("{")) {
            try {
                val = XProcMessageListenerHelper.evaluateAVT(val, runtime, globals);
            }
            catch (Exception e) {
                throw new XProcException(new SourceLocator[]{XProcException.prettyLocator(null, "@" + attName.toString())}, (Throwable)new RuntimeException("Could not evaluate " + attName + " attribute: " + val, e)).rebase(step);
            }
        }
        return val;
    }

    public static String evaluateAVT(String avt, XProcRuntime runtime, final Hashtable<QName, RuntimeValue> globals) throws XPathException {
        final XPathEvaluator evaluator = new XPathEvaluator();
        ((IndependentContext)evaluator.getStaticContext()).setAllowUndeclaredVariables(true);
        final Configuration config = runtime.getProcessor().getUnderlyingConfiguration();
        final StylesheetPackage pack = config.makeStylesheetPackage();
        pack.createFunctionLibrary();
        StyleElement dummyXslt = new StyleElement(){
            {
                LinkedTreeBuilder builder = new LinkedTreeBuilder(config.makePipelineConfiguration());
                builder.open();
                builder.startDocument(0);
                builder.endDocument();
                builder.close();
                NodeInfo dummyNode = builder.getCurrentRoot();
                this.initialise(NameOfNode.makeName((NodeInfo)dummyNode), dummyNode.getSchemaType(), null, dummyNode, 0);
            }

            protected void prepareAttributes() throws XPathException {
            }
        };
        ExpressionContext dummyContext = new ExpressionContext(dummyXslt, null){

            public FunctionLibraryList getFunctionLibrary() {
                return pack.getFunctionLibrary();
            }

            public StylesheetPackage getPackageData() {
                return pack;
            }

            public DecimalFormatManager getDecimalFormatManager() {
                return null;
            }

            public Expression bindVariable(StructuredQName name) throws XPathException {
                if (!globals.containsKey(new QName(name.toJaxpQName()))) {
                    throw new XPathException("Variable is not defined: $" + name);
                }
                return evaluator.getStaticContext().bindVariable(name);
            }
        };
        Expression expr = AttributeValueTemplate.make((String)avt, (StaticContext)dummyContext);
        XPathExpression dummyXPath = evaluator.createExpression("()");
        XPathDynamicContext dynamicContext = dummyXPath.createDynamicContext();
        Iterator variables = ((IndependentContext)evaluator.getStaticContext()).iterateExternalVariables();
        while (variables.hasNext()) {
            XPathVariable var = (XPathVariable)variables.next();
            QName name = new QName(var.getVariableQName().toJaxpQName());
            dynamicContext.setVariable(var, (Sequence)globals.get(name).getStringValue());
        }
        expr.typeCheck(ExpressionVisitor.make((StaticContext)dummyContext), new ContextItemStaticInfo(Type.ITEM_TYPE, true));
        return expr.evaluateAsString(dynamicContext.getXPathContextObject()).toString();
    }

    public static BigDecimal parseNumber(String input) throws NumberFormatException {
        ParsePosition pos = new ParsePosition(0);
        BigDecimal dec = (BigDecimal)decimalFormat.parse(input, pos);
        if (pos.getIndex() == input.length() && pos.getErrorIndex() == -1) {
            return dec;
        }
        pos = new ParsePosition(0);
        dec = (BigDecimal)percentFormat.parse(input, pos);
        if (pos.getIndex() == input.length() && pos.getErrorIndex() == -1) {
            return dec;
        }
        Matcher m = ratioPattern.matcher(input);
        if (m.matches()) {
            try {
                int numerator = Integer.parseInt(m.group("numerator"));
                int denominator = Integer.parseInt(m.group("denominator"));
                return new BigDecimal(numerator).divide(new BigDecimal(denominator), MathContext.DECIMAL128);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new NumberFormatException();
    }

    static {
        decimalFormat.setParseBigDecimal(true);
        percentFormat = new DecimalFormat("#%", symbols);
        percentFormat.setParseBigDecimal(true);
        ratioPattern = Pattern.compile("^(?<numerator>[-+]?[0-9]+)/(?<denominator>[0-9]+)$");
    }
}

