/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import net.sf.saxon.s9api.QName;

public class XProcNamespaceContext {
    Hashtable<String, String> nshash = new Hashtable();

    public XProcNamespaceContext(Hashtable<String, String> bindings) {
        for (String prefix : bindings.keySet()) {
            this.nshash.put(prefix, bindings.get(prefix));
        }
    }

    public String getNamespaceURI(String prefix) {
        if (this.nshash.containsKey(prefix)) {
            return this.nshash.get(prefix);
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return "";
    }

    public String getPrefix(String namespace) {
        for (String key : this.nshash.keySet()) {
            if (!namespace.equals(this.nshash.get(key))) continue;
            return key;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespace)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespace)) {
            return "xmlns";
        }
        return null;
    }

    public Set<String> getAllPrefixes() {
        return this.nshash.keySet();
    }

    public Hashtable<String, String> bindings() {
        return this.nshash;
    }

    public Iterator<String> getPrefixes(String namespace) {
        Vector<String> pfxs = new Vector<String>();
        for (String key : this.nshash.keySet()) {
            if (!namespace.equals(this.nshash.get(key))) continue;
            pfxs.add(key);
        }
        return pfxs.iterator();
    }

    public Iterator<String> getPrefixes() {
        return null;
    }

    public void addBinding(String prefix, String namespace) {
        this.nshash.put(prefix, namespace);
    }

    public void delBinding(String prefix) {
        this.nshash.remove(prefix);
    }

    public QName parseQName(String name) {
        QName newName = null;
        if (name.contains(":")) {
            int pos = name.indexOf(":");
            String prefix = name.substring(0, pos);
            String localName = name.substring(pos + 1);
            String namespace = this.nshash.get(prefix);
            if ("xml".equals(prefix)) {
                namespace = "http://www.w3.org/XML/1998/namespace";
            }
            if (namespace == null) {
                throw new IllegalArgumentException("No binding for prefix in name: " + name);
            }
            newName = new QName(namespace, localName, prefix);
        } else {
            newName = new QName(this.getNamespaceURI(""), name, "");
        }
        return newName;
    }

    public void dump() {
        System.err.println("Namespace context: " + this.hashCode());
        for (String prefix : this.nshash.keySet()) {
            System.err.println("\t" + prefix + "=" + this.nshash.get(prefix));
        }
    }
}

