/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.AnyUriDatatype;
import com.thaiopensource.datatype.xsd.Base64BinaryDatatype;
import com.thaiopensource.datatype.xsd.BooleanDatatype;
import com.thaiopensource.datatype.xsd.CdataDatatype;
import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.DatatypeBuilderImpl;
import com.thaiopensource.datatype.xsd.DateTimeDatatype;
import com.thaiopensource.datatype.xsd.DecimalDatatype;
import com.thaiopensource.datatype.xsd.DoubleDatatype;
import com.thaiopensource.datatype.xsd.DurationDatatype;
import com.thaiopensource.datatype.xsd.EntityDatatype;
import com.thaiopensource.datatype.xsd.FloatDatatype;
import com.thaiopensource.datatype.xsd.HexBinaryDatatype;
import com.thaiopensource.datatype.xsd.IdDatatype;
import com.thaiopensource.datatype.xsd.IdrefDatatype;
import com.thaiopensource.datatype.xsd.IntegerRestrictDatatype;
import com.thaiopensource.datatype.xsd.ListDatatype;
import com.thaiopensource.datatype.xsd.MaxInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.NCNameDatatype;
import com.thaiopensource.datatype.xsd.NameDatatype;
import com.thaiopensource.datatype.xsd.NmtokenDatatype;
import com.thaiopensource.datatype.xsd.QNameDatatype;
import com.thaiopensource.datatype.xsd.RegexDatatype;
import com.thaiopensource.datatype.xsd.StringDatatype;
import com.thaiopensource.datatype.xsd.TokenDatatype;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;

public class DatatypeLibraryImpl
implements DatatypeLibrary {
    private final Map<String, DatatypeBase> typeMap = new HashMap<String, DatatypeBase>();
    private final RegexEngine regexEngine;
    private static final String LONG_MAX = "9223372036854775807";
    private static final String LONG_MIN = "-9223372036854775808";
    private static final String INT_MAX = "2147483647";
    private static final String INT_MIN = "-2147483648";
    private static final String SHORT_MAX = "32767";
    private static final String SHORT_MIN = "-32768";
    private static final String BYTE_MAX = "127";
    private static final String BYTE_MIN = "-128";
    private static final String UNSIGNED_LONG_MAX = "18446744073709551615";
    private static final String UNSIGNED_INT_MAX = "4294967295";
    private static final String UNSIGNED_SHORT_MAX = "65535";
    private static final String UNSIGNED_BYTE_MAX = "255";
    private static final String LANGUAGE_PATTERN = "[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*";

    public DatatypeLibraryImpl(RegexEngine regexEngine) {
        this.regexEngine = regexEngine;
        this.typeMap.put("string", new StringDatatype());
        this.typeMap.put("normalizedString", new CdataDatatype());
        this.typeMap.put("token", new TokenDatatype());
        this.typeMap.put("boolean", new BooleanDatatype());
        DecimalDatatype decimalDatatype = new DecimalDatatype();
        this.typeMap.put("decimal", decimalDatatype);
        IntegerRestrictDatatype integerRestrictDatatype = new IntegerRestrictDatatype(decimalDatatype);
        this.typeMap.put("integer", integerRestrictDatatype);
        this.typeMap.put("nonPositiveInteger", DatatypeLibraryImpl.restrictMax(integerRestrictDatatype, "0"));
        this.typeMap.put("negativeInteger", DatatypeLibraryImpl.restrictMax(integerRestrictDatatype, "-1"));
        this.typeMap.put("long", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerRestrictDatatype, LONG_MIN), LONG_MAX));
        this.typeMap.put("int", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerRestrictDatatype, INT_MIN), INT_MAX));
        this.typeMap.put("short", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerRestrictDatatype, SHORT_MIN), SHORT_MAX));
        this.typeMap.put("byte", DatatypeLibraryImpl.restrictMax(DatatypeLibraryImpl.restrictMin(integerRestrictDatatype, BYTE_MIN), BYTE_MAX));
        DatatypeBase datatypeBase = DatatypeLibraryImpl.restrictMin(integerRestrictDatatype, "0");
        this.typeMap.put("nonNegativeInteger", datatypeBase);
        this.typeMap.put("unsignedLong", DatatypeLibraryImpl.restrictMax(datatypeBase, UNSIGNED_LONG_MAX));
        this.typeMap.put("unsignedInt", DatatypeLibraryImpl.restrictMax(datatypeBase, UNSIGNED_INT_MAX));
        this.typeMap.put("unsignedShort", DatatypeLibraryImpl.restrictMax(datatypeBase, UNSIGNED_SHORT_MAX));
        this.typeMap.put("unsignedByte", DatatypeLibraryImpl.restrictMax(datatypeBase, UNSIGNED_BYTE_MAX));
        this.typeMap.put("positiveInteger", DatatypeLibraryImpl.restrictMin(integerRestrictDatatype, "1"));
        this.typeMap.put("double", new DoubleDatatype());
        this.typeMap.put("float", new FloatDatatype());
        this.typeMap.put("Name", new NameDatatype());
        this.typeMap.put("QName", new QNameDatatype());
        NCNameDatatype nCNameDatatype = new NCNameDatatype();
        this.typeMap.put("NCName", nCNameDatatype);
        NmtokenDatatype nmtokenDatatype = new NmtokenDatatype();
        this.typeMap.put("NMTOKEN", nmtokenDatatype);
        this.typeMap.put("NMTOKENS", DatatypeLibraryImpl.list(nmtokenDatatype));
        this.typeMap.put("ID", new IdDatatype());
        IdrefDatatype idrefDatatype = new IdrefDatatype();
        this.typeMap.put("IDREF", idrefDatatype);
        this.typeMap.put("IDREFS", DatatypeLibraryImpl.list(idrefDatatype));
        this.typeMap.put("NOTATION", new QNameDatatype());
        this.typeMap.put("base64Binary", new Base64BinaryDatatype());
        this.typeMap.put("hexBinary", new HexBinaryDatatype());
        this.typeMap.put("anyURI", new AnyUriDatatype());
        this.typeMap.put("language", new RegexDatatype(LANGUAGE_PATTERN){

            @Override
            String getLexicalSpaceKey() {
                return "language";
            }
        });
        this.typeMap.put("dateTime", new DateTimeDatatype("Y-M-DTt"));
        this.typeMap.put("time", new DateTimeDatatype("t"));
        this.typeMap.put("date", new DateTimeDatatype("Y-M-D"));
        this.typeMap.put("gYearMonth", new DateTimeDatatype("Y-M"));
        this.typeMap.put("gYear", new DateTimeDatatype("Y"));
        this.typeMap.put("gMonthDay", new DateTimeDatatype("--M-D"));
        this.typeMap.put("gDay", new DateTimeDatatype("---D"));
        this.typeMap.put("gMonth", new DateTimeDatatype("--M"));
        EntityDatatype entityDatatype = new EntityDatatype();
        this.typeMap.put("ENTITY", entityDatatype);
        this.typeMap.put("ENTITIES", DatatypeLibraryImpl.list(entityDatatype));
        this.typeMap.put("duration", new DurationDatatype());
    }

    @Override
    public DatatypeBuilder createDatatypeBuilder(String string) throws DatatypeException {
        DatatypeBase datatypeBase = this.typeMap.get(string);
        if (datatypeBase == null) {
            throw new DatatypeException();
        }
        if (datatypeBase instanceof RegexDatatype) {
            try {
                ((RegexDatatype)datatypeBase).compile(this.getRegexEngine());
            }
            catch (RegexSyntaxException regexSyntaxException) {
                throw new DatatypeException(DatatypeBuilderImpl.localizer.message("regex_internal_error", string));
            }
        }
        return new DatatypeBuilderImpl(this, datatypeBase);
    }

    RegexEngine getRegexEngine() throws DatatypeException {
        if (this.regexEngine == null) {
            throw new DatatypeException(DatatypeBuilderImpl.localizer.message("regex_impl_not_found"));
        }
        return this.regexEngine;
    }

    private static DatatypeBase restrictMax(DatatypeBase datatypeBase, String string) {
        try {
            return new MaxInclusiveRestrictDatatype(datatypeBase, datatypeBase.getValue(string, null), string);
        }
        catch (DatatypeException datatypeException) {
            throw new AssertionError();
        }
    }

    private static DatatypeBase restrictMin(DatatypeBase datatypeBase, String string) {
        try {
            return new MinInclusiveRestrictDatatype(datatypeBase, datatypeBase.getValue(string, null), string);
        }
        catch (DatatypeException datatypeException) {
            throw new AssertionError();
        }
    }

    private static DatatypeBase list(DatatypeBase datatypeBase) {
        return new MinLengthRestrictDatatype(new ListDatatype(datatypeBase), 1);
    }

    @Override
    public Datatype createDatatype(String string) throws DatatypeException {
        return this.createDatatypeBuilder(string).createDatatype();
    }
}

