/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.css;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.MediaQueryList;
import cz.vutbr.web.css.MediaSpec;
import cz.vutbr.web.css.MediaSpecAll;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.SourceLocator;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.TermFactory;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.csskit.MatchConditionImpl;
import cz.vutbr.web.csskit.antlr.CSSParserFactory;
import cz.vutbr.web.csskit.antlr.CSSSource;
import cz.vutbr.web.csskit.antlr.CSSSourceReader;
import cz.vutbr.web.csskit.antlr.DefaultCSSSourceReader;
import cz.vutbr.web.domassign.Analyzer;
import cz.vutbr.web.domassign.DeclarationTransformer;
import cz.vutbr.web.domassign.StyleMap;
import cz.vutbr.web.domassign.Traversal;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CSSFactory {
    private static Logger log = LoggerFactory.getLogger(CSSFactory.class);
    private static final String DEFAULT_TERM_FACTORY = "cz.vutbr.web.csskit.TermFactoryImpl";
    private static final String DEFAULT_SUPPORTED_CSS = "cz.vutbr.web.domassign.SupportedCSS3";
    private static final String DEFAULT_RULE_FACTORY = "cz.vutbr.web.csskit.RuleFactoryImpl";
    private static final String DEFAULT_DECLARATION_TRANSFORMER = "cz.vutbr.web.domassign.DeclarationTransformer";
    private static final String DEFAULT_NODE_DATA_IMPL = "cz.vutbr.web.domassign.SingleMapNodeData";
    private static CSSParserFactory pf;
    private static TermFactory tf;
    private static SupportedCSS css;
    private static RuleFactory rf;
    private static DeclarationTransformer dt;
    private static Class<? extends NodeData> ndImpl;
    private static MatchCondition dcond;
    private static boolean implyPixelLengths;
    private static MediaSpec autoImportMedia;

    public static final void setImplyPixelLength(boolean b) {
        implyPixelLengths = b;
    }

    public static final boolean getImplyPixelLength() {
        return implyPixelLengths;
    }

    public static MediaSpec getAutoImportMedia() {
        if (autoImportMedia == null) {
            autoImportMedia = new MediaSpecAll();
        }
        return autoImportMedia;
    }

    public static void setAutoImportMedia(MediaSpec autoImportMedia) {
        CSSFactory.autoImportMedia = autoImportMedia;
    }

    public static final void registerCSSParserFactory(CSSParserFactory factory) {
        pf = factory;
    }

    private static final CSSParserFactory getCSSParserFactory() {
        if (pf == null) {
            pf = CSSParserFactory.getInstance();
        }
        return pf;
    }

    public static final void registerTermFactory(TermFactory newFactory) {
        tf = newFactory;
    }

    public static final TermFactory getTermFactory() {
        if (tf == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_TERM_FACTORY);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerTermFactory((TermFactory)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default TermFactory implementation.", (Object)DEFAULT_TERM_FACTORY);
            }
            catch (Exception e) {
                log.error("Unable to get TermFactory from default", (Throwable)e);
                throw new RuntimeException("No TermFactory implementation registered!");
            }
        }
        return tf;
    }

    public static final void registerSupportedCSS(SupportedCSS newCSS) {
        css = newCSS;
    }

    public static final SupportedCSS getSupportedCSS() {
        if (css == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_SUPPORTED_CSS);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerSupportedCSS((SupportedCSS)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default SupportedCSS implementation.", (Object)DEFAULT_SUPPORTED_CSS);
            }
            catch (Exception e) {
                log.error("Unable to get SupportedCSS from default", (Throwable)e);
                throw new RuntimeException("No SupportedCSS implementation registered!");
            }
        }
        return css;
    }

    public static final void registerRuleFactory(RuleFactory newRuleFactory) {
        rf = newRuleFactory;
    }

    public static final RuleFactory getRuleFactory() {
        if (rf == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_RULE_FACTORY);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerRuleFactory((RuleFactory)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default RuleFactory implementation.", (Object)DEFAULT_RULE_FACTORY);
            }
            catch (Exception e) {
                log.error("Unable to get RuleFactory from default", (Throwable)e);
                throw new RuntimeException("No RuleFactory implementation registered!");
            }
        }
        return rf;
    }

    public static final void registerDeclarationTransformer(DeclarationTransformer newDeclarationTransformer) {
        dt = newDeclarationTransformer;
    }

    public static final DeclarationTransformer getDeclarationTransformer() {
        if (dt == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_DECLARATION_TRANSFORMER);
                Method m = clazz.getMethod("getInstance", new Class[0]);
                CSSFactory.registerDeclarationTransformer((DeclarationTransformer)m.invoke(null, new Object[0]));
                log.debug("Retrived {} as default DeclarationTransformer implementation.", (Object)DEFAULT_DECLARATION_TRANSFORMER);
            }
            catch (Exception e) {
                log.error("Unable to get DeclarationTransformer from default", (Throwable)e);
                throw new RuntimeException("No DeclarationTransformer implementation registered!");
            }
        }
        return dt;
    }

    public static final void registerDefaultMatchCondition(MatchCondition newMatchCondition) {
        dcond = newMatchCondition;
    }

    public static final MatchCondition getDefaultMatchCondition() {
        if (dcond == null) {
            dcond = new MatchConditionImpl();
        }
        return dcond;
    }

    public static final void registerNodeDataInstance(Class<? extends NodeData> clazz) {
        try {
            NodeData test = clazz.newInstance();
            ndImpl = clazz;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("NodeData implemenation (" + clazz.getName() + ") doesn't provide sole constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("NodeData implementation (" + clazz.getName() + ") is not accesible", e);
        }
    }

    public static final NodeData createNodeData() {
        return CSSFactory.createNodeData(CSSFactory.getDeclarationTransformer(), CSSFactory.getSupportedCSS());
    }

    public static final NodeData createNodeData(DeclarationTransformer transformer, SupportedCSS css) {
        if (ndImpl == null) {
            try {
                Class<?> clazz = Class.forName(DEFAULT_NODE_DATA_IMPL);
                CSSFactory.registerNodeDataInstance(clazz);
                log.debug("Registered {} as default NodeData instance.", (Object)DEFAULT_NODE_DATA_IMPL);
            }
            catch (Exception clazz) {
                // empty catch block
            }
        }
        try {
            return ndImpl.getDeclaredConstructor(DeclarationTransformer.class, SupportedCSS.class).newInstance(transformer, css);
        }
        catch (Exception e) {
            throw new RuntimeException("No NodeData implementation registered");
        }
    }

    public static final StyleSheet parse(URL url, Charset encoding) throws CSSException, IOException {
        return CSSFactory.getCSSParserFactory().parse(new CSSSource(url, encoding, null), new DefaultCSSSourceReader());
    }

    public static final StyleSheet parse(URL url, CSSSourceReader cssReader, Charset encoding) throws CSSException, IOException {
        return CSSFactory.getCSSParserFactory().parse(new CSSSource(url, encoding, null), cssReader);
    }

    public static final StyleSheet parse(String fileName, Charset encoding) throws CSSException, IOException {
        try {
            File f = new File(fileName);
            URL url = f.toURI().toURL();
            return CSSFactory.parse(url, encoding);
        }
        catch (MalformedURLException e) {
            String message = "Unable to construct URL from fileName: " + fileName;
            log.error(message);
            throw new FileNotFoundException(message);
        }
    }

    @Deprecated
    public static final StyleSheet parse(String css) throws IOException, CSSException {
        return CSSFactory.parseString(css, null);
    }

    public static final StyleSheet parseString(String css, URL base) throws IOException, CSSException {
        return CSSFactory.parseString(css, base, new DefaultCSSSourceReader());
    }

    public static final StyleSheet parseString(String css, URL base, CSSSourceReader cssReader) throws IOException, CSSException {
        if (base == null) {
            base = new URL("file:///base/url/is/not/specified");
        }
        return CSSFactory.getCSSParserFactory().parse(new CSSSource(css, null, base, 0, 0), cssReader);
    }

    public static final StyleSheet getUsedStyles(Document doc, final URL base, MediaSpec media, CSSSourceReader cssReader, StyleSheet style) {
        return CSSFactory.getUsedStyles(doc, (Node node) -> new SourceLocator(){

            @Override
            public URL getURL() {
                return base;
            }

            @Override
            public int getLineNumber() {
                return 0;
            }

            @Override
            public int getColumnNumber() {
                return 0;
            }
        }, media, cssReader, style);
    }

    public static final StyleSheet getUsedStyles(Document doc, Function<Node, SourceLocator> nodeLocator, MediaSpec media, CSSSourceReader cssReader, StyleSheet style) {
        URL base = nodeLocator.apply(doc).getURL();
        SourceData pair = new SourceData(base, cssReader, media);
        CSSAssignTraversal traversal = new CSSAssignTraversal(doc, pair, 1, nodeLocator);
        traversal.listTraversal(style);
        style = style.filter(media);
        return style;
    }

    public static final StyleSheet getUsedStyles(Document doc, URL base, MediaSpec media, CSSSourceReader cssReader) {
        StyleSheet style = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        return CSSFactory.getUsedStyles(doc, base, media, cssReader, style);
    }

    public static final StyleSheet getUsedStyles(Document doc, URL base, MediaSpec media) {
        return CSSFactory.getUsedStyles(doc, base, media, new DefaultCSSSourceReader());
    }

    public static final StyleSheet getUsedStyles(Document doc, URL base, String media) {
        return CSSFactory.getUsedStyles(doc, base, new MediaSpec(media), new DefaultCSSSourceReader());
    }

    public static final StyleMap assignDOM(Document doc, URL base, MediaSpec media, boolean useInheritance) {
        return CSSFactory.assignDOM(doc, base, media, useInheritance, null);
    }

    public static final StyleMap assignDOM(Document doc, URL base, String media, boolean useInheritance) {
        return CSSFactory.assignDOM(doc, base, new MediaSpec(media), useInheritance);
    }

    public static final StyleMap assignDOM(Document doc, URL base, MediaSpec media, boolean useInheritance, MatchCondition matchCond) {
        return CSSFactory.assignDOM(doc, new DefaultCSSSourceReader(), base, media, useInheritance, matchCond);
    }

    public static final StyleMap assignDOM(Document doc, CSSSourceReader cssReader, URL base, MediaSpec media, boolean useInheritance, MatchCondition matchCond) {
        StyleSheet style = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        style = CSSFactory.getUsedStyles(doc, base, media, cssReader, style);
        Analyzer analyzer = new Analyzer(style);
        if (matchCond != null) {
            analyzer.registerMatchCondition(matchCond);
        }
        return analyzer.evaluateDOM(doc, media, useInheritance);
    }

    public static final StyleMap assignDOM(Document doc, URL base, String media, boolean useInheritance, MatchCondition matchCond) {
        return CSSFactory.assignDOM(doc, base, new MediaSpec(media), useInheritance, matchCond);
    }

    static /* synthetic */ CSSParserFactory access$000() {
        return CSSFactory.getCSSParserFactory();
    }

    static {
        implyPixelLengths = false;
        autoImportMedia = null;
    }

    private static final class SourceData {
        public URL base;
        public CSSSourceReader cssReader;
        public MediaSpec media;

        public SourceData(URL base, CSSSourceReader cssReader, MediaSpec media) {
            this.base = base;
            this.cssReader = cssReader;
            this.media = media;
        }
    }

    private static final class CSSAssignTraversal
    extends Traversal<StyleSheet> {
        private CSSParserFactory pf = CSSFactory.access$000();
        private final Function<Node, SourceLocator> nodeLocator;

        public CSSAssignTraversal(Document doc, Object source, int whatToShow, Function<Node, SourceLocator> nodeLocator) {
            super(doc, source, whatToShow);
            this.nodeLocator = nodeLocator;
        }

        @Override
        protected void processNode(StyleSheet result, Node current, Object source) {
            URL base = ((SourceData)source).base;
            MediaSpec media = ((SourceData)source).media;
            CSSSourceReader cssReader = ((SourceData)source).cssReader;
            Element elem = (Element)current;
            try {
                if (this.isEmbeddedStyleSheet(elem, media)) {
                    SourceLocator loc = this.nodeLocator.apply(elem);
                    String mediaType = this.getMediaType(elem);
                    if (cssReader.supportsMediaType(mediaType, null)) {
                        result = this.pf.append(new CSSSource(CSSAssignTraversal.extractElementText(elem), mediaType, base, loc.getLineNumber(), loc.getColumnNumber()), cssReader, result);
                        log.debug("Matched embedded CSS style");
                    }
                } else if (this.isLinkedStyleSheet(elem, media)) {
                    URL uri = DataURLHandler.createURL(base, ElementUtil.getAttribute(elem, "href"));
                    String mediaType = this.getMediaType(elem);
                    if (cssReader.supportsMediaType(mediaType, uri)) {
                        result = this.pf.append(new CSSSource(uri, null, this.getMediaType(elem)), cssReader, result);
                        log.debug("Matched linked CSS style");
                    }
                } else {
                    if (cssReader.supportsMediaType(null, null) && elem.getAttribute("style") != null && elem.getAttribute("style").length() > 0) {
                        result = this.pf.append(new CSSSource(elem.getAttribute("style"), elem, base), cssReader, true, result);
                        log.debug("Matched inline CSS style");
                    }
                    if (elem.getAttribute("XDefaultStyle") != null && elem.getAttribute("XDefaultStyle").length() > 0) {
                        result = this.pf.append(new CSSSource(elem.getAttribute("XDefaultStyle"), elem, base), cssReader, false, result);
                        log.debug("Matched default CSS style");
                    }
                }
            }
            catch (CSSException ce) {
                log.error(ce.getMessage(), (Throwable)ce);
            }
            catch (IOException ioe) {
                log.error(ioe.getMessage(), (Throwable)ioe);
            }
        }

        private boolean isEmbeddedStyleSheet(Element e, MediaSpec media) {
            return "style".equalsIgnoreCase(e.getNodeName()) && this.isAllowedMedia(e, media);
        }

        private boolean isLinkedStyleSheet(Element e, MediaSpec media) {
            return e.getNodeName().equalsIgnoreCase("link") && ElementUtil.getAttribute(e, "rel").toLowerCase().contains("stylesheet") && this.isAllowedMedia(e, media);
        }

        private String getMediaType(Element e) {
            String type = ElementUtil.getAttribute(e, "type");
            if (type != null) {
                if (type.isEmpty()) {
                    return null;
                }
                return type.toLowerCase();
            }
            return null;
        }

        private static String extractElementText(Element e) {
            StringBuilder s = new StringBuilder();
            NodeList children = e.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node text = children.item(i);
                if (text == null) continue;
                if (text.getNodeType() == 3 || text.getNodeType() == 4) {
                    s.append(((CharacterData)text).getData());
                    continue;
                }
                if (text.getNodeType() != 8) continue;
                s.append("<!--").append(((CharacterData)text).getData()).append("-->");
            }
            return s.toString();
        }

        private boolean isAllowedMedia(Element e, MediaSpec media) {
            String attr = ElementUtil.getAttribute(e, "media");
            if (attr != null && attr.length() > 0) {
                if ((attr = attr.trim()).length() > 0) {
                    MediaQueryList ql = this.pf.parseMediaQuery(attr);
                    if (ql != null) {
                        return media.matches(ql);
                    }
                    return false;
                }
                return media.matchesEmpty();
            }
            return media.matchesEmpty();
        }
    }
}

