/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.NetworkProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class DefaultNetworkProcessor
implements NetworkProcessor {
    @Override
    public Reader fetch(URL url, Charset encoding, boolean forceEncoding, boolean assertEncoding) throws IOException {
        URLConnection connection = url.openConnection();
        InputStream is = "gzip".equalsIgnoreCase(connection.getContentEncoding()) ? new GZIPInputStream(connection.getInputStream()) : connection.getInputStream();
        InputStreamReader r = this.detectEncodingAndSkipBOM(is, connection, encoding, forceEncoding);
        if (assertEncoding) {
            if (encoding == null) {
                throw new IllegalArgumentException("encoding must not be null");
            }
            if (!encoding.equals(DefaultNetworkProcessor.getEncoding(r))) {
                throw new IOException("Failed to read URL as " + encoding + ": " + url);
            }
        }
        return r;
    }

    protected InputStreamReader detectEncodingAndSkipBOM(InputStream is, URLConnection connection, Charset encoding, boolean forceEncoding) throws IOException {
        BOMInputStream bis = new BOMInputStream(is);
        if (!forceEncoding) {
            String contentType;
            ByteOrderMark bom = bis.getBOM();
            if (bom != null) {
                try {
                    encoding = Charset.forName(bom.getCharsetName());
                }
                catch (Throwable e) {
                    throw new IllegalStateException();
                }
            } else if (connection != null && (contentType = connection.getContentType()) != null) {
                for (String s : contentType.split("\\s;\\s")) {
                    if (!s.startsWith("charset=")) continue;
                    try {
                        encoding = Charset.forName(s.substring("charset=".length()).trim());
                        break;
                    }
                    catch (Throwable e) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        if (encoding == null) {
            throw new IllegalArgumentException("encoding must not be null");
        }
        return new InputStreamReader((InputStream)bis, encoding);
    }

    protected static Charset getEncoding(InputStreamReader r) {
        try {
            return Charset.forName(r.getEncoding());
        }
        catch (Throwable e) {
            throw new IllegalStateException();
        }
    }
}

