/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.Selector;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class MatchConditionOnElements
implements MatchCondition {
    private Map<Element, Set<Selector.PseudoClass>> elements;
    private Map<String, Set<Selector.PseudoClass>> names;

    public MatchConditionOnElements() {
        this.elements = null;
        this.names = null;
    }

    public MatchConditionOnElements(Element e, Selector.PseudoClass pseudoClass) {
        this.addMatch(e, pseudoClass);
    }

    public MatchConditionOnElements(String name, Selector.PseudoClass pseudoClass) {
        this.addMatch(name, pseudoClass);
    }

    public void addMatch(Element e, Selector.PseudoClass pseudoClass) {
        Set<Selector.PseudoClass> classes;
        if (this.elements == null) {
            this.elements = new HashMap<Element, Set<Selector.PseudoClass>>();
        }
        if ((classes = this.elements.get(e)) == null) {
            classes = new HashSet<Selector.PseudoClass>(2);
            this.elements.put(e, classes);
        }
        classes.add(pseudoClass);
    }

    public void removeMatch(Element e, Selector.PseudoClass pseudoClass) {
        Set<Selector.PseudoClass> classes;
        if (this.elements != null && (classes = this.elements.get(e)) != null) {
            classes.remove(pseudoClass);
        }
    }

    public void addMatch(String name, Selector.PseudoClass pseudoClass) {
        Set<Selector.PseudoClass> classes;
        if (this.names == null) {
            this.names = new HashMap<String, Set<Selector.PseudoClass>>();
        }
        if ((classes = this.names.get(name)) == null) {
            classes = new HashSet<Selector.PseudoClass>(2);
            this.names.put(name, classes);
        }
        classes.add(pseudoClass);
    }

    public void removeMatch(String name, Selector.PseudoClass pseudoClass) {
        Set<Selector.PseudoClass> classes;
        if (this.names != null && (classes = this.names.get(name)) != null) {
            classes.remove(pseudoClass);
        }
    }

    @Override
    public boolean isSatisfied(Element e, Selector.SelectorPart selpart) {
        if (selpart instanceof Selector.PseudoClass) {
            Set<Selector.PseudoClass> pseudos;
            Selector.PseudoClass required = (Selector.PseudoClass)selpart;
            if (this.elements != null && (pseudos = this.elements.get(e)) != null) {
                return pseudos.contains(required);
            }
            if (this.names != null && (pseudos = this.names.get(e.getTagName().toLowerCase())) != null) {
                return pseudos.contains(required);
            }
            return false;
        }
        return false;
    }
}

