/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.MediaExpression;
import cz.vutbr.web.css.MediaQuery;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.csskit.AbstractRule;
import cz.vutbr.web.csskit.MediaExpressionImpl;
import cz.vutbr.web.csskit.OutputUtil;
import java.util.Locale;

public class MediaQueryImpl
extends AbstractRule<MediaExpression>
implements MediaQuery {
    public static final MediaQuery NOT_ALL = new MediaQueryImpl("all", true){

        @Override
        public MediaQuery and(MediaQuery query) {
            return this;
        }
    };
    protected boolean negative;
    protected String type;

    public MediaQueryImpl() {
        this.negative = false;
        this.type = null;
    }

    public MediaQueryImpl(String type, boolean negative) {
        this.negative = negative;
        this.type = type.trim().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public void setNegative(boolean negative) {
        this.negative = negative;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MediaQuery and(MediaQuery query) {
        MediaQueryImpl combined;
        if (this.type == null) {
            combined = new MediaQueryImpl(query.getType(), this.negative);
        } else if (query.getType() == null) {
            combined = new MediaQueryImpl(this.type, this.negative);
        } else if ("all".equals(this.type)) {
            if (this.negative) {
                return NOT_ALL;
            }
            combined = new MediaQueryImpl(query.getType(), this.negative);
        } else if ("all".equals(query.getType())) {
            if (query.isNegative()) {
                return NOT_ALL;
            }
            combined = new MediaQueryImpl(this.type, this.negative);
        } else if (this.type.equals(query.getType())) {
            if (this.negative != query.isNegative()) return NOT_ALL;
            combined = new MediaQueryImpl(this.type, this.negative);
        } else {
            if (this.negative == query.isNegative()) {
                return NOT_ALL;
            }
            combined = this.negative ? new MediaQueryImpl(query.getType(), this.negative) : new MediaQueryImpl(this.type, this.negative);
        }
        combined.addAll(this);
        if (this.negative == query.isNegative()) {
            combined.addAll(query);
            return combined;
        } else {
            for (MediaExpression feature : query) {
                MediaExpressionImpl negatedFeature = new MediaExpressionImpl();
                negatedFeature.unlock();
                negatedFeature.setNegative(true);
                for (Term t : feature) {
                    negatedFeature.add(t);
                }
                combined.add(negatedFeature);
            }
        }
        return combined;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNegative()) {
            sb.append("NOT ");
        }
        if (this.getType() != null) {
            sb.append(this.getType());
            if (!this.isEmpty()) {
                sb.append(" AND ");
            }
        }
        sb = OutputUtil.appendList(sb, this.list, " AND ");
        return sb.toString();
    }
}

