/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.csskit.AbstractRuleBlock;
import cz.vutbr.web.csskit.OutputUtil;

public class RuleMarginImpl
extends AbstractRuleBlock<Declaration>
implements RuleMargin {
    private final MarginArea marginArea;

    protected RuleMarginImpl(String area) {
        for (MarginArea a : MarginArea.values()) {
            if (!a.value.equals(area)) continue;
            this.marginArea = a;
            return;
        }
        throw new IllegalArgumentException("Illegal value for margin area: " + area);
    }

    @Override
    public String getMarginArea() {
        return this.marginArea.value;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int depth) {
        StringBuilder sb = new StringBuilder();
        sb = OutputUtil.appendTimes(sb, "\t", depth);
        sb.append("@").append(this.getMarginArea());
        sb.append(" {\n");
        sb = OutputUtil.appendList(sb, this.list, "\n", depth + 1);
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.getMarginArea().hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RuleMarginImpl)) {
            return false;
        }
        RuleMarginImpl other = (RuleMarginImpl)obj;
        return this.getMarginArea().equals(other.getMarginArea());
    }

    private static enum MarginArea {
        TOPLEFTCORNER("top-left-corner"),
        TOPLEFT("top-left"),
        TOPCENTER("top-center"),
        TOPRIGHT("top-right"),
        TOPRIGHTCORNER("top-right-corner"),
        BOTTOMLEFTCORNER("bottom-left-corner"),
        BOTTOMLEFT("bottom-left"),
        BOTTOMCENTER("bottom-center"),
        BOTTOMRIGHT("bottom-right"),
        BOTTOMRIGHTCORNER("bottom-right-corner"),
        LEFTTOP("left-top"),
        LEFTMIDDLE("left-middle"),
        LEFTBOTTOM("left-bottom"),
        RIGHTTOP("right-top"),
        RIGHTMIDDLE("right-middle"),
        RIGHTBOTTOM("right-bottom");

        public final String value;

        private MarginArea(String value) {
            this.value = value;
        }
    }
}

