/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.MatchCondition;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.AbstractRule;
import cz.vutbr.web.csskit.ElementUtil;
import cz.vutbr.web.csskit.OutputUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectorImpl
extends AbstractRule<Selector.SelectorPart>
implements Selector {
    protected Selector.Combinator combinator;

    @Override
    public Selector.Combinator getCombinator() {
        return this.combinator;
    }

    @Override
    public Selector setCombinator(Selector.Combinator combinator) {
        this.combinator = combinator;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.combinator != null) {
            sb.append(this.combinator.value());
        }
        sb = OutputUtil.appendList(sb, this.list, "");
        return sb.toString();
    }

    @Override
    public String getClassName() {
        String className = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.ElementClass)) continue;
            className = ((Selector.ElementClass)item).getClassName();
        }
        return className;
    }

    @Override
    public String getIDName() {
        String idName = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.ElementID)) continue;
            idName = ((Selector.ElementID)item).getID();
        }
        return idName;
    }

    @Override
    public Selector.ElementName getElementName() {
        Selector.ElementName elementName = null;
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.ElementName)) continue;
            elementName = (Selector.ElementName)item;
        }
        return elementName;
    }

    @Override
    public Selector.PseudoElement getPseudoElement() {
        for (Selector.SelectorPart item : this.list) {
            if (!(item instanceof Selector.PseudoElement)) continue;
            return (Selector.PseudoElement)item;
        }
        return null;
    }

    @Override
    public boolean matches(Element e) {
        for (Selector.SelectorPart item : this.list) {
            if (item != null && item.matches(e, CSSFactory.getDefaultMatchCondition())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(Element e, MatchCondition cond) {
        for (Selector.SelectorPart item : this.list) {
            if (item != null && item.matches(e, cond)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void computeSpecificity(CombinedSelector.Specificity spec) {
        for (Selector.SelectorPart item : this.list) {
            item.computeSpecificity(spec);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.combinator == null ? 0 : this.combinator.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SelectorImpl)) {
            return false;
        }
        SelectorImpl other = (SelectorImpl)obj;
        return !(this.combinator == null ? other.combinator != null : !this.combinator.equals((Object)other.combinator));
    }

    public static class ElementDOMImpl
    implements Selector.ElementDOM {
        private Element elem;
        private boolean inlinePriority;

        protected ElementDOMImpl(Element e, boolean inlinePriority) {
            this.elem = e;
            this.inlinePriority = inlinePriority;
        }

        @Override
        public Element getElement() {
            return this.elem;
        }

        @Override
        public Selector.ElementDOM setElement(Element e) {
            this.elem = e;
            return this;
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            if (this.inlinePriority) {
                spec.add(CombinedSelector.Specificity.Level.A);
            }
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            return this.elem.equals(e);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.elem == null ? 0 : this.elem.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementDOMImpl)) {
                return false;
            }
            ElementDOMImpl other = (ElementDOMImpl)obj;
            return !(this.elem == null ? other.elem != null : !this.elem.equals(other.elem));
        }
    }

    public static class ElementAttributeImpl
    implements Selector.ElementAttribute {
        private Selector.Operator operator;
        private String localName;
        private String namespaceURI;
        private String prefix;
        private String value;
        private boolean isStringValue;

        protected ElementAttributeImpl(String value, boolean isStringValue, Selector.Operator operator, String namespaceURI, String localName, String prefix) {
            this.isStringValue = isStringValue;
            this.operator = operator;
            this.setAttribute(namespaceURI, localName, prefix);
            this.setValue(value);
        }

        @Override
        public Selector.Operator getOperator() {
            return this.operator;
        }

        @Override
        public void setOperator(Selector.Operator operator) {
            this.operator = operator;
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Selector.ElementAttribute setAttribute(String namespaceURI, String localName, String prefix) {
            if (localName == null || localName.equals("")) {
                throw new IllegalArgumentException("Invalid localName (" + localName + ")");
            }
            if ((prefix == null || prefix.equals("")) && !"".equals(namespaceURI) || "*".equals(prefix) && namespaceURI != null || namespaceURI == null && !"*".equals(prefix)) {
                throw new IllegalArgumentException("Invalid combination of prefix (" + prefix + ")" + " and namespaceURI (" + namespaceURI + ")");
            }
            this.localName = localName;
            this.namespaceURI = namespaceURI;
            this.prefix = prefix;
            return this;
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.C);
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            return ElementUtil.matchesAttribute(e, this.namespaceURI, this.localName, this.value, this.operator);
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Selector.ElementAttribute setValue(String value) {
            this.value = value;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            if (this.prefix != null) {
                sb.append(this.prefix + "|");
            }
            sb.append(this.localName);
            sb.append(this.operator.value());
            if (this.isStringValue && this.value != null) {
                sb.append("'");
            }
            if (this.value != null) {
                sb.append(this.value);
            }
            if (this.isStringValue && this.value != null) {
                sb.append("'");
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
            result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            result = 31 * result + (this.isStringValue ? 1231 : 1237);
            result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementAttributeImpl)) {
                return false;
            }
            ElementAttributeImpl other = (ElementAttributeImpl)obj;
            if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
                return false;
            }
            if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
                return false;
            }
            if (this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix)) {
                return false;
            }
            if (this.isStringValue != other.isStringValue) {
                return false;
            }
            if (this.operator == null ? other.operator != null : !this.operator.equals((Object)other.operator)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class ElementIDImpl
    implements Selector.ElementID {
        private String id;

        protected ElementIDImpl(String value) {
            this.setID(value);
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.B);
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            return ElementUtil.matchesID(e, this.id);
        }

        @Override
        public Selector.ElementID setID(String id) {
            if (id == null) {
                throw new IllegalArgumentException("Invalid element ID (null)");
            }
            this.id = id;
            return this;
        }

        @Override
        public String getID() {
            return this.id;
        }

        public String toString() {
            return "#" + this.id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementIDImpl)) {
                return false;
            }
            ElementIDImpl other = (ElementIDImpl)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }
    }

    public static class PseudoElementImpl
    implements Selector.PseudoElement {
        static final HashSet<String> PSEUDO_CLASS_DEFS = new HashSet();
        private final String name;

        protected PseudoElementImpl(String name) {
            if (!PSEUDO_CLASS_DEFS.contains(name)) {
                throw new IllegalArgumentException(name + " is not a valid pseudo-element name");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String[] getArguments() {
            return new String[0];
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.D);
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(":").append(":").append(this.name).append("");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PseudoElementImpl)) {
                return false;
            }
            PseudoElementImpl other = (PseudoElementImpl)obj;
            return this.name.equals(other.name);
        }

        static {
            PSEUDO_CLASS_DEFS.add("first-line");
            PSEUDO_CLASS_DEFS.add("first-letter");
            PSEUDO_CLASS_DEFS.add("before");
            PSEUDO_CLASS_DEFS.add("after");
        }
    }

    public static class PseudoClassImpl
    implements Selector.PseudoClass {
        private static final HashMap<String, PseudoClassDef> PSEUDO_CLASS_DEFS = new HashMap();
        private final PseudoClassDef def;
        private final List<String> args;
        private int[] elementIndex;
        static final Pattern WHITESPACE_RE;

        protected PseudoClassImpl(String name, String ... args) {
            name = name.toLowerCase();
            if (!PSEUDO_CLASS_DEFS.containsKey(name)) {
                throw new IllegalArgumentException(name + " is not a valid pseudo-class name");
            }
            this.def = PSEUDO_CLASS_DEFS.get(name);
            if (args.length > 0 && this.def.maxArgs == 0) {
                throw new IllegalArgumentException(name + " must not be a function");
            }
            if (args.length == 0 && this.def.minArgs > 0) {
                throw new IllegalArgumentException(name + " must be a function");
            }
            if (this.def.minArgs > 0) {
                if (args.length < this.def.minArgs || args.length > this.def.maxArgs) {
                    throw new IllegalArgumentException(name + " requires " + this.def.minArgs + (this.def.maxArgs > this.def.minArgs ? ".." + this.def.maxArgs : "") + " " + (this.def.minArgs == 1 && this.def.maxArgs == 1 ? "argument" : "arguments"));
                }
                this.args = new ArrayList<String>();
                for (String a : args) {
                    this.args.add(a);
                }
            } else {
                this.args = null;
            }
            this.elementIndex = null;
            if (this.def == PseudoClassDef.NTH_CHILD || this.def == PseudoClassDef.NTH_LAST_CHILD || this.def == PseudoClassDef.NTH_OF_TYPE || this.def == PseudoClassDef.NTH_LAST_OF_TYPE) {
                try {
                    this.elementIndex = PseudoClassImpl.decodeIndex(args[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.C);
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            switch (this.def) {
                case FIRST_CHILD: 
                case LAST_CHILD: 
                case ONLY_CHILD: {
                    if (e.getParentNode().getNodeType() == 1) {
                        boolean first = false;
                        boolean last = false;
                        if (this.def != PseudoClassDef.LAST_CHILD) {
                            Node prev = e;
                            do {
                                if ((prev = prev.getPreviousSibling()) != null) continue;
                                first = true;
                                break;
                            } while (prev.getNodeType() != 1);
                        }
                        if (this.def != PseudoClassDef.FIRST_CHILD) {
                            Node next = e;
                            do {
                                if ((next = next.getNextSibling()) != null) continue;
                                last = true;
                                break;
                            } while (next.getNodeType() != 1);
                        }
                        switch (this.def) {
                            case FIRST_CHILD: {
                                return first;
                            }
                            case LAST_CHILD: {
                                return last;
                            }
                        }
                        return first && last;
                    }
                    return false;
                }
                case FIRST_OF_TYPE: 
                case LAST_OF_TYPE: 
                case ONLY_OF_TYPE: {
                    if (e.getParentNode().getNodeType() == 1) {
                        boolean firstt = false;
                        boolean lastt = false;
                        if (this.def != PseudoClassDef.LAST_OF_TYPE) {
                            Node prev = e;
                            firstt = true;
                            do {
                                if ((prev = prev.getPreviousSibling()) == null || prev.getNodeType() != 1 || !this.isSameElementType(e, (Element)prev)) continue;
                                firstt = false;
                            } while (prev != null && firstt);
                        }
                        if (this.def != PseudoClassDef.FIRST_OF_TYPE) {
                            Node next = e;
                            lastt = true;
                            do {
                                if ((next = next.getNextSibling()) == null || next.getNodeType() != 1 || !this.isSameElementType(e, (Element)next)) continue;
                                lastt = false;
                            } while (next != null && lastt);
                        }
                        switch (this.def) {
                            case FIRST_OF_TYPE: {
                                return firstt;
                            }
                            case LAST_OF_TYPE: {
                                return lastt;
                            }
                        }
                        return firstt && lastt;
                    }
                    return false;
                }
                case NTH_CHILD: {
                    return this.positionMatches(this.countSiblingsBefore(e, false) + 1, this.elementIndex);
                }
                case NTH_LAST_CHILD: {
                    return this.positionMatches(this.countSiblingsAfter(e, false) + 1, this.elementIndex);
                }
                case NTH_OF_TYPE: {
                    return this.positionMatches(this.countSiblingsBefore(e, true) + 1, this.elementIndex);
                }
                case NTH_LAST_OF_TYPE: {
                    return this.positionMatches(this.countSiblingsAfter(e, true) + 1, this.elementIndex);
                }
                case ROOT: {
                    return e.getParentNode().getNodeType() == 9;
                }
                case BLANK: 
                case EMPTY: {
                    NodeList elist = e.getChildNodes();
                    for (int i = 0; i < elist.getLength(); ++i) {
                        Node n = elist.item(i);
                        short t = n.getNodeType();
                        if (t == 1 || t == 4 || t == 5) {
                            return false;
                        }
                        if (t != 3 || this.def != PseudoClassDef.EMPTY && WHITESPACE_RE.matcher(n.getNodeValue()).matches()) continue;
                        return false;
                    }
                    return true;
                }
            }
            return cond.isSatisfied(e, this);
        }

        protected boolean positionMatches(int pos, int[] n) {
            if (n != null) {
                try {
                    int an = pos - n[1];
                    if (n[0] == 0) {
                        return an == 0;
                    }
                    return an * n[0] >= 0 && an % n[0] == 0;
                }
                catch (NumberFormatException ex) {
                    return false;
                }
            }
            return false;
        }

        protected static int[] decodeIndex(String index) throws NumberFormatException {
            String s = index.toLowerCase().trim();
            if (s.equals("odd")) {
                int[] ret = new int[]{2, 1};
                return ret;
            }
            if (s.equals("even")) {
                int[] ret = new int[]{2, 0};
                return ret;
            }
            int[] ret = new int[]{0, 0};
            int n = s.indexOf(110);
            if (n != -1) {
                String sa = s.substring(0, n).trim();
                ret[0] = sa.length() == 0 ? 1 : (sa.equals("-") ? -1 : Integer.parseInt(sa));
                ++n;
                StringBuilder sb = new StringBuilder();
                while (n < s.length()) {
                    char ch = s.charAt(n);
                    if (ch != '+' && !Character.isWhitespace(ch)) {
                        sb.append(ch);
                    }
                    ++n;
                }
                if (sb.length() > 0) {
                    ret[1] = Integer.parseInt(sb.toString());
                }
            } else {
                ret[1] = Integer.parseInt(s);
            }
            return ret;
        }

        protected int countSiblingsBefore(Element e, boolean sameType) {
            int cnt = 0;
            Node prev = e;
            do {
                if ((prev = prev.getPreviousSibling()) == null || prev.getNodeType() != 1 || sameType && !this.isSameElementType(e, (Element)prev)) continue;
                ++cnt;
            } while (prev != null);
            return cnt;
        }

        protected int countSiblingsAfter(Element e, boolean sameType) {
            int cnt = 0;
            Node next = e;
            do {
                if ((next = next.getNextSibling()) == null || next.getNodeType() != 1 || sameType && !this.isSameElementType(e, (Element)next)) continue;
                ++cnt;
            } while (next != null);
            return cnt;
        }

        protected boolean isSameElementType(Element e1, Element e2) {
            return e1.getNodeName().equalsIgnoreCase(e2.getNodeName());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(":").append(this.def.name);
            if (this.args != null) {
                sb.append("(");
                OutputUtil.appendList(sb, this.args, ", ");
                sb.append(")");
            }
            sb.append("");
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.def.hashCode();
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof PseudoClassImpl)) {
                return false;
            }
            PseudoClassImpl other = (PseudoClassImpl)obj;
            if (this.def != other.def) {
                return false;
            }
            return this.args == null || this.args.equals(other.args);
        }

        static {
            for (PseudoClassDef d : PseudoClassDef.values()) {
                PSEUDO_CLASS_DEFS.put(d.name, d);
            }
            WHITESPACE_RE = Pattern.compile("\\s*");
        }

        private static enum PseudoClassDef {
            ACTIVE("active"),
            FOCUS("focus"),
            HOVER("hover"),
            LINK("link"),
            VISITED("visited"),
            FIRST_CHILD("first-child"),
            LAST_CHILD("last-child"),
            ONLY_CHILD("only-child"),
            ONLY_OF_TYPE("only-of-type"),
            NTH_CHILD("nth-child", 1),
            NTH_LAST_CHILD("nth-last-child", 1),
            NTH_OF_TYPE("nth-of-type", 1),
            NTH_LAST_OF_TYPE("nth-last-of-type", 1),
            FIRST_OF_TYPE("first-of-type"),
            LAST_OF_TYPE("last-of-type"),
            ROOT("root"),
            EMPTY("empty"),
            BLANK("blank"),
            LANG("lang", 1),
            ENABLED("enabled"),
            DISABLED("disabled"),
            CHECKED("checked"),
            TARGET("target");

            private final String name;
            private final int minArgs;
            private final int maxArgs;

            private PseudoClassDef(String name) {
                this.name = name;
                this.minArgs = 0;
                this.maxArgs = 0;
            }

            private PseudoClassDef(String name, int args) {
                this(name, args, args);
            }

            private PseudoClassDef(String name, int minArgs, int maxArgs) {
                this.name = name;
                this.minArgs = minArgs;
                this.maxArgs = maxArgs;
            }
        }
    }

    public static class ElementClassImpl
    implements Selector.ElementClass {
        private String className;

        protected ElementClassImpl(String className) {
            this.setClassName(className);
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            spec.add(CombinedSelector.Specificity.Level.C);
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            return ElementUtil.matchesClass(e, this.className);
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public Selector.ElementClass setClassName(String className) {
            if (className == null) {
                throw new IllegalArgumentException("Invalid element class (null)");
            }
            this.className = className;
            return this;
        }

        public String toString() {
            return "." + this.className;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementClassImpl)) {
                return false;
            }
            ElementClassImpl other = (ElementClassImpl)obj;
            return !(this.className == null ? other.className != null : !this.className.equals(other.className));
        }
    }

    public static class ElementNameImpl
    implements Selector.ElementName {
        private String localName;
        private String namespaceURI;
        private String prefix;
        private boolean locked = false;

        protected ElementNameImpl(String namespaceURI, String localName, String prefix) {
            this.setName(namespaceURI, localName, prefix);
        }

        @Override
        public void computeSpecificity(CombinedSelector.Specificity spec) {
            if (!"*".equals(this.localName)) {
                spec.add(CombinedSelector.Specificity.Level.D);
            }
        }

        private boolean matchesLocalName(Element e) {
            if (this.localName.equals("*")) {
                return true;
            }
            return this.localName.equalsIgnoreCase(e.getLocalName());
        }

        private boolean matchesNamespaceURI(Element e) {
            if (this.namespaceURI == null) {
                return true;
            }
            String elementNS = e.getNamespaceURI();
            if (elementNS == null) {
                elementNS = "";
            }
            return this.namespaceURI.equals(elementNS);
        }

        @Override
        public boolean matches(Element e, MatchCondition cond) {
            return this.matchesLocalName(e) && this.matchesNamespaceURI(e);
        }

        @Override
        public String getLocalName() {
            return this.localName;
        }

        @Override
        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        @Override
        public String getPrefix() {
            return this.prefix;
        }

        @Override
        public Selector.ElementName setName(String namespaceURI, String localName, String prefix) {
            if (this.locked) {
                throw new UnsupportedOperationException("Immutable object");
            }
            if (localName == null || localName.equals("")) {
                throw new IllegalArgumentException("Invalid localName (" + localName + ")");
            }
            if ("".equals(prefix) && !"".equals(namespaceURI) || "*".equals(prefix) && namespaceURI != null || namespaceURI == null && prefix != null && !prefix.equals("*")) {
                throw new IllegalArgumentException("Invalid combination of prefix (" + prefix + ")" + " and namespaceURI (" + namespaceURI + ")");
            }
            this.localName = localName;
            this.namespaceURI = namespaceURI;
            this.prefix = prefix;
            return this;
        }

        @Override
        public Selector.ElementName lock() {
            this.locked = true;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.prefix != null) {
                sb.append(this.prefix + "|");
            }
            sb.append(this.localName);
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
            result = 31 * result + (this.namespaceURI == null ? 0 : this.namespaceURI.hashCode());
            result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ElementNameImpl)) {
                return false;
            }
            ElementNameImpl other = (ElementNameImpl)obj;
            if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
                return false;
            }
            if (this.namespaceURI == null ? other.namespaceURI != null : !this.namespaceURI.equals(other.namespaceURI)) {
                return false;
            }
            return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
        }
    }
}

