/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.SourceLocator;
import cz.vutbr.web.csskit.antlr.CSSSourceReader;
import cz.vutbr.web.csskit.antlr.SourceMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CharStream;

public class CSSInputStream
implements CharStream {
    private CharStream input;
    private URL base = null;
    private SourceMap sourceMap = null;
    private CSSSourceReader.CSSInputStream source = null;

    public static CSSInputStream newInstance(String input, URL base) throws IOException {
        return CSSInputStream.newInstance(new StringReader(input), base, null);
    }

    public static CSSInputStream newInstance(CSSSourceReader.CSSInputStream input) throws IOException {
        CSSInputStream stream = CSSInputStream.newInstance(input.stream, input.base, input.sourceMap);
        stream.source = input;
        return stream;
    }

    public static CSSInputStream newInstance(Reader input, URL base, SourceMap sourceMap) throws IOException {
        CSSInputStream stream = new CSSInputStream();
        stream.input = new ANTLRReaderStream((Reader)new BufferedReader(input));
        stream.base = base;
        stream.sourceMap = sourceMap;
        return stream;
    }

    private CSSInputStream() {
    }

    public int LT(int arg0) {
        return this.input.LT(arg0);
    }

    public int getCharPositionInLine() {
        return this.input.getCharPositionInLine();
    }

    public int getLine() {
        return this.input.getLine();
    }

    public void setCharPositionInLine(int arg0) {
        this.input.setCharPositionInLine(arg0);
    }

    public void setLine(int arg0) {
        this.input.setLine(arg0);
    }

    public String substring(int arg0, int arg1) {
        return this.input.substring(arg0, arg1);
    }

    public int LA(int arg0) {
        return this.input.LA(arg0);
    }

    public void consume() {
        this.input.consume();
    }

    public int index() {
        return this.input.index();
    }

    public int mark() {
        return this.input.mark();
    }

    public void release(int arg0) {
        this.input.release(arg0);
    }

    public void rewind() {
        this.input.rewind();
    }

    public void rewind(int arg0) {
        this.input.rewind(arg0);
    }

    public void seek(int arg0) {
        this.input.seek(arg0);
    }

    public int size() {
        return this.input.size();
    }

    public String getSourceName() {
        return this.base != null ? this.base.toString() : "";
    }

    public SourceLocator getSourceLocator() {
        final int line = this.getLine() - 1;
        final int column = this.getCharPositionInLine();
        SourceLocator loc = null;
        if (this.sourceMap != null) {
            loc = this.sourceMap.floor(line, column);
        }
        if (loc == null) {
            loc = new SourceLocator(){

                @Override
                public URL getURL() {
                    return CSSInputStream.this.base;
                }

                @Override
                public int getLineNumber() {
                    return line;
                }

                @Override
                public int getColumnNumber() {
                    return column;
                }

                public String toString() {
                    return (CSSInputStream.this.base == null ? "<internal>" : CSSInputStream.this.base.toString()) + ":" + line + ":" + column;
                }
            };
        }
        return loc;
    }

    public void setEncoding(Charset encoding) throws IOException {
        if (this.source != null) {
            try {
                this.input = new ANTLRReaderStream((Reader)new BufferedReader(this.source.reread(encoding)));
            }
            finally {
                this.source = null;
            }
        }
    }
}

