/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSException;
import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.MediaQueryList;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleList;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.StyleSheet;
import cz.vutbr.web.csskit.antlr.CSSInputStream;
import cz.vutbr.web.csskit.antlr.CSSLexer;
import cz.vutbr.web.csskit.antlr.CSSParser;
import cz.vutbr.web.csskit.antlr.CSSSource;
import cz.vutbr.web.csskit.antlr.CSSSourceReader;
import cz.vutbr.web.csskit.antlr.CSSTreeParser;
import cz.vutbr.web.csskit.antlr.Preparator;
import cz.vutbr.web.csskit.antlr.SimplePreparator;
import cz.vutbr.web.csskit.antlr.TreeUtil;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;
import org.fit.net.DataURLHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSSParserFactory {
    private static final Logger log = LoggerFactory.getLogger(CSSParserFactory.class);
    private static CSSParserFactory instance;

    protected static CSSInputStream getInput(CSSSource source, CSSSourceReader cssReader) throws IOException {
        switch (source.type) {
            case INLINE: 
            case EMBEDDED: 
            case URL: {
                return CSSInputStream.newInstance(cssReader.read(source));
            }
        }
        throw new RuntimeException("Coding error");
    }

    private static CommonTree getAST(CSSParser parser, CSSSource.SourceType type) throws CSSException {
        switch (type) {
            case INLINE: {
                try {
                    CSSParser.inlinestyle_return retval = parser.inlinestyle();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style");
                }
            }
            case EMBEDDED: {
                try {
                    CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style");
                }
            }
            case URL: {
                try {
                    CSSParser.stylesheet_return retval = parser.stylesheet();
                    return (CommonTree)retval.getTree();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse URL CSS style");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse URL CSS style");
                }
            }
        }
        throw new RuntimeException("Coding error");
    }

    private static RuleList parse(CSSTreeParser parser, CSSSource.SourceType type) throws CSSException {
        switch (type) {
            case INLINE: {
                try {
                    return parser.inlinestyle();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse inline CSS style [AST]");
                }
            }
            case EMBEDDED: {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse embedded CSS style [AST]");
                }
            }
            case URL: {
                try {
                    return parser.stylesheet();
                }
                catch (RecognitionException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
                catch (RuntimeException re) {
                    throw CSSParserFactory.encapsulateException(re, "Unable to parse file CSS style [AST]");
                }
            }
        }
        throw new RuntimeException("Coding error");
    }

    protected static CSSException encapsulateException(Throwable t, String msg) {
        log.error("THROWN:", t);
        return new CSSException(msg, t);
    }

    protected CSSParserFactory() {
    }

    public static CSSParserFactory getInstance() {
        if (instance == null) {
            instance = new CSSParserFactory();
        }
        return instance;
    }

    public StyleSheet parse(CSSSource source, CSSSourceReader cssReader, boolean inlinePriority) throws IOException, CSSException {
        StyleSheet sheet = (StyleSheet)CSSFactory.getRuleFactory().createStyleSheet().unlock();
        SimplePreparator preparator = new SimplePreparator(source.inlineElement, inlinePriority);
        StyleSheet ret = this.parseAndImport(source, cssReader, sheet, preparator, null);
        return ret;
    }

    public StyleSheet parse(CSSSource source, CSSSourceReader cssReader) throws IOException, CSSException {
        if (source.type == CSSSource.SourceType.INLINE) {
            throw new IllegalArgumentException("Missing inlinePriority for INLINE input");
        }
        return this.parse(source, cssReader, false);
    }

    public StyleSheet append(CSSSource source, CSSSourceReader cssReader, boolean inlinePriority, StyleSheet sheet) throws IOException, CSSException {
        SimplePreparator preparator = new SimplePreparator(source.inlineElement, inlinePriority);
        StyleSheet ret = this.parseAndImport(source, cssReader, sheet, preparator, null);
        return ret;
    }

    public StyleSheet append(CSSSource source, CSSSourceReader cssReader, StyleSheet sheet) throws IOException, CSSException {
        if (source.type == CSSSource.SourceType.INLINE) {
            throw new IllegalArgumentException("Missing inlinePriority for INLINE input");
        }
        return this.append(source, cssReader, false, sheet);
    }

    protected StyleSheet parseAndImport(CSSSource source, CSSSourceReader cssReader, StyleSheet sheet, Preparator preparator, MediaQueryList media) throws CSSException, IOException {
        CSSTreeParser parser = CSSParserFactory.createTreeParser(source, cssReader, preparator);
        CSSParserFactory.parse(parser, source.type);
        for (int i = 0; i < parser.getImportPaths().size(); ++i) {
            String path = parser.getImportPaths().get(i);
            MediaQueryList imedia = parser.getImportMedia().get(i);
            if (media != null) {
                imedia = media.and(imedia);
            }
            if (CSSFactory.getAutoImportMedia().matches(imedia)) {
                URL url = DataURLHandler.createURL(source.base, path);
                try {
                    this.parseAndImport(new CSSSource(url, null, null), cssReader, sheet, preparator, imedia);
                }
                catch (IOException e) {
                    log.warn("Couldn't read imported style sheet: {}", (Object)e.getMessage());
                }
                continue;
            }
            log.trace("Skipping import {} (media not matching)", (Object)path);
        }
        RuleList rules = parser.getRules();
        if (media != null) {
            RuleMedia rm = CSSFactory.getRuleFactory().createMedia();
            rm.setMediaQueries(media);
            log.debug("Wrapping rules {} into RuleMedia: {}", (Object)rules, (Object)rm);
            rm.unlock();
            rm.replaceAll(rules);
        }
        return CSSParserFactory.addRulesToStyleSheet(rules, sheet);
    }

    protected static StyleSheet addRulesToStyleSheet(RuleList rules, StyleSheet sheet) {
        if (rules != null) {
            for (RuleBlock rule : rules) {
                sheet.add(rule);
            }
        }
        return sheet;
    }

    private static CSSTreeParser createTreeParser(CSSSource source, CSSSourceReader cssReader, Preparator preparator) throws IOException, CSSException {
        CSSInputStream input = CSSParserFactory.getInput(source, cssReader);
        CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
        CommonTree ast = CSSParserFactory.feedParser(tokens, source.type);
        return CSSParserFactory.feedAST(tokens, ast, preparator, null);
    }

    private static CommonTokenStream feedLexer(CSSInputStream source) throws CSSException {
        try {
            CSSLexer lexer = new CSSLexer(source);
            lexer.init();
            return new CommonTokenStream((TokenSource)lexer);
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof CSSException) {
                throw (CSSException)re.getCause();
            }
            log.error("LEXER THROWS:", (Throwable)re);
            throw re;
        }
    }

    private static CommonTree feedParser(CommonTokenStream source, CSSSource.SourceType type) throws CSSException {
        CSSParser parser = new CSSParser((TokenStream)source);
        parser.init();
        return CSSParserFactory.getAST(parser, type);
    }

    private static CSSTreeParser feedAST(CommonTokenStream source, CommonTree ast, Preparator preparator, Map<String, String> namespaces) {
        if (log.isTraceEnabled()) {
            log.trace("Feeding tree parser with AST:\n{}", (Object)TreeUtil.toStringTree(ast));
        }
        CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)ast);
        nodes.setTokenStream((TokenStream)source);
        CSSTreeParser parser = new CSSTreeParser((TreeNodeStream)nodes);
        parser.init(preparator, namespaces);
        return parser;
    }

    public MediaQueryList parseMediaQuery(String query) {
        try {
            CSSInputStream input = CSSInputStream.newInstance(query, new URL("file://media/query/url"));
            CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
            CSSParser parser = new CSSParser((TokenStream)tokens);
            parser.init();
            CSSParser.media_return retval = parser.media();
            CommonTree ast = (CommonTree)retval.getTree();
            CSSTreeParser tparser = CSSParserFactory.feedAST(tokens, ast, null, null);
            return tparser.media();
        }
        catch (IOException e) {
            log.error("I/O error during media query parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed media query {}", (Object)query);
            return null;
        }
    }

    public List<CombinedSelector> parseSelector(String selector, Map<String, String> namespaces) {
        try {
            CSSInputStream input = CSSInputStream.newInstance(selector, null);
            CommonTokenStream tokens = CSSParserFactory.feedLexer(input);
            CSSParser parser = new CSSParser((TokenStream)tokens);
            parser.init();
            CommonTree ast = (CommonTree)parser.combined_selector_list().getTree();
            CSSTreeParser tparser = CSSParserFactory.feedAST(tokens, ast, null, namespaces);
            return tparser.combined_selector_list();
        }
        catch (IOException e) {
            log.error("I/O error during selector parsing: {}", (Object)e.getMessage());
            return null;
        }
        catch (CSSException e) {
            log.warn("Malformed selector {}", (Object)selector);
            return null;
        }
        catch (RecognitionException e) {
            log.warn("Malformed selector {}", (Object)selector);
            return null;
        }
    }
}

