/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import java.net.URL;
import java.nio.charset.Charset;
import org.w3c.dom.Element;

public class CSSSource {
    public SourceType type;
    public Object source;
    public Element inlineElement;
    public Charset encoding;
    public URL base;
    public int lineOffset = 0;
    public int columnOffset = 0;
    public String mediaType;

    public CSSSource(String source, Element inlineElement, URL base) {
        this.type = SourceType.INLINE;
        this.source = source;
        this.inlineElement = inlineElement;
        this.base = base;
    }

    public CSSSource(String source, String mediaType, URL base, int lineOffset, int columnOffset) {
        this.type = SourceType.EMBEDDED;
        this.source = source;
        this.mediaType = mediaType;
        this.base = base;
        if (lineOffset > 0) {
            this.lineOffset = lineOffset;
        }
        if (columnOffset > 0) {
            this.columnOffset = columnOffset;
        }
    }

    public CSSSource(URL source, Charset encoding, String mediaType) {
        this.type = SourceType.URL;
        this.source = source;
        this.encoding = encoding;
        this.mediaType = mediaType;
        this.base = source;
    }

    public static enum SourceType {
        INLINE,
        EMBEDDED,
        URL;

    }
}

