/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.NetworkProcessor;
import cz.vutbr.web.css.SourceLocator;
import cz.vutbr.web.csskit.DefaultNetworkProcessor;
import cz.vutbr.web.csskit.antlr.CSSSource;
import cz.vutbr.web.csskit.antlr.CSSSourceReader;
import cz.vutbr.web.csskit.antlr.SourceMap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class DefaultCSSSourceReader
implements CSSSourceReader {
    private final NetworkProcessor network;

    public DefaultCSSSourceReader() {
        this(new DefaultNetworkProcessor());
    }

    public DefaultCSSSourceReader(NetworkProcessor network) {
        this.network = network;
    }

    @Override
    public boolean supportsMediaType(String mediaType, URL url) {
        return "text/css".equals(mediaType) || mediaType == null && (url == null || url.toString().endsWith(".css"));
    }

    @Override
    public CSSSourceReader.CSSInputStream read(final CSSSource source) throws IOException {
        switch (source.type) {
            case INLINE: 
            case EMBEDDED: {
                if (!this.supportsMediaType(source.mediaType, null)) {
                    throw new IllegalArgumentException();
                }
                SourceMap sourceMap = null;
                if (source.lineOffset != 0 && source.columnOffset != 0) {
                    sourceMap = new SourceMap(){

                        @Override
                        public SourceLocator get(final int line, final int column) {
                            return new SourceLocator(){

                                @Override
                                public URL getURL() {
                                    return source.base;
                                }

                                @Override
                                public int getLineNumber() {
                                    return line + source.lineOffset;
                                }

                                @Override
                                public int getColumnNumber() {
                                    if (line == 0) {
                                        return column + source.columnOffset;
                                    }
                                    return column;
                                }
                            };
                        }

                        @Override
                        public SourceLocator floor(int line, int column) {
                            return this.get(line, column);
                        }

                        @Override
                        public SourceLocator ceiling(int line, int column) {
                            return this.get(line, column);
                        }
                    };
                }
                return new CSSSourceReader.CSSInputStream(new StringReader((String)source.source), source.base, sourceMap){

                    @Override
                    public Reader reread(Charset encoding) throws IOException {
                        StringReader r = new StringReader((String)source.source);
                        this.stream.close();
                        return r;
                    }
                };
            }
            case URL: {
                final URL url = (URL)source.source;
                if (!this.supportsMediaType(source.mediaType, url)) {
                    throw new IllegalArgumentException();
                }
                if (source.encoding != null) {
                    return new CSSSourceReader.CSSInputStream(this.network.fetch(url, source.encoding, true, false), url, null);
                }
                return new CSSSourceReader.CSSInputStream(this.network.fetch(url, StandardCharsets.UTF_8, false, false), url, null){

                    @Override
                    public Reader reread(Charset encoding) throws IOException {
                        Reader r = DefaultCSSSourceReader.this.network.fetch(url, encoding, false, true);
                        this.stream.close();
                        return r;
                    }
                };
            }
        }
        throw new RuntimeException("coding error");
    }
}

