/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CombinedSelector;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.MediaQueryList;
import cz.vutbr.web.css.RuleBlock;
import cz.vutbr.web.css.RuleFactory;
import cz.vutbr.web.css.RuleFontFace;
import cz.vutbr.web.css.RuleMargin;
import cz.vutbr.web.css.RuleMedia;
import cz.vutbr.web.css.RulePage;
import cz.vutbr.web.css.RuleSet;
import cz.vutbr.web.css.RuleViewport;
import cz.vutbr.web.css.Selector;
import cz.vutbr.web.csskit.antlr.Preparator;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SimplePreparator
implements Preparator {
    protected static final Logger log = LoggerFactory.getLogger(SimplePreparator.class);
    private final RuleFactory rf;
    public final Element elem;
    private boolean inlinePriority;

    public SimplePreparator(Element e, boolean inlinePriority) {
        this(e, inlinePriority, CSSFactory.getRuleFactory());
    }

    public SimplePreparator(Element e, boolean inlinePriority, RuleFactory rf) {
        this.elem = e;
        this.inlinePriority = inlinePriority;
        this.rf = rf;
    }

    @Override
    public RuleBlock<?> prepareRuleSet(List<CombinedSelector> cslist, List<Declaration> dlist) {
        if ((cslist == null || cslist.isEmpty()) && (dlist == null || dlist.isEmpty())) {
            log.debug("Empty RuleSet was ommited");
            return null;
        }
        RuleSet rs = this.rf.createSet();
        rs.setSelectors(cslist);
        rs.replaceAll(dlist);
        log.info("Created RuleSet as with:\n{}", (Object)rs);
        return rs;
    }

    @Override
    public RuleBlock<?> prepareRuleMedia(List<RuleBlock<?>> rules, MediaQueryList media) {
        if (rules == null || rules.isEmpty()) {
            log.debug("Empty RuleMedia was ommited");
            return null;
        }
        RuleMedia rm = this.rf.createMedia();
        rm.replaceAll(rules);
        if (media != null && !media.isEmpty()) {
            rm.setMediaQueries(media);
        }
        log.info("Create @media as with:\n{}", (Object)rm);
        return rm;
    }

    @Override
    public RuleBlock<?> prepareRulePage(List<Declaration> declarations, List<RuleMargin> marginRules, String name, String pseudo) {
        if ((declarations == null || declarations.isEmpty()) && (marginRules == null || marginRules.isEmpty())) {
            log.debug("Empty RulePage was ommited");
            return null;
        }
        RulePage rp = this.rf.createPage();
        if (declarations != null) {
            for (Declaration d : declarations) {
                rp.add(d);
            }
        }
        if (marginRules != null) {
            for (RuleMargin m : marginRules) {
                rp.add(m);
            }
        }
        rp.setName(name);
        rp.setPseudo(pseudo);
        log.info("Create @page as with:\n{}", (Object)rp);
        return rp;
    }

    @Override
    public RuleMargin prepareRuleMargin(String area, List<Declaration> decl) {
        if (decl == null || decl.isEmpty()) {
            log.debug("Empty RuleMargin was ommited");
            return null;
        }
        RuleMargin rm = this.rf.createMargin(area);
        rm.replaceAll(decl);
        log.info("Create @" + area + " with:\n" + rm);
        return rm;
    }

    @Override
    public RuleBlock<?> prepareRuleViewport(List<Declaration> decl) {
        if (decl == null || decl.isEmpty()) {
            log.debug("Empty Viewport was ommited");
            return null;
        }
        RuleViewport rp = this.rf.createViewport();
        rp.replaceAll(decl);
        log.info("Create @viewport as {}th with:\n{}", (Object)rp);
        return rp;
    }

    @Override
    public RuleBlock<?> prepareRuleFontFace(List<Declaration> decl) {
        if (decl == null || decl.isEmpty()) {
            log.debug("Empty RuleFontFace was ommited");
            return null;
        }
        RuleFontFace rp = this.rf.createFontFace();
        rp.replaceAll(decl);
        log.info("Create @font-face as with:\n{}", (Object)rp);
        return rp;
    }

    @Override
    public RuleBlock<?> prepareInlineRuleSet(List<Declaration> dlist, List<Selector.PseudoPage> pseudos) {
        if (dlist == null || dlist.isEmpty()) {
            log.debug("Empty RuleSet (inline) was ommited");
            return null;
        }
        CombinedSelector cs = (CombinedSelector)this.rf.createCombinedSelector().unlock();
        Selector sel = (Selector)this.rf.createSelector().unlock();
        sel.add(this.rf.createElementDOM(this.elem, this.inlinePriority));
        if (pseudos != null) {
            sel.addAll(pseudos);
        }
        cs.add(sel);
        RuleSet rs = this.rf.createSet();
        rs.replaceAll(dlist);
        rs.setSelectors(Arrays.asList(cs));
        log.info("Create @media as with:\n{}", (Object)rs);
        return rs;
    }
}

