/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.domassign;

import cz.vutbr.web.css.CSSFactory;
import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.Declaration;
import cz.vutbr.web.css.NodeData;
import cz.vutbr.web.css.SupportedCSS;
import cz.vutbr.web.css.Term;
import cz.vutbr.web.domassign.DeclarationTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SingleMapNodeData
implements NodeData,
Cloneable {
    private static final int COMMON_DECLARATION_SIZE = 7;
    private final DeclarationTransformer transformer;
    private final SupportedCSS css;
    protected Map<String, Quadruple> map;

    public SingleMapNodeData() {
        this(CSSFactory.getDeclarationTransformer(), CSSFactory.getSupportedCSS());
    }

    public SingleMapNodeData(DeclarationTransformer transformer, SupportedCSS css) {
        this.transformer = transformer;
        this.css = css;
        this.map = new HashMap<String, Quadruple>(css.getTotalProperties(), 1.0f);
    }

    @Override
    public <T extends CSSProperty> T getProperty(String name) {
        return this.getProperty(name, true);
    }

    @Override
    public <T extends CSSProperty> T getProperty(String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        CSSProperty tmp = includeInherited ? (q.curProp != null ? q.curProp : q.inhProp) : q.curProp;
        CSSProperty retval = tmp;
        return (T)retval;
    }

    @Override
    public Term<?> getValue(String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        if (includeInherited) {
            if (q.curValue != null) {
                return q.curValue;
            }
            if (q.curProp != null) {
                return null;
            }
            return q.inhValue;
        }
        return q.curValue;
    }

    @Override
    public <T extends Term<?>> T getValue(Class<T> clazz, String name) {
        return this.getValue(clazz, name, true);
    }

    @Override
    public <T extends Term<?>> T getValue(Class<T> clazz, String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        if (includeInherited) {
            if (q.curValue != null) {
                return (T)((Term)clazz.cast(q.curValue));
            }
            return (T)((Term)clazz.cast(q.inhValue));
        }
        return (T)((Term)clazz.cast(q.curValue));
    }

    @Override
    public NodeData push(Declaration d) {
        HashMap<String, CSSProperty> properties = new HashMap<String, CSSProperty>(7);
        HashMap terms = new HashMap(7);
        boolean result = this.transformer.parseDeclaration(d, properties, terms);
        if (!result) {
            return this;
        }
        for (String key : properties.keySet()) {
            Quadruple q = this.map.get(key);
            if (q == null) {
                q = new Quadruple();
            }
            q.curProp = (CSSProperty)properties.get(key);
            q.curValue = (Term)terms.get(key);
            q.curSource = d;
            if (q.curValue != null && q.curValue.getOperator() != null) {
                q.curValue = q.curValue.shallowClone().setOperator(null);
            }
            this.map.put(key, q);
        }
        return this;
    }

    @Override
    public NodeData concretize() {
        for (String key : this.map.keySet()) {
            Quadruple q = this.map.get(key);
            if (q.curProp != null && q.curProp.equalsInherit()) {
                if (q.inhProp == null) {
                    q.curProp = this.css.getDefaultProperty(key);
                } else {
                    q.curProp = q.inhProp;
                    q.curSource = q.inhSource;
                }
                q.curValue = q.inhValue == null ? this.css.getDefaultValue(key) : q.inhValue;
            }
            this.map.put(key, q);
        }
        return this;
    }

    @Override
    public NodeData inheritFrom(NodeData parent) throws ClassCastException {
        if (parent == null) {
            return this;
        }
        if (!(parent instanceof SingleMapNodeData)) {
            throw new ClassCastException("Cant't inherit from NodeData different from " + this.getClass().getName() + "(" + parent.getClass().getName() + ")");
        }
        SingleMapNodeData nd = (SingleMapNodeData)parent;
        for (String key : nd.map.keySet()) {
            boolean forceInherit;
            Quadruple qp = nd.map.get(key);
            Quadruple q = this.map.get(key);
            if (q == null) {
                q = new Quadruple();
            }
            boolean bl = forceInherit = q.curProp != null && q.curProp.equalsInherit();
            if (qp.inhProp != null && (qp.inhProp.inherited() || forceInherit)) {
                q.inhProp = qp.inhProp;
                q.inhValue = qp.inhValue;
                q.inhSource = qp.inhSource;
            }
            if (qp.curProp != null && (qp.curProp.inherited() || forceInherit)) {
                q.inhProp = qp.curProp;
                q.inhValue = qp.curValue;
                q.inhSource = qp.curSource;
            }
            if (q.isEmpty()) continue;
            this.map.put(key, q);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Quadruple q = this.map.get(key);
            CSSProperty prop = q.curProp;
            Term<?> value = q.curValue;
            if (prop == null) {
                prop = q.inhProp;
                if (value == null) {
                    value = q.inhValue;
                }
            }
            sb.append(key).append(": ");
            if (value != null) {
                sb.append(value.toString());
            } else {
                sb.append(prop.toString());
            }
            sb.append(";\n");
        }
        return sb.toString();
    }

    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.map.keySet());
        return keys;
    }

    @Override
    public Declaration getSourceDeclaration(String name) {
        return this.getSourceDeclaration(name, true);
    }

    @Override
    public Declaration getSourceDeclaration(String name, boolean includeInherited) {
        Quadruple q = this.map.get(name);
        if (q == null) {
            return null;
        }
        if (includeInherited) {
            if (q.curSource != null) {
                return q.curSource;
            }
            return q.inhSource;
        }
        return q.curSource;
    }

    public Object clone() {
        SingleMapNodeData clone;
        try {
            clone = (SingleMapNodeData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("coding error");
        }
        clone.map = new HashMap<String, Quadruple>(this.css.getTotalProperties(), 1.0f);
        for (String key : this.map.keySet()) {
            clone.map.put(key, (Quadruple)this.map.get(key).clone());
        }
        return clone;
    }

    static class Quadruple
    implements Cloneable {
        CSSProperty inhProp = null;
        CSSProperty curProp = null;
        Term<?> inhValue = null;
        Term<?> curValue = null;
        Declaration inhSource = null;
        Declaration curSource = null;

        public boolean isEmpty() {
            return this.inhProp == null && this.curProp == null && this.inhValue == null && this.curValue == null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.curProp == null ? 0 : this.curProp.hashCode());
            result = 31 * result + (this.curValue == null ? 0 : this.curValue.hashCode());
            result = 31 * result + (this.inhProp == null ? 0 : this.inhProp.hashCode());
            result = 31 * result + (this.inhValue == null ? 0 : this.inhValue.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Quadruple other = (Quadruple)obj;
            if (this.curProp == null ? other.curProp != null : !this.curProp.equals(other.curProp)) {
                return false;
            }
            if (this.curValue == null ? other.curValue != null : !this.curValue.equals(other.curValue)) {
                return false;
            }
            if (this.inhProp == null ? other.inhProp != null : !this.inhProp.equals(other.inhProp)) {
                return false;
            }
            return !(this.inhValue == null ? other.inhValue != null : !this.inhValue.equals(other.inhValue));
        }

        public Object clone() {
            Quadruple clone;
            try {
                clone = (Quadruple)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError("coding error");
            }
            if (this.inhValue != null) {
                clone.inhValue = (Term)this.inhValue.clone();
            }
            if (this.curValue != null) {
                clone.curValue = (Term)this.curValue.clone();
            }
            if (this.inhSource != null) {
                clone.inhSource = (Declaration)this.inhSource.clone();
            }
            if (this.curSource != null) {
                clone.curSource = (Declaration)this.curSource.clone();
            }
            return clone;
        }
    }
}

