/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class UnparsedEntity
extends SystemFunctionCall
implements Callable {
    public static int URI = 0;
    public static int PUBLIC_ID = 1;

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        UnparsedEntity f = (UnparsedEntity)super.simplify(visitor);
        f.addContextDocumentArgument(1, this.operation == URI ? "unparsed-entity-uri_9999_" : "unparsed-entity-public-id_9999_");
        return f;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        try {
            return super.typeCheck(visitor, contextItemType);
        }
        catch (XPathException err) {
            if ("XPDY0002".equals(err.getErrorCodeLocalPart())) {
                if (this.operation == URI) {
                    XPathException e = new XPathException("Cannot call the unparsed-entity-uri() function when there is no context node");
                    e.setErrorCode("XTDE1370");
                    throw e;
                }
                XPathException e = new XPathException("Cannot call the unparsed-entity-public-id() function when there is no context node");
                e.setErrorCode("XTDE1380");
                e.setLocator(this);
                throw e;
            }
            throw err;
        }
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        String[] ids;
        NodeInfo doc;
        String arg0;
        block7: {
            arg0 = this.argument[0].evaluateItem(context).getStringValue();
            doc = null;
            try {
                doc = (NodeInfo)this.argument[1].evaluateItem(context);
            }
            catch (XPathException err) {
                String code = err.getErrorCodeLocalPart();
                if ("XPDY0002".equals(code)) {
                    if (this.operation == URI) {
                        XPathException e = new XPathException("Cannot call the unparsed-entity-uri() function when there is no context node");
                        e.setErrorCode("XTDE1370");
                        throw e;
                    }
                    XPathException e = new XPathException("Cannot call the unparsed-entity-public-id() function when there is no context node");
                    e.setErrorCode("XTDE1380");
                    e.setLocator(this);
                    throw e;
                }
                if (!"XPDY0050".equals(code)) break block7;
                if (this.operation == URI) {
                    XPathException e = new XPathException("Can only call the unparsed-entity-uri() function when the context node is in a tree rooted at a document node");
                    e.setErrorCode("XTDE1370");
                    e.setLocator(this);
                    throw e;
                }
                XPathException e = new XPathException("Can only call the unparsed-entity-public-id() function when the context node is in a tree rooted at a document node");
                e.setErrorCode("XTDE1380");
                e.setLocator(this);
                throw e;
            }
        }
        if (doc.getNodeKind() != 9) {
            String code = this.operation == URI ? "XTDE1370" : "XTDE1380";
            this.dynamicError("In function " + this.getDisplayName() + ", the context node must be in a tree whose root is a document node", code, context);
        }
        if ((ids = ((DocumentInfo)doc).getUnparsedEntity(arg0)) == null) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(ids[this.operation]);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        String[] ids;
        String arg0 = arguments[0].head().getStringValue();
        NodeInfo doc = (NodeInfo)arguments[1].head();
        if (doc.getNodeKind() != 9) {
            String code = this.operation == URI ? "XTDE1370" : "XTDE1380";
            this.dynamicError("In function " + this.getDisplayName() + ", the context node must be in a tree whose root is a document node", code, context);
        }
        return (ids = ((DocumentInfo)doc).getUnparsedEntity(arg0)) == null ? StringValue.EMPTY_STRING : new StringValue(ids[this.operation]);
    }
}

