/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.UserFunctionReference;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLFunction
extends StyleElement
implements StylesheetProcedure {
    private String nameAtt = null;
    private String asAtt = null;
    private String overrideAtt = null;
    private SequenceType resultType;
    private String functionName;
    private SlotManager stackFrameMap;
    private boolean memoFunction = false;
    private boolean override = true;
    private int numberOfArguments = -1;
    private UserFunction compiledFunction;
    List<UserFunctionReference> references = new ArrayList<UserFunctionReference>(10);

    public void registerReference(UserFunctionReference ref) {
        this.references.add(ref);
    }

    public boolean isDeclaration() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        this.overrideAtt = "yes";
        for (int a = 0; a < atts.getLength(); ++a) {
            String uri = atts.getURI(a);
            String local = atts.getLocalName(a);
            if ("".equals(uri)) {
                if (local.equals("name")) {
                    this.nameAtt = Whitespace.trim(atts.getValue(a));
                    assert (this.nameAtt != null);
                    if (this.nameAtt.indexOf(58) < 0) {
                        this.compileError("Function name must have a namespace prefix", "XTSE0740");
                    }
                    try {
                        this.setObjectName(this.makeQName(this.nameAtt));
                    }
                    catch (NamespaceException err) {
                        this.compileError(err.getMessage(), "XTSE0280");
                    }
                    catch (XPathException err) {
                        this.compileError(err);
                    }
                    continue;
                }
                if (local.equals("as")) {
                    this.asAtt = atts.getValue(a);
                    continue;
                }
                if (local.equals("override")) {
                    this.overrideAtt = Whitespace.trim(atts.getValue(a));
                    if ("yes".equals(this.overrideAtt)) {
                        this.override = true;
                        continue;
                    }
                    if ("no".equals(this.overrideAtt)) {
                        this.override = false;
                        continue;
                    }
                    this.override = true;
                    this.compileError("override must be 'yes' or 'no'", "XTSE0020");
                    continue;
                }
                this.checkUnknownAttribute(atts.getNodeName(a));
                continue;
            }
            if (local.equals("memo-function") && uri.equals("http://saxon.sf.net/")) {
                String memoAtt = Whitespace.trim(atts.getValue(a));
                if ("yes".equals(memoAtt)) {
                    this.memoFunction = true;
                    continue;
                }
                if ("no".equals(memoAtt)) {
                    this.memoFunction = false;
                    continue;
                }
                this.compileError("saxon:memo-function must be 'yes' or 'no'", "XTSE0020");
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (this.nameAtt == null) {
            this.reportAbsence("name");
            this.nameAtt = "xsl:unnamed-function-" + this.generateId();
        }
        this.resultType = this.asAtt == null ? SequenceType.ANY_SEQUENCE : this.makeSequenceType(this.asAtt);
        this.functionName = this.nameAtt;
    }

    private String generateId() {
        FastStringBuffer buff = new FastStringBuffer(16);
        this.generateId(buff);
        return buff.toString();
    }

    public StructuredQName getObjectName() {
        StructuredQName qn = super.getObjectName();
        if (qn == null) {
            this.nameAtt = Whitespace.trim(this.getAttributeValue("", "name"));
            if (this.nameAtt == null) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            try {
                qn = this.makeQName(this.nameAtt);
                this.setObjectName(qn);
            }
            catch (NamespaceException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
            catch (XPathException err) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "badly-named-function" + this.generateId());
            }
        }
        return qn;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam(String attName) {
        return !"required".equals(attName);
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLLocalParam;
    }

    public boolean isOverriding() {
        if (this.overrideAtt == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.override;
    }

    protected void index(Declaration decl, PrincipalStylesheetModule top) throws XPathException {
        top.indexFunction(decl);
    }

    public void fixupReferences() throws XPathException {
        for (UserFunctionReference reference : this.references) {
            if (!(reference instanceof UserFunctionCall)) continue;
            ((UserFunctionCall)reference).setStaticType(this.resultType);
        }
        super.fixupReferences();
    }

    public void validate(Declaration decl) throws XPathException {
        this.stackFrameMap = this.getConfiguration().makeSlotManager();
        this.checkTopLevel("XTSE0010");
        this.getNumberOfArguments();
    }

    public void compileDeclaration(Executable exec, Declaration decl) throws XPathException {
        this.compileAsExpression(exec, decl);
    }

    private void compileAsExpression(Executable exec, Declaration decl) throws XPathException {
        Expression exp = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), false);
        if (exp == null) {
            exp = Literal.makeEmptySequence();
        } else {
            ExpressionVisitor visitor = this.makeExpressionVisitor();
            exp = exp.simplify(visitor);
        }
        if (exec.getConfiguration().isCompileWithTracing()) {
            TraceExpression trace = new TraceExpression(exp);
            trace.setConstructType(155);
            trace.setNamespaceResolver(this.getNamespaceResolver());
            trace.setObjectName(this.getObjectName());
            exp = trace;
        }
        UserFunction fn = exec.getConfiguration().newUserFunction(this.memoFunction);
        fn.setHostLanguage(50);
        fn.setBody(exp);
        fn.setFunctionName(this.getObjectName());
        this.setParameterDefinitions(fn);
        fn.setResultType(this.getResultType());
        fn.setLineNumber(this.getLineNumber());
        fn.setSystemId(this.getSystemId());
        fn.setStackFrameMap(this.stackFrameMap);
        fn.setExecutable(exec);
        this.compiledFunction = fn;
        this.fixupInstruction(fn);
        if (this.memoFunction && !fn.isMemoFunction()) {
            this.compileWarning("Memo functions are not available in Saxon-HE: saxon:memo-function attribute ignored", "SXWN9011");
        }
    }

    public void typeCheckBody() throws XPathException {
        Expression exp = this.compiledFunction.getBody();
        ExpressionTool.resetPropertiesWithinSubtree(exp);
        Expression exp2 = exp;
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        try {
            exp2 = visitor.typeCheck(exp, null);
            if (this.resultType != null) {
                RoleLocator role = new RoleLocator(5, this.functionName, 0);
                role.setErrorCode("XTTE0780");
                exp2 = TypeChecker.staticTypeCheck(exp2, this.resultType, false, role, visitor);
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            this.compileError(err);
        }
        if (exp2 != exp) {
            this.compiledFunction.setBody(exp2);
        }
    }

    public void optimize(Declaration declaration) throws XPathException {
        int tailCalls;
        Expression exp3;
        Expression exp = this.compiledFunction.getBody();
        ExpressionTool.resetPropertiesWithinSubtree(exp);
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        Expression exp2 = exp;
        Optimizer opt = this.getConfiguration().obtainOptimizer();
        try {
            if (opt.getOptimizationLevel() != 0) {
                exp2 = exp.optimize(visitor, null);
            }
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            this.compileError(err);
        }
        if (opt.getOptimizationLevel() != 0 && (exp3 = opt.promoteExpressionsToGlobal(exp2, visitor)) != null) {
            exp2 = visitor.optimize(exp3, null);
        }
        exp2 = XSLFunction.makeTraceInstruction(this, exp2);
        this.allocateSlots(exp2);
        if (exp2 != exp) {
            this.compiledFunction.setBody(exp2);
        }
        if ((tailCalls = ExpressionTool.markTailFunctionCalls(exp2, this.getObjectName(), this.getNumberOfArguments())) != 0) {
            this.compiledFunction.setTailRecursive(tailCalls > 0, tailCalls > 1);
            this.compiledFunction.setBody(new TailCallLoop(this.compiledFunction));
        }
        if (this.getConfiguration().isGenerateByteCode(50)) {
            try {
                Expression cbody = opt.compileToByteCode(this.compiledFunction.getBody(), this.nameAtt, 6);
                if (cbody != null) {
                    this.compiledFunction.setBody(cbody);
                }
            }
            catch (Exception e) {
                System.err.println("Failed while compiling function " + this.nameAtt);
                e.printStackTrace();
                throw new XPathException(e);
            }
        }
        this.compiledFunction.computeEvaluationMode();
        if (this.isExplaining()) {
            exp2.explain(this.getConfiguration().getStandardErrorOutput());
        }
    }

    private void fixupInstruction(UserFunction compiledFunction) throws XPathException {
        ExpressionVisitor visitor = this.makeExpressionVisitor();
        try {
            for (UserFunctionReference reference : this.references) {
                reference.setFunction(compiledFunction);
                if (!(reference instanceof UserFunctionCall)) continue;
                UserFunctionCall call = (UserFunctionCall)reference;
                call.checkFunctionCall(compiledFunction, visitor);
                call.computeArgumentEvaluationModes();
            }
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public SlotManager getSlotManager() {
        return this.stackFrameMap;
    }

    public SequenceType getResultType() {
        String asAtt;
        if (this.resultType == null && (asAtt = this.getAttributeValue("", "as")) != null) {
            try {
                this.resultType = this.makeSequenceType(asAtt);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return this.resultType == null ? SequenceType.ANY_SEQUENCE : this.resultType;
    }

    public int getNumberOfArguments() {
        if (this.numberOfArguments == -1) {
            Object child;
            this.numberOfArguments = 0;
            AxisIterator kids = this.iterateAxis((byte)3);
            while ((child = kids.next()) instanceof XSLLocalParam) {
                ++this.numberOfArguments;
            }
            return this.numberOfArguments;
        }
        return this.numberOfArguments;
    }

    public void setParameterDefinitions(UserFunction fn) {
        UserFunctionParameter[] params = new UserFunctionParameter[this.getNumberOfArguments()];
        fn.setParameterDefinitions(params);
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        Object node;
        while ((node = kids.next()) != null) {
            if (!(node instanceof XSLLocalParam)) continue;
            UserFunctionParameter param = new UserFunctionParameter();
            params[count++] = param;
            param.setRequiredType(((XSLLocalParam)node).getRequiredType());
            param.setVariableQName(((XSLLocalParam)node).getVariableQName());
            param.setSlotNumber(((XSLLocalParam)node).getSlotNumber());
            ((XSLLocalParam)node).getSourceBinding().fixupBinding(param);
            int refs = ExpressionTool.getReferenceCount(fn.getBody(), param, false);
            param.setReferenceCount(refs);
        }
        return;
    }

    public SequenceType[] getArgumentTypes() {
        SequenceType[] types = new SequenceType[this.getNumberOfArguments()];
        int count = 0;
        AxisIterator kids = this.iterateAxis((byte)3);
        Object node;
        while ((node = kids.next()) != null) {
            if (!(node instanceof XSLLocalParam)) continue;
            types[count++] = ((XSLLocalParam)node).getRequiredType();
        }
        return types;
    }

    public UserFunction getCompiledFunction() {
        return this.compiledFunction;
    }

    public int getConstructType() {
        return 155;
    }
}

