/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import com.saxonica.xqj.pull.TreeWalker;
import java.util.List;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PullFromIterator
implements PullProvider {
    private FocusIterator base;
    private PullProvider treeWalker = null;
    private PipelineConfiguration pipe;
    private int currentEvent = 0;

    public PullFromIterator(SequenceIterator base) {
        this.base = base instanceof FocusIterator ? (FocusIterator)base : new FocusTrackingIterator(base);
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    @Override
    public int next() throws XPathException {
        if (this.treeWalker == null) {
            Item item = this.base.next();
            if (item == null) {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            if (item instanceof AtomicValue) {
                this.currentEvent = 1;
                return this.currentEvent;
            }
            switch (((NodeInfo)item).getNodeKind()) {
                case 3: {
                    this.currentEvent = 8;
                    return this.currentEvent;
                }
                case 8: {
                    this.currentEvent = 9;
                    return this.currentEvent;
                }
                case 7: {
                    this.currentEvent = 10;
                    return this.currentEvent;
                }
                case 2: {
                    this.currentEvent = 6;
                    return this.currentEvent;
                }
                case 13: {
                    this.currentEvent = 7;
                    return this.currentEvent;
                }
                case 1: 
                case 9: {
                    this.treeWalker = TreeWalker.makeTreeWalker((NodeInfo)item);
                    this.treeWalker.setPipelineConfiguration(this.pipe);
                    this.currentEvent = this.treeWalker.next();
                    return this.currentEvent;
                }
            }
            throw new IllegalStateException();
        }
        int event = this.treeWalker.next();
        if (event == -1) {
            this.treeWalker = null;
            this.currentEvent = this.next();
        } else {
            this.currentEvent = event;
        }
        return this.currentEvent;
    }

    @Override
    public int current() {
        return this.currentEvent;
    }

    @Override
    public AttributeCollection getAttributes() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getAttributes();
        }
        throw new IllegalStateException();
    }

    @Override
    public NamespaceBinding[] getNamespaceDeclarations() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getNamespaceDeclarations();
        }
        throw new IllegalStateException();
    }

    @Override
    public int skipToMatchingEnd() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.skipToMatchingEnd();
        }
        throw new IllegalStateException();
    }

    @Override
    public void close() {
        if (this.treeWalker != null) {
            this.treeWalker.close();
        }
    }

    @Override
    public NodeName getNodeName() {
        if (this.treeWalker != null) {
            return this.treeWalker.getNodeName();
        }
        Item item = this.base.current();
        if (item instanceof NodeInfo) {
            return NameOfNode.makeName((NodeInfo)item);
        }
        throw new IllegalStateException();
    }

    @Override
    public CharSequence getStringValue() throws XPathException {
        if (this.treeWalker != null) {
            return this.treeWalker.getStringValue();
        }
        Item item = this.base.current();
        return item.getStringValueCS();
    }

    @Override
    public AtomicValue getAtomicValue() {
        if (this.currentEvent == 1) {
            return (AtomicValue)this.base.current();
        }
        throw new IllegalStateException();
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.treeWalker != null) {
            return this.treeWalker.getSchemaType();
        }
        Item item = this.base.current();
        if (item instanceof NodeInfo) {
            return ((NodeInfo)item).getSchemaType();
        }
        return ((AtomicValue)item).getItemType();
    }

    @Override
    public Location getSourceLocator() {
        if (this.treeWalker != null) {
            return this.treeWalker.getSourceLocator();
        }
        return null;
    }

    @Override
    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

