/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import com.saxonica.xqj.pull.PullFromIterator;
import com.saxonica.xqj.pull.TinyTreeWalker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.UnparsedEntity;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeWalker
implements PullProvider,
Location {
    private NodeInfo startNode;
    private NodeInfo currentNode;
    private int currentEvent;
    private Stack<FocusIterator> iteratorStack = new Stack();
    private PipelineConfiguration pipe;
    private NamespaceBinding[] nsBuffer = new NamespaceBinding[10];

    public static PullProvider makeTreeWalker(NodeInfo startNode) {
        if (startNode instanceof TinyNodeImpl) {
            switch (startNode.getNodeKind()) {
                case 1: 
                case 9: {
                    return new TinyTreeWalker((TinyNodeImpl)startNode);
                }
            }
            return new PullFromIterator(SingletonIterator.makeIterator(startNode));
        }
        return new TreeWalker(startNode);
    }

    private TreeWalker(NodeInfo startNode) {
        this.startNode = startNode;
    }

    @Override
    public void setPipelineConfiguration(PipelineConfiguration pipe) {
        this.pipe = pipe;
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipe;
    }

    @Override
    public int next() throws XPathException {
        switch (this.currentEvent) {
            case 0: {
                this.currentNode = this.startNode;
                switch (this.currentNode.getNodeKind()) {
                    case 9: {
                        this.currentEvent = 2;
                        break;
                    }
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                        break;
                    }
                    case 2: {
                        this.currentEvent = 6;
                        break;
                    }
                    case 13: {
                        this.currentEvent = 7;
                    }
                }
                return this.currentEvent;
            }
            case 2: 
            case 4: {
                FocusTrackingIterator kids = new FocusTrackingIterator(this.currentNode.iterateAxis((byte)3));
                this.iteratorStack.push(kids);
                this.currentNode = (NodeInfo)kids.next();
                if (this.currentNode != null) {
                    switch (this.currentNode.getNodeKind()) {
                        case 1: {
                            this.currentEvent = 4;
                            break;
                        }
                        case 3: {
                            this.currentEvent = 8;
                            break;
                        }
                        case 8: {
                            this.currentEvent = 9;
                            break;
                        }
                        case 7: {
                            this.currentEvent = 10;
                        }
                    }
                    return this.currentEvent;
                }
                this.iteratorStack.pop();
                if (this.iteratorStack.isEmpty()) {
                    this.currentNode = this.startNode;
                }
                this.currentEvent = this.currentEvent == 2 ? 3 : 5;
                return this.currentEvent;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                if (this.iteratorStack.isEmpty()) {
                    if (this.currentNode == this.startNode) {
                        this.currentNode = null;
                        this.currentEvent = -1;
                    } else {
                        this.currentNode = this.startNode;
                        this.currentEvent = this.currentNode.getNodeKind() == 1 ? 5 : 3;
                    }
                    return this.currentEvent;
                }
                FocusIterator siblings = this.iteratorStack.peek();
                this.currentNode = (NodeInfo)siblings.next();
                if (this.currentNode == null) {
                    this.iteratorStack.pop();
                    if (this.iteratorStack.isEmpty()) {
                        this.currentNode = this.startNode;
                        this.currentEvent = this.currentNode.getNodeKind() == 1 ? 5 : 3;
                        return this.currentEvent;
                    }
                    FocusIterator uncles = this.iteratorStack.peek();
                    this.currentNode = (NodeInfo)uncles.current();
                    this.currentEvent = this.currentNode.getNodeKind() == 9 ? 3 : 5;
                    return this.currentEvent;
                }
                switch (this.currentNode.getNodeKind()) {
                    case 1: {
                        this.currentEvent = 4;
                        break;
                    }
                    case 3: {
                        this.currentEvent = 8;
                        break;
                    }
                    case 8: {
                        this.currentEvent = 9;
                        break;
                    }
                    case 7: {
                        this.currentEvent = 10;
                    }
                }
                return this.currentEvent;
            }
            case 3: 
            case 6: 
            case 7: {
                this.currentEvent = -1;
                return this.currentEvent;
            }
            case -1: {
                throw new IllegalStateException("Cannot call next() when input is exhausted");
            }
        }
        throw new IllegalStateException("Unrecognized event " + this.currentEvent);
    }

    @Override
    public int current() {
        return this.currentEvent;
    }

    @Override
    public AttributeCollection getAttributes() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            NodeInfo node;
            AttributeCollectionImpl atts = new AttributeCollectionImpl(this.startNode.getConfiguration());
            AxisIterator iter = this.currentNode.iterateAxis((byte)2);
            while ((node = (NodeInfo)iter.next()) != null) {
                atts.addAttribute(NameOfNode.makeName(node), (SimpleType)node.getSchemaType(), node.getStringValue(), ExplicitLocation.UNKNOWN_LOCATION, 0);
            }
            return atts;
        }
        throw new IllegalStateException("getAttributes() called when current event is not ELEMENT_START");
    }

    @Override
    public NamespaceBinding[] getNamespaceDeclarations() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            if (this.iteratorStack.isEmpty()) {
                Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(this.currentNode);
                ArrayList<NamespaceBinding> list = new ArrayList<NamespaceBinding>();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
                return list.toArray(new NamespaceBinding[list.size()]);
            }
            return this.currentNode.getDeclaredNamespaces(this.nsBuffer);
        }
        throw new IllegalStateException("getNamespaceDeclarations() called when current event is not ELEMENT_START");
    }

    @Override
    public int skipToMatchingEnd() throws XPathException {
        switch (this.currentEvent) {
            case 2: {
                this.currentEvent = 3;
                return this.currentEvent;
            }
            case 4: {
                this.currentEvent = 5;
                return this.currentEvent;
            }
        }
        throw new IllegalStateException("Cannot call skipToMatchingEnd() except when at start of element or document");
    }

    @Override
    public void close() {
    }

    public NamePool getNamePool() {
        return this.pipe.getConfiguration().getNamePool();
    }

    @Override
    public NodeName getNodeName() {
        return NameOfNode.makeName(this.currentNode);
    }

    @Override
    public CharSequence getStringValue() throws XPathException {
        if (this.currentNode.getNodeKind() == 1) {
            this.skipToMatchingEnd();
        }
        return this.currentNode.getStringValueCS();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.currentNode.getSchemaType();
    }

    @Override
    public AtomicValue getAtomicValue() {
        throw new IllegalStateException();
    }

    @Override
    public Location getSourceLocator() {
        return this;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return this.currentNode.getSystemId();
    }

    @Override
    public int getLineNumber() {
        return this.currentNode.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public Location saveLocation() {
        return new ExplicitLocation(this);
    }

    @Override
    public List<UnparsedEntity> getUnparsedEntities() {
        return null;
    }
}

