/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash.impl;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.SequenceType;
import com.xmlcalabash.runtime.XPipeline;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.daisy.common.properties.Properties;
import org.daisy.common.saxon.SaxonHelper;
import org.daisy.common.saxon.SaxonInputValue;
import org.daisy.common.xproc.XProcError;
import org.daisy.common.xproc.XProcErrorException;
import org.daisy.common.xproc.XProcInput;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.XProcOptionInfo;
import org.daisy.common.xproc.XProcPipeline;
import org.daisy.common.xproc.XProcPipelineInfo;
import org.daisy.common.xproc.XProcPortInfo;
import org.daisy.common.xproc.XProcResult;
import org.daisy.common.xproc.calabash.CalabashXProcError;
import org.daisy.common.xproc.calabash.XProcConfigurationFactory;
import org.daisy.common.xproc.calabash.impl.CalabashXProcResult;
import org.daisy.common.xproc.calabash.impl.MessageListenerImpl;
import org.daisy.common.xproc.calabash.impl.XProcMessageListenerAggregator;
import org.daisy.common.xproc.calabash.impl.slf4jXProcMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CalabashXProcPipeline
implements XProcPipeline {
    private static final Logger logger = LoggerFactory.getLogger(CalabashXProcPipeline.class);
    private final URI uri;
    private final XProcConfigurationFactory configFactory;
    private final URIResolver uriResolver;
    private final EntityResolver entityResolver;
    private final boolean AUTO_NAME_STEPS = Boolean.parseBoolean(Properties.getProperty((String)"org.daisy.pipeline.calabash.autonamesteps", (String)"false"));
    private final Supplier<XProcPipelineInfo> info = Suppliers.memoize((Supplier)new Supplier<XProcPipelineInfo>(){

        public XProcPipelineInfo get() {
            XProcPipelineInfo.Builder builder = new XProcPipelineInfo.Builder();
            builder.withURI(CalabashXProcPipeline.this.uri);
            PipelineInstance pipeline = PipelineInstance.newInstance(CalabashXProcPipeline.this.uri, CalabashXProcPipeline.this.configFactory.newConfiguration(null, null), CalabashXProcPipeline.this.uriResolver, CalabashXProcPipeline.this.entityResolver);
            DeclareStep declaration = pipeline.xpipe.getDeclareStep();
            for (Input input : declaration.inputs()) {
                if (!input.getParameterInput()) {
                    builder.withPort(XProcPortInfo.newInputPort((String)input.getPort(), (boolean)input.getSequence(), (boolean)input.getBinding().isEmpty(), (boolean)input.getPrimary()));
                    continue;
                }
                builder.withPort(XProcPortInfo.newParameterPort((String)input.getPort(), (boolean)input.getPrimary()));
            }
            for (Output output : declaration.outputs()) {
                builder.withPort(XProcPortInfo.newOutputPort((String)output.getPort(), (boolean)output.getSequence(), (boolean)output.getPrimary()));
            }
            for (Option option : declaration.options()) {
                SequenceType sequenceType = option.getSequenceType();
                if (sequenceType == null) {
                    sequenceType = SequenceType.XS_STRING;
                }
                builder.withOption((XProcOptionInfo)new CalabashXProcOptionInfo(option, sequenceType));
            }
            pipeline.runtime.close();
            return builder.build();
        }
    });

    public CalabashXProcPipeline(URI uri, XProcConfigurationFactory configFactory, URIResolver uriResolver, EntityResolver entityResolver) {
        this.uri = uri;
        this.configFactory = configFactory;
        this.uriResolver = uriResolver;
        this.entityResolver = entityResolver;
    }

    public XProcPipelineInfo getInfo() {
        return (XProcPipelineInfo)this.info.get();
    }

    public XProcResult run(XProcInput data) throws XProcErrorException {
        return this.run(data, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XProcResult run(XProcInput data, XProcMonitor monitor, Map<String, String> properties) throws XProcErrorException {
        MessageListenerImpl messageListener = monitor != null ? new MessageListenerImpl(monitor.getMessageAppender(), this.AUTO_NAME_STEPS) : null;
        try {
            PipelineInstance pipeline = PipelineInstance.newInstance(this.uri, this.configFactory.newConfiguration(monitor, properties), this.uriResolver, this.entityResolver);
            if (messageListener != null) {
                ((XProcMessageListenerAggregator)pipeline.xpipe.getStep().getXProc().getMessageListener()).add(messageListener);
            }
            for (String name : pipeline.xpipe.getInputs()) {
                boolean cleared = false;
                for (Supplier sourceProvider : data.getInputs(name)) {
                    XMLReader reader;
                    Source source = (Source)sourceProvider.get();
                    if (source instanceof SAXSource && (reader = ((SAXSource)source).getXMLReader()) == null) {
                        try {
                            reader = XMLReaderFactory.createXMLReader();
                            ((SAXSource)source).setXMLReader(reader);
                            reader.setEntityResolver(this.entityResolver);
                        }
                        catch (SAXException sAXException) {
                            // empty catch block
                        }
                    }
                    if (!cleared) {
                        pipeline.xpipe.clearInputs(name);
                    }
                    pipeline.xpipe.writeTo(name, CalabashXProcPipeline.asXdmNode(pipeline.config.getProcessor(), source));
                }
            }
            for (QName optname : data.getOptions().keySet()) {
                RuntimeValue value;
                XProcOptionInfo optionInfo = ((XProcPipelineInfo)this.info.get()).getOption(optname);
                if (optionInfo == null) continue;
                if (pipeline.runtime.getAllowGeneralExpressions()) {
                    XdmValue xdmValue = ((CalabashXProcOptionInfo)optionInfo).sequenceType.cast(SaxonHelper.xdmValueFromObject(data.getOptions().get(optname)), null);
                    String stringValue = StreamSupport.stream(xdmValue.spliterator(), false).map(item -> {
                        try {
                            return item.getStringValue();
                        }
                        catch (UnsupportedOperationException e) {
                            return "";
                        }
                    }).collect(Collectors.joining(""));
                    value = new RuntimeValue(stringValue, xdmValue, null, null);
                } else {
                    Object val = data.getOptions().get(optname);
                    try {
                        value = new RuntimeValue((String)val);
                    }
                    catch (ClassCastException e) {
                        throw new RuntimeException("Expected string value for option " + optname + " but got: " + val.getClass());
                    }
                }
                pipeline.xpipe.passOption(new net.sf.saxon.s9api.QName(optname), value);
            }
            for (String port : ((XProcPipelineInfo)this.info.get()).getParameterPorts()) {
                for (QName name : data.getParameters(port).keySet()) {
                    RuntimeValue value = new RuntimeValue((String)data.getParameters(port).get(name), null, null);
                    pipeline.xpipe.setParameter(port, new net.sf.saxon.s9api.QName(name), value);
                }
            }
            try {
                pipeline.xpipe.run();
                for (String port : pipeline.xpipe.getOutputs()) {
                    pipeline.xpipe.readFrom(port).moreDocuments();
                }
            }
            catch (XProcException e) {
                List errors = pipeline.xpipe.errors();
                for (int i = 0; i < errors.size() - 1; ++i) {
                    try {
                        XProcError err = XProcError.parse((XMLStreamReader)new SaxonInputValue(((XdmNode)errors.get(i)).getUnderlyingNode()).asXMLStreamReader());
                        logger.error(err.toString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                XProcError err = CalabashXProcError.from(e);
                throw new XProcErrorException(err, (Throwable)e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            catch (OutOfMemoryError e) {
                throw new RuntimeException(e);
            }
            finally {
                pipeline.runtime.close();
            }
            Iterator<Object> iterator = CalabashXProcResult.newInstance(pipeline.xpipe, pipeline.config);
            return iterator;
        }
        finally {
            if (messageListener != null) {
                messageListener.clean();
            }
        }
    }

    private static XdmNode asXdmNode(Processor processor, Source source) {
        DocumentBuilder builder = processor.newDocumentBuilder();
        builder.setDTDValidation(false);
        builder.setLineNumbering(true);
        try {
            return builder.build(source);
        }
        catch (SaxonApiException sae) {
            throw new RuntimeException(sae.getMessage(), sae);
        }
    }

    private static final class PipelineInstance {
        private final XPipeline xpipe;
        private final XProcConfiguration config;
        private final XProcRuntime runtime;

        private PipelineInstance(XPipeline xpipe, XProcConfiguration config, XProcRuntime runtime) {
            this.xpipe = xpipe;
            this.config = config;
            this.runtime = runtime;
        }

        private static PipelineInstance newInstance(URI uri, XProcConfiguration config, URIResolver uriResolver, EntityResolver entityResolver) {
            XProcRuntime runtime = new XProcRuntime(config);
            runtime.setMessageListener((XProcMessageListener)new slf4jXProcMessageListener());
            if (uriResolver != null) {
                runtime.setURIResolver(uriResolver);
            }
            if (entityResolver != null) {
                runtime.setEntityResolver(entityResolver);
            }
            XProcMessageListenerAggregator listeners = new XProcMessageListenerAggregator();
            listeners.add(new slf4jXProcMessageListener());
            runtime.setMessageListener((XProcMessageListener)listeners);
            XPipeline xpipe = null;
            try {
                xpipe = runtime.load(new com.xmlcalabash.util.Input(uri.toString()));
            }
            catch (SaxonApiException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return new PipelineInstance(xpipe, config, runtime);
        }
    }

    private static class CalabashXProcOptionInfo
    extends XProcOptionInfo {
        public final SequenceType sequenceType;

        public CalabashXProcOptionInfo(Option option, SequenceType sequenceType) {
            super(new QName(option.getName().getNamespaceURI(), option.getName().getLocalName(), option.getName().getPrefix()), sequenceType.toString(), option.getRequired(), option.getSelect());
            this.sequenceType = sequenceType;
        }
    }
}

