/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash.impl;

import com.google.common.base.Supplier;
import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.runtime.XPipeline;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.daisy.common.xproc.XProcOutput;
import org.daisy.common.xproc.XProcResult;
import org.daisy.common.xproc.calabash.impl.SerializationUtils;

public final class CalabashXProcResult
implements XProcResult {
    private final XPipeline xpipeline;
    private final XProcConfiguration configuration;

    static XProcResult newInstance(XPipeline xpipeline, XProcConfiguration configuration) {
        return new CalabashXProcResult(xpipeline, configuration);
    }

    private CalabashXProcResult(XPipeline xpipeline, XProcConfiguration configuration) {
        this.xpipeline = xpipeline;
        this.configuration = configuration;
    }

    public void writeTo(XProcOutput output) {
        if (this.xpipeline.getOutputs() != null) {
            block11: for (String port : this.xpipeline.getOutputs()) {
                Supplier resultProvider = output.getResultProvider(port);
                ReadablePipe rpipe = this.xpipeline.readFrom(port);
                while (true) {
                    XdmNode node;
                    try {
                        if (!rpipe.moreDocuments()) {
                            continue block11;
                        }
                    }
                    catch (SaxonApiException e) {
                        throw new RuntimeException(e);
                    }
                    Serializer serializer = SerializationUtils.newSerializer(this.xpipeline.getSerialization(port), this.configuration);
                    Result result = (Result)resultProvider.get();
                    if (result instanceof StreamResult) {
                        StreamResult streamResult = (StreamResult)result;
                        OutputStream os = streamResult.getOutputStream();
                        if (os != null) {
                            serializer.setOutputStream(os);
                        } else {
                            Writer w = streamResult.getWriter();
                            if (w != null) {
                                serializer.setOutputWriter(w);
                            }
                        }
                    } else {
                        URI uri = null;
                        try {
                            uri = new URI(result.getSystemId());
                        }
                        catch (URISyntaxException e) {
                            throw new RuntimeException(String.format("Malformed uri while writing results: %s", result.getSystemId()), e);
                        }
                        if ("file".equals(uri.getScheme())) {
                            serializer.setOutputFile(new File(uri));
                        } else {
                            try {
                                URL url = uri.toURL();
                                URLConnection conn = url.openConnection();
                                conn.setDoOutput(true);
                                serializer.setOutputStream(conn.getOutputStream());
                            }
                            catch (MalformedURLException e) {
                                throw new RuntimeException(String.format("Malformed url while writing results: %s", uri), e);
                            }
                            catch (IOException e) {
                                throw new RuntimeException("IOError caught when writing results", e);
                            }
                        }
                    }
                    try {
                        node = rpipe.read();
                    }
                    catch (SaxonApiException e) {
                        throw new RuntimeException(e);
                    }
                    try {
                        serializer.serializeNode(node);
                    }
                    catch (SaxonApiException e) {
                        throw new RuntimeException("Error caught when writing results", e);
                    }
                }
            }
        }
    }
}

