/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Map;
import org.daisy.common.file.URLs;
import org.daisy.common.xproc.calabash.ConfigurationFileProvider;

public class BundledConfigurationFileProvider
implements ConfigurationFileProvider {
    private static final String PATH = "path";
    private URL configFile = null;
    private String name = null;

    protected void activate(Map<?, ?> properties, Class<?> context) {
        this.name = properties.get("component.name").toString();
        String path = properties.get(PATH).toString();
        if (path == null) {
            path = "/config-calabash.xml";
        }
        this.configFile = URLs.getResourceFromJAR((String)path, context);
        if (this.configFile == null) {
            throw new IllegalArgumentException("Calabash configuration file at location " + path + " could not be found");
        }
    }

    @Override
    public InputStream get() {
        if (this.configFile == null) {
            throw new IllegalStateException();
        }
        try {
            return this.configFile.openStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return this.name;
    }
}

