/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash;

import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Step;
import java.util.function.Consumer;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.daisy.common.saxon.SaxonOutputValue;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.transform.OutputValue;
import org.daisy.common.transform.TransformerException;

public class XMLCalabashOutputValue
extends SaxonOutputValue {
    private final WritablePipe pipe;

    public XMLCalabashOutputValue(WritablePipe value, XProcRuntime runtime) {
        super(XMLCalabashOutputValue.itemConsumer(arg_0 -> ((WritablePipe)value).write(arg_0)), runtime.getProcessor().getUnderlyingConfiguration());
        this.pipe = value;
    }

    public XMLCalabashOutputValue(SaxonOutputValue value) {
        super(value);
        this.pipe = XMLCalabashOutputValue.createWritablePipe(value.asXdmItemConsumer());
    }

    public static XMLCalabashOutputValue of(OutputValue<?> value) throws IllegalArgumentException {
        if (value instanceof XMLCalabashOutputValue) {
            return (XMLCalabashOutputValue)value;
        }
        if (value instanceof SaxonOutputValue) {
            return new XMLCalabashOutputValue((SaxonOutputValue)value);
        }
        throw new IllegalArgumentException("can not create XMLCalabashOutputValue from " + value);
    }

    public WritablePipe asWritablePipe() {
        return this.pipe;
    }

    public Consumer<XdmItem> asXdmItemConsumer() {
        return super.asXdmItemConsumer();
    }

    public void writeXMLStream(final Consumer<BaseURIAwareXMLStreamWriter> lazyStream) throws UnsupportedOperationException {
        final BaseURIAwareXMLStreamWriter writer = this.asXMLStreamWriter();
        ((Pipe)this.pipe).onRead(new XProcRunnable(){
            private boolean done = false;

            public void run() throws SaxonApiException {
                if (!this.done) {
                    try {
                        lazyStream.accept(writer);
                    }
                    catch (TransformerException e) {
                        throw new SaxonApiException((Throwable)e);
                    }
                    finally {
                        this.done = true;
                    }
                }
            }
        });
    }

    private static WritablePipe createWritablePipe(final Consumer<XdmItem> consumer) {
        return new WritablePipe(){
            private boolean written = false;

            public void canWriteSequence(boolean sequence) {
                throw new UnsupportedOperationException();
            }

            public boolean writeSequence() {
                return true;
            }

            public void write(XdmNode node) {
                consumer.accept(node);
                this.written = true;
            }

            public void setWriter(Step step) {
            }

            public void resetWriter() {
                if (this.written) {
                    throw new UnsupportedOperationException("Already written");
                }
            }

            public void close() {
            }
        };
    }

    private static Consumer<XdmItem> itemConsumer(Consumer<XdmNode> nodeConsumer) {
        return item -> {
            if (!(item instanceof XdmNode)) {
                throw new TransformerException((Throwable)new IllegalArgumentException("expected a node"));
            }
            nodeConsumer.accept((XdmNode)item);
        };
    }
}

