/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash.impl;

import java.net.URI;
import javax.xml.transform.URIResolver;
import org.daisy.common.xproc.XProcEngine;
import org.daisy.common.xproc.XProcErrorException;
import org.daisy.common.xproc.XProcInput;
import org.daisy.common.xproc.XProcPipeline;
import org.daisy.common.xproc.XProcPipelineInfo;
import org.daisy.common.xproc.XProcResult;
import org.daisy.common.xproc.calabash.XProcConfigurationFactory;
import org.daisy.common.xproc.calabash.impl.CalabashXProcPipeline;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

@Component(name="calabash-xproc-engine", service={XProcEngine.class})
public class CalabashXProcEngine
implements XProcEngine {
    private static final Logger logger = LoggerFactory.getLogger(CalabashXProcEngine.class);
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private XProcConfigurationFactory configFactory = null;

    @Activate
    public void activate() {
        logger.trace("Activating XProc Engine");
    }

    public XProcPipeline load(URI uri) {
        if (this.configFactory == null) {
            throw new IllegalStateException("Calabash configuration factory unavailable");
        }
        return new CalabashXProcPipeline(uri, this.configFactory, this.uriResolver, this.entityResolver);
    }

    public XProcPipelineInfo getInfo(URI uri) {
        return this.load(uri).getInfo();
    }

    public XProcResult run(URI uri, XProcInput data) throws XProcErrorException {
        return this.load(uri).run(data);
    }

    @Reference(name="calabash-config-factory", unbind="-", service=XProcConfigurationFactory.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setConfigurationFactory(XProcConfigurationFactory configFactory) {
        this.configFactory = configFactory;
    }

    @Reference(name="entity-resolver", unbind="-", service=EntityResolver.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    @Reference(name="uri-resolver", unbind="-", service=URIResolver.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setUriResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }
}

