/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash.impl;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.runtime.XAtomicStep;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.daisy.common.saxon.SaxonConfigurator;
import org.daisy.common.xproc.XProcMonitor;
import org.daisy.common.xproc.calabash.ConfigurationFileProvider;
import org.daisy.common.xproc.calabash.XProcConfigurationFactory;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.common.xproc.calabash.XProcStepRegistry;
import org.daisy.common.xproc.calabash.impl.DynamicXProcConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Component(name="calabash-config-factory", service={XProcConfigurationFactory.class, XProcStepRegistry.class})
public class DynamicXProcConfigurationFactory
implements XProcConfigurationFactory,
XProcStepRegistry {
    private static final Logger logger = LoggerFactory.getLogger(DynamicXProcConfigurationFactory.class);
    private final Map<QName, XProcStepProvider> stepProviders = new HashMap<QName, XProcStepProvider>();
    private SaxonConfigurator saxonConfigurator = null;
    private final List<ConfigurationFileProvider> configurationFiles = new ArrayList<ConfigurationFileProvider>();

    @Override
    public XProcConfiguration newConfiguration(XProcMonitor monitor, Map<String, String> properties) {
        System.setProperty("com.xmlcalabash.config.user", "");
        Processor processor = new Processor(false);
        this.saxonConfigurator.configure(processor);
        DynamicXProcConfiguration config = new DynamicXProcConfiguration(processor, this, monitor, properties);
        for (ConfigurationFileProvider f : this.configurationFiles) {
            logger.debug("Reading {}", (Object)f);
            this.loadConfigurationFile(config, (InputStream)f.get());
        }
        return config;
    }

    @Activate
    public void activate() {
        logger.trace("Activating XProc Configuration Factory");
    }

    @Reference(name="XProcStepProvider", unbind="-", service=XProcStepProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addStep(XProcStepProvider stepProvider, Map<?, ?> properties) {
        QName type = QName.fromClarkName((String)((String)properties.get("type")));
        logger.debug("Adding step to registry: {}", (Object)type.toString());
        this.stepProviders.put(type, stepProvider);
    }

    public void removeStep(XProcStepProvider stepProvider, Map<?, ?> properties) {
        QName type = QName.fromClarkName((String)((String)properties.get("type")));
        logger.debug("Removing step from registry: {}", (Object)type.toString());
        this.stepProviders.remove(type);
    }

    @Reference(name="ConfigurationFileProvider", unbind="-", service=ConfigurationFileProvider.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addConfigurationFile(ConfigurationFileProvider provider) {
        logger.debug("Adding " + provider);
        this.configurationFiles.add(provider);
    }

    public void removeConfigurationFile(ConfigurationFileProvider provider) {
        logger.debug("Removing " + provider);
        this.configurationFiles.remove(provider);
    }

    @Override
    public boolean hasStep(QName type) {
        return this.stepProviders.containsKey(type);
    }

    @Override
    public XProcStep newStep(QName type, XProcRuntime runtime, XAtomicStep step, XProcMonitor monitor, Map<String, String> properties) {
        XProcStepProvider stepProvider = this.stepProviders.get(type);
        return stepProvider != null ? stepProvider.newStep(runtime, step, monitor, properties) : null;
    }

    private void loadConfigurationFile(XProcConfiguration conf, InputStream config) {
        XdmNode doc;
        SAXSource source = new SAXSource(new InputSource(config));
        DocumentBuilder builder = conf.getProcessor().newDocumentBuilder();
        try {
            doc = builder.build((Source)source);
        }
        catch (SaxonApiException e) {
            logger.error("Error loading configuration file", (Throwable)e);
            throw new RuntimeException("error loading configuration file", e);
        }
        conf.parse(doc);
    }

    @Reference(name="SaxonConfigurator", unbind="-", service=SaxonConfigurator.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setSaxonConfigurator(SaxonConfigurator configurator) {
        logger.debug("Setting Saxon configurator");
        this.saxonConfigurator = configurator;
    }
}

