/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import com.xmlcalabash.runtime.XStep;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.Deque;
import net.sf.saxon.s9api.XdmNode;
import org.daisy.common.messaging.Message;
import org.daisy.common.messaging.MessageAppender;
import org.daisy.common.messaging.MessageBuilder;
import org.daisy.common.xproc.calabash.impl.XprocMessageHelper;

public class MessageListenerImpl
implements XProcMessageListener {
    private final boolean autoNameSteps;
    private final MessageAppender rootAppender;
    private final Deque<MessageAppender> messageStack = new ArrayDeque<MessageAppender>();

    public MessageListenerImpl(MessageAppender rootAppender, boolean autoNameSteps) {
        this.rootAppender = rootAppender;
        this.autoNameSteps = autoNameSteps;
    }

    private MessageAppender append(MessageBuilder builder, boolean close) {
        MessageAppender current = this.messageStack.isEmpty() ? this.rootAppender : this.messageStack.peek();
        current = current.append(builder);
        if (!close) {
            this.messageStack.push(current);
        } else {
            current.close();
        }
        return current;
    }

    public void error(Throwable exception) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.ERROR);
        XprocMessageHelper.errorMessage(exception, builder);
        this.append(builder, true);
    }

    public void error(XProcRunnable step, XProcException error) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.ERROR);
        builder = XprocMessageHelper.message(step, error.getLocation()[0], error.getMessage(), builder);
        this.append(builder, true);
    }

    public void fine(XProcRunnable step, XdmNode location, String message) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.DEBUG);
        builder = XprocMessageHelper.message(step, location, message, builder);
        this.append(builder, true);
    }

    public void finer(XProcRunnable step, XdmNode location, String message) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.TRACE);
        builder = XprocMessageHelper.message(step, location, message, builder);
        this.append(builder, true);
    }

    public void finest(XProcRunnable step, XdmNode location, String message) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.TRACE);
        builder = XprocMessageHelper.message(step, location, message, builder);
        this.append(builder, true);
    }

    public void info(XProcRunnable step, XdmNode location, String message) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.INFO);
        builder = XprocMessageHelper.message(step, location, message, builder);
        this.append(builder, true);
    }

    public void warning(XProcRunnable step, XdmNode location, String message) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.WARNING);
        builder = XprocMessageHelper.message(step, location, message, builder);
        this.append(builder, true);
    }

    public void warning(Throwable exception) {
        MessageBuilder builder = new MessageBuilder().withLevel(Message.Level.WARNING);
        XprocMessageHelper.errorMessage(exception, builder);
        this.append(builder, true);
    }

    public void openStep(XProcRunnable step, XdmNode location, String message, String level, BigDecimal portion) {
        MessageBuilder builder = new MessageBuilder().withProgress(portion);
        if (message == null && this.autoNameSteps && portion != null && portion.compareTo(BigDecimal.ZERO) > 0) {
            if (step instanceof XStep) {
                message = ((XStep)step).getStep().getName();
            }
            if (level == null) {
                level = "DEBUG";
            }
        }
        if (level == null || level.equals("INFO")) {
            builder.withLevel(Message.Level.INFO);
        } else if (level.equals("ERROR")) {
            builder.withLevel(Message.Level.ERROR);
        } else if (level.equals("WARN")) {
            builder.withLevel(Message.Level.WARNING);
        } else if (level.equals("DEBUG")) {
            builder.withLevel(Message.Level.DEBUG);
        } else if (level.equals("TRACE")) {
            builder.withLevel(Message.Level.TRACE);
        } else {
            builder.withLevel(Message.Level.DEBUG);
            message = "Message with invalid level '" + level + "': " + message;
        }
        XprocMessageHelper.message(step, location, message, builder);
        this.append(builder, false);
    }

    public void closeStep() {
        if (this.messageStack.isEmpty()) {
            throw new RuntimeException("coding error");
        }
        this.messageStack.pop().close();
    }

    void clean() {
        while (!this.messageStack.isEmpty()) {
            this.messageStack.pop().close();
        }
    }
}

