/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.xproc.calabash.impl;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcMessageListener;
import com.xmlcalabash.core.XProcRunnable;
import java.math.BigDecimal;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import org.daisy.common.xproc.calabash.impl.XprocMessageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class slf4jXProcMessageListener
implements XProcMessageListener {
    private static Logger defaultLogger = LoggerFactory.getLogger((String)"com.xmlcalabash");

    public void error(XProcRunnable step, XProcException error) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.error(XprocMessageHelper.logLine(step, error.getLocation()[0], error.getMessage(), error.getErrorCode()));
    }

    private void error(XProcRunnable step, XdmNode location, String message, QName code) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.error(XprocMessageHelper.logLine(step, location, message, code));
    }

    public void error(Throwable exception) {
        Logger log = defaultLogger;
        log.error(XprocMessageHelper.errorLogline(exception));
    }

    public void warning(XProcRunnable step, XdmNode location, String message) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.warn(XprocMessageHelper.logLine(step, location, message));
    }

    public void info(XProcRunnable step, XdmNode location, String message) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.info(XprocMessageHelper.logLine(step, location, message));
    }

    public void fine(XProcRunnable step, XdmNode location, String message) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.debug(XprocMessageHelper.logLine(step, location, message));
    }

    public void finer(XProcRunnable step, XdmNode location, String message) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.debug(XprocMessageHelper.logLine(step, location, message));
    }

    public void finest(XProcRunnable step, XdmNode location, String message) {
        Logger log = step != null ? LoggerFactory.getLogger(step.getClass()) : defaultLogger;
        log.debug(XprocMessageHelper.logLine(step, location, message));
    }

    public void warning(Throwable exception) {
        Logger log = defaultLogger;
        log.warn(XprocMessageHelper.errorLogline(exception));
    }

    public void openStep(XProcRunnable step, XdmNode location, String message, String level, BigDecimal portion) {
        if (message == null) {
            return;
        }
        if (level == null || level.equals("INFO")) {
            this.info(step, location, message);
        } else if (level.equals("ERROR")) {
            this.error(step, location, message, null);
        } else if (level.equals("WARN")) {
            this.warning(step, location, message);
        } else if (level.equals("DEBUG")) {
            this.fine(step, location, message);
        } else if (level.equals("TRACE")) {
            this.finest(step, location, message);
        } else {
            this.fine(step, location, "Message with invalid level '" + level + "': " + message);
        }
    }

    public void closeStep() {
    }
}

