/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.xmlcatalog;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class XmlCatalog {
    HashMap<String, URI> mPublicMappings = new HashMap();
    HashMap<URI, URI> mSystemIdMappings = new HashMap();
    HashMap<URI, URI> mURIMappings = new HashMap();
    HashMap<URI, URI> mRewriteUris = new HashMap();

    private XmlCatalog(HashMap<String, URI> publicMappings, HashMap<URI, URI> systemIdMappings, HashMap<URI, URI> uriMappMappings, HashMap<URI, URI> rewriteUris) {
        this.mPublicMappings.putAll(publicMappings);
        this.mSystemIdMappings.putAll(systemIdMappings);
        this.mURIMappings.putAll(uriMappMappings);
        this.mRewriteUris.putAll(rewriteUris);
    }

    public Map<URI, URI> getSystemIdMappings() {
        return this.mSystemIdMappings;
    }

    public Map<URI, URI> getUriMappings() {
        return this.mURIMappings;
    }

    public Map<String, URI> getPublicMappings() {
        return this.mPublicMappings;
    }

    public Map<URI, URI> getRewriteUris() {
        return this.mRewriteUris;
    }

    public static class Builder {
        HashMap<String, URI> mPublicMappings = new HashMap();
        HashMap<URI, URI> mSystemIdMappings = new HashMap();
        HashMap<URI, URI> mURIMappings = new HashMap();
        HashMap<URI, URI> mRewriteUris = new HashMap();

        public Builder withPublicMapping(String entity, URI uri) {
            this.mPublicMappings.put(entity, uri);
            return this;
        }

        public Builder withSystemIdMapping(URI sysId, URI uri) {
            this.mSystemIdMappings.put(sysId, uri);
            return this;
        }

        public Builder withUriMapping(URI name, URI uri) {
            this.mURIMappings.put(name, uri);
            return this;
        }

        public Builder withRewriteUri(URI startString, URI rewritePrefix) {
            this.mRewriteUris.put(startString, rewritePrefix);
            return this;
        }

        public XmlCatalog build() {
            return new XmlCatalog(this.mPublicMappings, this.mSystemIdMappings, this.mURIMappings, this.mRewriteUris);
        }
    }
}

