/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.xmlcatalog.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.daisy.common.stax.EventProcessor;
import org.daisy.common.stax.StaxEventHelper;
import org.daisy.pipeline.xmlcatalog.XmlCatalog;
import org.daisy.pipeline.xmlcatalog.XmlCatalogParser;
import org.daisy.pipeline.xmlcatalog.impl.XmlCatalogConstants;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="catalog-parser", service={XmlCatalogParser.class})
public class StaxXmlCatalogParser
implements XmlCatalogParser {
    private static final String HTTP_WWW_OASIS_OPEN_ORG_COMMITTEES_ENTITY_RELEASE_1_0_CATALOG_DTD = "http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd";
    private static final String ORG_DAISY_PIPELINE_XMLCATALOG_RESOURCES_CATALOG_DTD = "org/daisy/pipeline/xmlcatalog/resources/catalog.dtd";
    private static final Logger logger = LoggerFactory.getLogger(StaxXmlCatalogParser.class);
    private XMLInputFactory mFactory;
    private final XMLResolver mResolver = new XMLResolver(){

        @Override
        public Object resolveEntity(String publicId, String systemId, String arg2, String arg3) throws XMLStreamException {
            if (systemId.equals(StaxXmlCatalogParser.HTTP_WWW_OASIS_OPEN_ORG_COMMITTEES_ENTITY_RELEASE_1_0_CATALOG_DTD)) {
                return this.getClass().getClassLoader().getResourceAsStream(StaxXmlCatalogParser.ORG_DAISY_PIPELINE_XMLCATALOG_RESOURCES_CATALOG_DTD);
            }
            return null;
        }
    };

    @Override
    public XmlCatalog parse(URI uri) {
        return new StatefulParser().parse(uri);
    }

    @Reference(name="stax-input-factory", unbind="-", service=XMLInputFactory.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setFactory(XMLInputFactory factory) {
        this.mFactory = factory;
        this.mFactory.setXMLResolver(this.mResolver);
    }

    @Activate
    public void activate() {
        logger.trace("Activating XmlCatalogParser");
    }

    private URI addBase(String uri, URI base) {
        if (base.toString().isEmpty()) {
            return URI.create(uri);
        }
        if (base.toString().charAt(base.toString().length() - 1) == '/') {
            return URI.create(base.toString() + uri);
        }
        return URI.create(base.toString() + "/" + uri);
    }

    private class StatefulParser {
        XmlCatalog.Builder mCatalogBuilder = new XmlCatalog.Builder();
        LinkedList<URI> mBase = new LinkedList();

        private StatefulParser() {
        }

        public XmlCatalog parse(URI uri) {
            if (StaxXmlCatalogParser.this.mFactory == null) {
                throw new IllegalStateException();
            }
            if (uri == null) {
                throw new IllegalArgumentException("Uri is null");
            }
            XMLEventReader reader = null;
            InputStream is = null;
            this.mBase.add(URI.create(""));
            try {
                is = uri.toURL().openStream();
                reader = StaxXmlCatalogParser.this.mFactory.createXMLEventReader(is);
                this.parseCatalog(reader);
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Parsing error: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't access package descriptor: " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new RuntimeException("Error while parsing descriptor: " + e.getMessage(), e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
            return this.mCatalogBuilder.build();
        }

        private void parseCatalog(XMLEventReader reader) throws XMLStreamException {
            Predicate pred = StaxEventHelper.EventPredicates.isStartOrStopElement((QName)XmlCatalogConstants.Elements.E_CATALOG).or(StaxEventHelper.EventPredicates.isStartOrStopElement((QName)XmlCatalogConstants.Elements.E_GROUP)).or(StaxEventHelper.EventPredicates.isStartOrStopElement((QName)XmlCatalogConstants.Elements.E_PUBLIC)).or(StaxEventHelper.EventPredicates.isStartOrStopElement((QName)XmlCatalogConstants.Elements.E_SYSTEM)).or(StaxEventHelper.EventPredicates.isStartOrStopElement((QName)XmlCatalogConstants.Elements.E_URI)).or(StaxEventHelper.EventPredicates.isStartOrStopElement((QName)XmlCatalogConstants.Elements.E_REWRITE));
            StaxEventHelper.loop((XMLEventReader)reader, pred, (Predicate)StaxEventHelper.EventPredicates.getChildOrSiblingPredicate(), (EventProcessor)new EventProcessor(){

                public void process(XMLEvent event) throws XMLStreamException {
                    if (event.isStartElement() && (event.asStartElement().getName().equals(XmlCatalogConstants.Elements.E_CATALOG) || event.asStartElement().getName().equals(XmlCatalogConstants.Elements.E_GROUP))) {
                        Attribute base = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_XML_BASE);
                        if (base != null) {
                            StatefulParser.this.mBase.push(URI.create(base.getValue()));
                        } else {
                            StatefulParser.this.mBase.push(StatefulParser.this.mBase.peek());
                        }
                    } else if (event.isEndElement() && (event.asEndElement().getName().equals(XmlCatalogConstants.Elements.E_CATALOG) || event.asEndElement().getName().equals(XmlCatalogConstants.Elements.E_GROUP))) {
                        StatefulParser.this.mBase.pop();
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(XmlCatalogConstants.Elements.E_PUBLIC)) {
                        StatefulParser.this.parsePublic(event);
                    }
                    if (event.isStartElement() && event.asStartElement().getName().equals(XmlCatalogConstants.Elements.E_SYSTEM)) {
                        StatefulParser.this.parseSystem(event);
                    }
                    if (event.isStartElement() && event.asStartElement().getName().equals(XmlCatalogConstants.Elements.E_URI)) {
                        StatefulParser.this.parseUri(event);
                    }
                    if (event.isStartElement() && event.asStartElement().getName().equals(XmlCatalogConstants.Elements.E_REWRITE)) {
                        StatefulParser.this.parseRewrite(event);
                    }
                }
            });
        }

        protected void parseUri(XMLEvent event) {
            Attribute name = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_NAME);
            Attribute uri = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_URI);
            URI nameUri = null;
            URI uriUri = null;
            if (name == null) {
                throw new IllegalStateException("name is null");
            }
            nameUri = URI.create(name.getValue());
            if (uri == null) {
                throw new IllegalStateException("uri is null");
            }
            uriUri = StaxXmlCatalogParser.this.addBase(uri.getValue(), this.mBase.peek());
            this.mCatalogBuilder.withUriMapping(nameUri, uriUri);
        }

        private void parsePublic(XMLEvent event) {
            Attribute publicId = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_PUBLIC_ID);
            Attribute uri = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_URI);
            String publicIdStr = "";
            URI uriUri = null;
            if (publicId == null) {
                throw new IllegalStateException("public id is null");
            }
            publicIdStr = publicId.getValue();
            if (uri == null) {
                throw new IllegalStateException("uri is null");
            }
            uriUri = StaxXmlCatalogParser.this.addBase(uri.getValue(), this.mBase.peek());
            this.mCatalogBuilder.withPublicMapping(publicIdStr, uriUri);
        }

        private void parseSystem(XMLEvent event) {
            Attribute systemId = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_SYSTEM_ID);
            Attribute uri = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_URI);
            URI systemIdUri = null;
            URI uriUri = null;
            if (systemId == null) {
                throw new IllegalStateException("system id is null");
            }
            systemIdUri = URI.create(systemId.getValue());
            if (uri == null) {
                throw new IllegalStateException("uri is null");
            }
            uriUri = StaxXmlCatalogParser.this.addBase(uri.getValue(), this.mBase.peek());
            this.mCatalogBuilder.withSystemIdMapping(systemIdUri, uriUri);
        }

        private void parseRewrite(XMLEvent event) {
            Attribute startString = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_START_STRING);
            Attribute rewrite = event.asStartElement().getAttributeByName(XmlCatalogConstants.Attributes.A_REWRITE_PREFIX);
            URI startStringUri = null;
            URI rewriteUri = null;
            if (startString != null) {
                startStringUri = startString.getValue().endsWith("/") ? URI.create(startString.getValue()) : URI.create(startString.getValue() + "/");
            } else {
                throw new IllegalStateException("startString is null");
            }
            if (rewrite == null) {
                throw new IllegalStateException("rewrite preffix is null");
            }
            rewriteUri = StaxXmlCatalogParser.this.addBase(rewrite.getValue(), this.mBase.peek());
            this.mCatalogBuilder.withRewriteUri(startStringUri, rewriteUri);
        }
    }
}

