/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.xmlcatalog.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import org.daisy.common.spi.ServiceLoader;
import org.daisy.common.spi.ServiceWithProperties;
import org.daisy.pipeline.xmlcatalog.impl.StaxXmlCatalogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxXmlCatalogParser_SPI
extends StaxXmlCatalogParser
implements ServiceWithProperties {
    private static final Logger spi_log = LoggerFactory.getLogger(StaxXmlCatalogParser_SPI.class);
    private final Map spi_props;
    private boolean spi_deactivated = false;

    public StaxXmlCatalogParser_SPI() {
        spi_log.trace("Creating StaxXmlCatalogParser");
        this.spi_props = new HashMap();
        this.spi_props.put("component.name", "catalog-parser");
        spi_log.trace("Binding javax.xml.stream.XMLInputFactory services...");
        int minRef = 1;
        int maxRef = 1;
        int refCount = 0;
        try {
            Iterator services = ServiceLoader.load(XMLInputFactory.class).iterator();
            while (services.hasNext()) {
                try {
                    XMLInputFactory service = (XMLInputFactory)services.next();
                    this.setFactory(service);
                    spi_log.trace("Bound javax.xml.stream.XMLInputFactory service: " + service.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(service)));
                    if (maxRef <= 0 || ++refCount != maxRef) continue;
                    break;
                }
                catch (Throwable e) {
                    spi_log.error("Error while binding javax.xml.stream.XMLInputFactory service", e);
                }
            }
        }
        catch (Throwable e) {
            spi_log.error("Error while binding javax.xml.stream.XMLInputFactory services", e);
        }
        if (refCount < minRef) {
            spi_log.warn("No javax.xml.stream.XMLInputFactory found");
            throw new RuntimeException("No javax.xml.stream.XMLInputFactory found");
        }
        spi_log.trace("Bound " + refCount + " javax.xml.stream.XMLInputFactory services.");
        spi_log.trace("Activating StaxXmlCatalogParser");
        this.activate();
    }

    public void spi_deactivate() {
    }

    public Map spi_getProperties() {
        return this.spi_props;
    }
}

