/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.fileset;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.daisy.common.stax.BaseURIAwareXMLStreamReader;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.pipeline.file.FileUtils;

public class Fileset {
    private Fileset() {
    }

    public static List<File> unmarshall(BaseURIAwareXMLStreamReader xml) throws XMLStreamException {
        ArrayList<File> fileset;
        block23: {
            fileset = new ArrayList<File>();
            URI filesetBase = xml.getBaseURI();
            int depth = 0;
            try {
                block12: while (true) {
                    int event = xml.next();
                    switch (event) {
                        case 7: {
                            break;
                        }
                        case 8: {
                            break block23;
                        }
                        case 1: {
                            if (depth == 0 && XMLConstants.D_FILESET.equals(xml.getName())) {
                                for (int i = 0; i < xml.getAttributeCount(); ++i) {
                                    if (!XMLConstants.XML_BASE.equals(xml.getAttributeName(i))) continue;
                                    filesetBase = filesetBase.resolve(xml.getAttributeValue(i));
                                    break;
                                }
                                ++depth;
                                break;
                            }
                            if (depth == 1 && XMLConstants.D_FILE.equals(xml.getName())) {
                                URI href = null;
                                URI originalHref = null;
                                String mediaType = null;
                                for (int i = 0; i < xml.getAttributeCount(); ++i) {
                                    if (XMLConstants._HREF.equals(xml.getAttributeName(i))) {
                                        href = filesetBase.resolve(xml.getAttributeValue(i));
                                        continue;
                                    }
                                    if (XMLConstants._ORIGINAL_HREF.equals(xml.getAttributeName(i))) {
                                        originalHref = filesetBase.resolve(xml.getAttributeValue(i));
                                        continue;
                                    }
                                    if (!XMLConstants._MEDIA_TYPE.equals(xml.getAttributeName(i))) continue;
                                    mediaType = xml.getAttributeValue(i);
                                }
                                if (href != null) {
                                    if (originalHref != null) {
                                        fileset.add(File.load(originalHref, href, Optional.ofNullable(mediaType)));
                                    } else {
                                        fileset.add(File.load(href, Optional.ofNullable(mediaType)));
                                    }
                                }
                            }
                            int d = depth + 1;
                            while (true) {
                                event = xml.next();
                                switch (event) {
                                    case 1: {
                                        ++d;
                                        break;
                                    }
                                    case 2: {
                                        if (--d == depth) continue block12;
                                    }
                                }
                            }
                        }
                        case 2: {
                            --depth;
                            break;
                        }
                    }
                }
            }
            catch (NoSuchElementException e) {}
            {
            }
        }
        return fileset;
    }

    public static void marshall(XMLStreamWriter xml, URI xmlBase, List<File> fileset) throws XMLStreamException {
        xml.writeStartDocument();
        XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)xml, (QName)XMLConstants.D_FILESET);
        if (xmlBase != null) {
            XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)xml, (QName)XMLConstants.XML_BASE, (String)xmlBase.toASCIIString());
        }
        for (File file : fileset) {
            XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)xml, (QName)XMLConstants.D_FILE);
            XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)xml, (QName)XMLConstants._HREF, (String)(xmlBase != null ? FileUtils.relativizeURI((URI)file.href, (URI)xmlBase) : file.href).toASCIIString());
            if (file.mediaType.isPresent()) {
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)xml, (QName)XMLConstants._MEDIA_TYPE, (String)file.mediaType.get());
            }
            if (file.data instanceof FileDataOnDisk) {
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)xml, (QName)XMLConstants._ORIGINAL_HREF, (String)((FileDataOnDisk)file.data).file.toURI().toASCIIString());
            }
            xml.writeEndElement();
        }
        xml.writeEndElement();
        xml.writeEndDocument();
    }

    public static final class XMLConstants {
        public static final QName D_FILESET = new QName("http://www.daisy.org/ns/pipeline/data", "fileset", "d");
        public static final QName XML_BASE = new QName("http://www.w3.org/XML/1998/namespace", "base", "xml");
        public static final QName D_FILE = new QName("http://www.daisy.org/ns/pipeline/data", "file", "d");
        public static final QName _MEDIA_TYPE = new QName("media-type");
        public static final QName _HREF = new QName("href");
        public static final QName _ORIGINAL_HREF = new QName("original-href");

        private XMLConstants() {
        }
    }

    private static class FileDataInMemory
    extends FileData {
        private final byte[] data;

        private FileDataInMemory(byte[] data) {
            this.data = data;
        }

        @Override
        public InputStream read() {
            return new ByteArrayInputStream(this.data);
        }
    }

    private static class FileDataOnDisk
    extends FileData {
        private final java.io.File file;

        private FileDataOnDisk(java.io.File file) {
            if (!file.isFile() || !file.exists()) {
                throw new IllegalArgumentException(new FileNotFoundException("file does not exist: " + file));
            }
            this.file = file;
        }

        @Override
        public InputStream read() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public FileData store(java.io.File destination) throws IOException {
            if (destination.equals(this.file)) {
                return this;
            }
            return super.store(destination);
        }
    }

    private static abstract class FileData {
        private FileData() {
        }

        public abstract InputStream read() throws IOException;

        public FileData store(java.io.File destination) throws IOException {
            try (FileOutputStream os = new FileOutputStream(destination);
                 InputStream is = this.read();){
                byte[] bucket = new byte[1024];
                int bytesRead = 0;
                while ((bytesRead = is.read(bucket, 0, bucket.length)) != -1) {
                    ((OutputStream)os).write(bucket, 0, bytesRead);
                }
            }
            return new FileDataOnDisk(destination);
        }
    }

    public static class File {
        public final URI href;
        public final Optional<String> mediaType;
        private final FileData data;

        private File(FileData data, URI href, Optional<String> mediaType) {
            this.data = data;
            this.href = href;
            this.mediaType = mediaType;
        }

        public static File load(URI from, Optional<String> mediaType) {
            return File.load(from, from, mediaType);
        }

        public static File load(URI from, URI href, Optional<String> mediaType) {
            return File.load(new java.io.File(from), href, mediaType);
        }

        public static File load(java.io.File from, Optional<String> mediaType) {
            return File.load(from, from.toURI(), mediaType);
        }

        public static File load(java.io.File from, URI href, Optional<String> mediaType) {
            return new File(new FileDataOnDisk(from), FileUtils.normalizeURI((URI)href), mediaType);
        }

        public static File load(byte[] data, URI href, Optional<String> mediaType) {
            return new File(new FileDataInMemory(data), FileUtils.normalizeURI((URI)href), mediaType);
        }

        public InputStream read() throws IOException {
            return this.data.read();
        }

        public File copy(URI href) {
            return new File(this.data, FileUtils.normalizeURI((URI)href), this.mediaType);
        }

        public File store() throws IOException {
            java.io.File file;
            try {
                file = new java.io.File(this.href);
            }
            catch (IllegalArgumentException e) {
                throw new IOException("href is not a file URI: " + this.href);
            }
            return new File(this.data.store(file), this.href, this.mediaType);
        }
    }
}

