/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.pipeline.fileset.calabash.impl;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.daisy.common.saxon.SaxonHelper;
import org.daisy.common.stax.BaseURIAwareXMLStreamReader;
import org.daisy.common.stax.BaseURIAwareXMLStreamWriter;
import org.daisy.common.stax.XMLStreamWriterHelper;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.xproc.calabash.XMLCalabashInputValue;
import org.daisy.common.xproc.calabash.XMLCalabashOutputValue;
import org.daisy.common.xproc.calabash.XProcStep;
import org.daisy.common.xproc.calabash.XProcStepProvider;
import org.daisy.pipeline.file.FileUtils;
import org.daisy.pipeline.fileset.Fileset;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;

public class AddEntriesStep
extends DefaultStep
implements XProcStep {
    private static final net.sf.saxon.s9api.QName _FIRST = new net.sf.saxon.s9api.QName("first");
    private static final net.sf.saxon.s9api.QName _REPLACE = new net.sf.saxon.s9api.QName("replace");
    private static final net.sf.saxon.s9api.QName _REPLACE_ATTRIBUTES = new net.sf.saxon.s9api.QName("replace-attributes");
    private static final net.sf.saxon.s9api.QName _ASSERT_SINGLE_ENTRY = new net.sf.saxon.s9api.QName("assert-single-entry");
    private ReadablePipe sourceFilesetPipe = null;
    private ReadablePipe sourceInMemoryPipe = null;
    private ReadablePipe entriesPipe = null;
    private WritablePipe resultFilesetPipe = null;
    private WritablePipe resultInMemoryPipe = null;
    private Map<QName, String> fileAttributes = null;

    private AddEntriesStep(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    public void setInput(String port, ReadablePipe pipe) {
        if ("source.fileset".equals(port)) {
            this.sourceFilesetPipe = pipe;
        } else if ("source.in-memory".equals(port)) {
            this.sourceInMemoryPipe = pipe;
        } else if ("entries".equals(port)) {
            this.entriesPipe = pipe;
        }
    }

    public void setOutput(String port, WritablePipe pipe) {
        if ("result.fileset".equals(port)) {
            this.resultFilesetPipe = pipe;
        } else if ("result.in-memory".equals(port)) {
            this.resultInMemoryPipe = pipe;
        }
    }

    public void reset() {
        this.sourceFilesetPipe.resetReader();
        this.sourceInMemoryPipe.resetReader();
        this.entriesPipe.resetReader();
        this.resultFilesetPipe.resetWriter();
        this.resultInMemoryPipe.resetWriter();
        if (this.fileAttributes != null) {
            this.fileAttributes.clear();
        }
    }

    public void setParameter(net.sf.saxon.s9api.QName name, RuntimeValue value) {
        if (this.fileAttributes == null) {
            this.fileAttributes = new HashMap<QName, String>();
        }
        this.fileAttributes.put(SaxonHelper.jaxpQName((net.sf.saxon.s9api.QName)name), value.getString());
    }

    public void setParameter(String port, net.sf.saxon.s9api.QName name, RuntimeValue value) {
        this.setParameter(name, value);
    }

    public void run() throws SaxonApiException {
        super.run();
        try {
            String option;
            ArrayList<File> entries = new ArrayList<File>();
            boolean assertSingleEntry = this.getOption(_ASSERT_SINGLE_ENTRY, false);
            RuntimeValue href = this.getOption(new net.sf.saxon.s9api.QName(Fileset.XMLConstants._HREF));
            if (href != null) {
                for (XdmItem i : href.getValue()) {
                    entries.add(new File(URI.create(i.getStringValue())));
                }
            }
            if (this.entriesPipe.moreDocuments()) {
                if (!entries.isEmpty()) {
                    throw TransformerException.wrap((Throwable)new IllegalArgumentException(assertSingleEntry ? "Expected 0 documents on the entry port" : "Expected 0 documents on the entries port"));
                }
                entries.add(new File(this.entriesPipe.read()));
                if (this.entriesPipe.moreDocuments()) {
                    if (assertSingleEntry) {
                        throw TransformerException.wrap((Throwable)new IllegalArgumentException("Expected exactly 1 document on the entry port (got more)"));
                    }
                    entries.add(new File(this.entriesPipe.read()));
                    while (this.entriesPipe.moreDocuments()) {
                        entries.add(new File(this.entriesPipe.read()));
                    }
                }
            } else if (assertSingleEntry && entries.isEmpty()) {
                throw TransformerException.wrap((Throwable)new IllegalArgumentException("Expected 1 document on the entry port (got 0)"));
            }
            URI originalHref = "".equals(option = this.getOption(new net.sf.saxon.s9api.QName(Fileset.XMLConstants._ORIGINAL_HREF), "")) ? null : URI.create(option);
            String mediaType = this.getOption(new net.sf.saxon.s9api.QName(Fileset.XMLConstants._MEDIA_TYPE), "");
            if ("".equals(mediaType)) {
                mediaType = null;
            }
            for (File f : entries) {
                f.originalHref = originalHref;
                f.mediaType = mediaType;
                f.otherAttributes = this.fileAttributes;
            }
            boolean first = this.getOption(_FIRST, false);
            boolean replace = this.getOption(_REPLACE, false);
            boolean replaceAttributes = this.getOption(_REPLACE_ATTRIBUTES, false);
            List<File> added = AddEntriesStep.addEntries(new XMLCalabashInputValue(this.sourceFilesetPipe).asXMLStreamReader(), new XMLCalabashOutputValue(this.resultFilesetPipe, this.runtime).asXMLStreamWriter(), entries, first, replace, replaceAttributes, this.logger);
            if (first) {
                for (File f : added) {
                    if (f.node == null) continue;
                    this.resultInMemoryPipe.write(f.node);
                }
            }
            while (this.sourceInMemoryPipe.moreDocuments()) {
                this.resultInMemoryPipe.write(this.sourceInMemoryPipe.read());
            }
            if (!first) {
                for (File f : added) {
                    if (f.node == null) continue;
                    this.resultInMemoryPipe.write(f.node);
                }
            }
        }
        catch (Throwable e) {
            throw XProcStep.raiseError((Throwable)e, (XAtomicStep)this.step);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<File> addEntries(BaseURIAwareXMLStreamReader source, BaseURIAwareXMLStreamWriter result, List<File> entries, boolean first, boolean replace, boolean replaceAttributes, Logger logger) throws XMLStreamException {
        FileSet added;
        block31: {
            added = new FileSet();
            added.addAll(entries);
            URI filesetBase = source.getBaseURI();
            result.setBaseURI(filesetBase);
            result.writeStartDocument();
            result = new XMLStreamWriterHelper.BufferedXMLStreamWriter(result);
            int depth = 0;
            boolean hasXmlBase = false;
            try {
                block12: while (true) {
                    File match;
                    int event;
                    block32: {
                        event = source.next();
                        switch (event) {
                            case 7: {
                                continue block12;
                            }
                            case 8: {
                                break block31;
                            }
                            case 1: {
                                if (entries.isEmpty()) {
                                    XMLStreamWriterHelper.writeElement((XMLStreamWriter)result, (XMLStreamReader)source);
                                    continue block12;
                                }
                                if (depth == 0) {
                                    break;
                                }
                                if (depth == 1) {
                                    match = null;
                                    break block32;
                                } else {
                                    XMLStreamWriterHelper.writeElement((XMLStreamWriter)result, (XMLStreamReader)source);
                                    continue block12;
                                }
                            }
                            case 2: {
                                if (--depth == 0 && !first) {
                                    ((XMLStreamWriterHelper.BufferedXMLStreamWriter)result).writeEvent((XMLStreamWriterHelper.FutureWriterEvent)added);
                                }
                            }
                            default: {
                                XMLStreamWriterHelper.writeEvent((XMLStreamWriter)result, (XMLStreamReader)source);
                                continue block12;
                            }
                        }
                        for (int i = 0; i < source.getAttributeCount(); ++i) {
                            if (!Fileset.XMLConstants.XML_BASE.equals(source.getAttributeName(i))) continue;
                            hasXmlBase = true;
                            filesetBase = filesetBase.resolve(source.getAttributeValue(i));
                            break;
                        }
                        filesetBase = FileUtils.normalizeURI((URI)filesetBase);
                        for (File f : added) {
                            f.base = FileUtils.normalizeURI((URI)filesetBase.resolve(f.href));
                            if (hasXmlBase) {
                                f.href = FileUtils.relativizeURI((URI)f.base, (URI)filesetBase);
                            } else if (!f.href.isAbsolute()) {
                                logger.warn("Adding a relative resource to a file set with no base directory");
                            }
                            if (f.originalHref == null) continue;
                            f.originalHref = FileUtils.normalizeURI((URI)filesetBase.resolve(f.originalHref));
                        }
                        XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)result, (QName)source.getName());
                        XMLStreamWriterHelper.writeAttributes((XMLStreamWriter)result, (XMLStreamReader)source);
                        ++depth;
                        if (!first) continue;
                        ((XMLStreamWriterHelper.BufferedXMLStreamWriter)result).writeEvent((XMLStreamWriterHelper.FutureWriterEvent)added);
                        continue;
                    }
                    block15: for (int i = 0; i < source.getAttributeCount(); ++i) {
                        if (!Fileset.XMLConstants._HREF.equals(source.getAttributeName(i))) continue;
                        URI base = FileUtils.normalizeURI((URI)filesetBase.resolve(source.getAttributeValue(i)));
                        for (File f : entries) {
                            if (!f.base.equals(base)) continue;
                            match = f;
                            break block15;
                        }
                        break;
                    }
                    if (match != null) {
                        entries.remove(match);
                        if (!replace) {
                            added.remove(match);
                            if (replaceAttributes) {
                                XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)result, (QName)source.getName());
                                HashMap<QName, String> existingAttributes = new HashMap<QName, String>();
                                for (int i = 0; i < source.getAttributeCount(); ++i) {
                                    existingAttributes.put(source.getAttributeName(i), source.getAttributeValue(i));
                                }
                                AddEntriesStep.writeFileAttributes((XMLStreamWriter)result, existingAttributes, match.originalHref, match.mediaType, match.otherAttributes);
                                ++depth;
                                continue;
                            }
                            XMLStreamWriterHelper.writeElement((XMLStreamWriter)result, (XMLStreamReader)source);
                            continue;
                        }
                    } else {
                        XMLStreamWriterHelper.writeElement((XMLStreamWriter)result, (XMLStreamReader)source);
                        continue;
                    }
                    block18: while (true) {
                        event = source.next();
                        switch (event) {
                            case 1: {
                                ++depth;
                                continue block18;
                            }
                            case 2: {
                                if (depth == 1) continue block12;
                                --depth;
                                continue block18;
                            }
                            default: {
                                continue block18;
                            }
                        }
                        break;
                    }
                }
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        result.writeEndDocument();
        added.ready = true;
        result.flush();
        return added;
    }

    private static void writeFileAttributes(XMLStreamWriter result, Map<QName, String> existingAttributes, URI originalHref, String mediaType, Map<QName, String> otherAttributes) throws XMLStreamException {
        if (originalHref != null) {
            XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)result, (QName)Fileset.XMLConstants._ORIGINAL_HREF, (String)originalHref.toASCIIString());
        }
        if (mediaType != null) {
            XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)result, (QName)Fileset.XMLConstants._MEDIA_TYPE, (String)mediaType);
        }
        if (otherAttributes != null) {
            for (QName attr : otherAttributes.keySet()) {
                if (Fileset.XMLConstants._HREF.equals(attr) || Fileset.XMLConstants._ORIGINAL_HREF.equals(attr) || Fileset.XMLConstants._MEDIA_TYPE.equals(attr)) {
                    throw TransformerException.wrap((Throwable)new IllegalArgumentException("href, original-href and media-type are not allowed file attributes"));
                }
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)result, (QName)attr, (String)otherAttributes.get(attr));
            }
        }
        if (existingAttributes != null) {
            for (QName attr : existingAttributes.keySet()) {
                if (originalHref != null && Fileset.XMLConstants._ORIGINAL_HREF.equals(attr) || mediaType != null && Fileset.XMLConstants._MEDIA_TYPE.equals(attr) || otherAttributes != null && otherAttributes.containsKey(attr)) continue;
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)result, (QName)attr, (String)existingAttributes.get(attr));
            }
        }
    }

    private static class FileSet
    extends ArrayList<File>
    implements XMLStreamWriterHelper.FutureWriterEvent {
        boolean ready = false;

        private FileSet() {
        }

        public void writeTo(XMLStreamWriter writer) throws XMLStreamException {
            for (File f : this) {
                XMLStreamWriterHelper.writeStartElement((XMLStreamWriter)writer, (QName)Fileset.XMLConstants.D_FILE);
                XMLStreamWriterHelper.writeAttribute((XMLStreamWriter)writer, (QName)Fileset.XMLConstants._HREF, (String)f.href.toASCIIString());
                AddEntriesStep.writeFileAttributes(writer, null, f.originalHref, f.mediaType, f.otherAttributes);
                writer.writeEndElement();
            }
        }

        public boolean isReady() {
            return this.ready;
        }
    }

    private static class File {
        XdmNode node;
        URI base = null;
        URI href;
        URI originalHref = null;
        String mediaType = null;
        Map<QName, String> otherAttributes = null;

        public File(URI href) {
            this.node = null;
            this.href = href;
        }

        public File(XdmNode node) {
            this.node = node;
            this.href = node.getBaseURI();
        }
    }

    @Component(name="pxi:fileset-add-entries", service={XProcStepProvider.class}, property={"type:String={http://www.daisy.org/ns/pipeline/xproc/internal}fileset-add-entries"})
    public static class StepProvider
    implements XProcStepProvider {
        public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
            return new AddEntriesStep(runtime, step);
        }
    }
}

