/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon;

import java.util.Iterator;
import java.util.function.Consumer;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.XdmItem;
import org.daisy.common.saxon.SaxonInputValue;
import org.daisy.common.saxon.SaxonOutputValue;
import org.daisy.common.transform.Buffer;
import org.daisy.common.transform.TransformerException;

public class SaxonBuffer
extends Buffer<Void, Void> {
    private final Configuration configuration;
    private SaxonInputValue input = null;
    private SaxonOutputValue output = null;
    private Buffer.ItemBuffer<XdmItem> xdmItemBuffer = null;

    public SaxonBuffer(Configuration config) {
        this.configuration = config;
    }

    public void done() {
        if (this.xdmItemBuffer == null) {
            this.xdmItemBuffer = new Buffer.ItemBuffer();
        }
        this.xdmItemBuffer.done();
    }

    public void error(TransformerException e) {
        if (this.xdmItemBuffer == null) {
            this.xdmItemBuffer = new Buffer.ItemBuffer();
        }
        this.xdmItemBuffer.error(e);
    }

    public SaxonInputValue asInput() {
        if (this.input == null) {
            if (this.xdmItemBuffer == null) {
                this.xdmItemBuffer = new Buffer.ItemBuffer();
            }
            this.input = new SaxonInputValue((Iterator<? extends XdmItem>)this.xdmItemBuffer);
        }
        return this.input;
    }

    public SaxonOutputValue asOutput() {
        if (this.output == null) {
            if (this.xdmItemBuffer == null) {
                this.xdmItemBuffer = new Buffer.ItemBuffer();
            }
            this.output = new SaxonOutputValue((Consumer<XdmItem>)this.xdmItemBuffer, this.configuration);
        }
        return this.output;
    }
}

