/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.TransformerFactoryImpl;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.packages.PackageDetails;
import net.sf.saxon.trans.packages.PackageLibrary;
import net.sf.saxon.xpath.XPathFactoryImpl;
import org.daisy.common.xpath.saxon.XPathFunctionRegistry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Component(name="saxon-configurator", service={SaxonConfigurator.class})
public class SaxonConfigurator {
    private URIResolver uriResolver = null;
    private XPathFunctionRegistry xpathExtensionFunctions = null;
    private List<PackageDetails> packages = null;
    private static final Logger logger = LoggerFactory.getLogger(SaxonConfigurator.class);

    public Configuration newConfiguration() {
        try {
            Configuration config = Configuration.readConfiguration((Source)new SAXSource(new InputSource(this.getConfigurationAsStream())));
            if (this.uriResolver != null) {
                config.setURIResolver(this.uriResolver);
            }
            if (this.xpathExtensionFunctions != null) {
                for (ExtensionFunctionDefinition function : this.xpathExtensionFunctions.getFunctions()) {
                    config.registerExtensionFunction(function);
                }
            }
            if (this.packages != null && !this.packages.isEmpty()) {
                PackageLibrary packageLib = config.getDefaultXsltCompilerInfo().getPackageLibrary();
                for (PackageDetails pack : this.packages) {
                    packageLib.addPackage(pack);
                }
            }
            return config;
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getConfigurationAsStream() {
        return new ByteArrayInputStream("<configuration xmlns='http://saxon.sf.net/ns/configuration'>   <global expandAttributeDefaults='false'           lineNumbering='true'           suppressXsltNamespaceCheck='true'           stripSpace='none'/></configuration>\n".getBytes(StandardCharsets.UTF_8));
    }

    public Iterable<ExtensionFunctionDefinition> getExtensionFunctions() {
        if (this.xpathExtensionFunctions != null) {
            return Collections.unmodifiableCollection(this.xpathExtensionFunctions.getFunctions());
        }
        return Collections.emptySet();
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public Iterable<PackageDetails> getXsltPackages() {
        if (this.packages != null) {
            return Collections.unmodifiableCollection(this.packages);
        }
        return Collections.emptySet();
    }

    public void configure(Processor processor) {
        Configuration config = this.newConfiguration();
        processor.setConfigurationProperty("http://saxon.sf.net/feature/configuration", (Object)config);
        config.setProcessor((Object)processor);
    }

    public void configure(TransformerFactoryImpl transformerFactory) {
        this.configure(transformerFactory.getProcessor());
    }

    public void configure(XPathFactoryImpl xpathFactory) {
        xpathFactory.setConfiguration(this.newConfiguration());
    }

    @Reference(name="XPathFunctionRegistry", unbind="-", service=XPathFunctionRegistry.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.STATIC)
    public void setXPathFunctionRegistry(XPathFunctionRegistry xpathFunctions) {
        logger.debug("Setting function registry");
        this.xpathExtensionFunctions = xpathFunctions;
    }

    @Reference(name="URIResolver", unbind="-", service=URIResolver.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.STATIC)
    public void setURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
    }

    @Reference(name="PackageDetails", unbind="-", service=PackageDetails.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.STATIC)
    public void addPackageDetails(PackageDetails pack) {
        if (this.packages == null) {
            this.packages = new ArrayList<PackageDetails>();
        }
        this.packages.add(pack);
    }

    public void removePackageDetails(PackageDetails pack) {
        if (this.packages != null) {
            this.packages.remove(pack);
        }
    }
}

