/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import net.sf.saxon.Configuration;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BigDecimalValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.StringValue;

public final class SaxonHelper {
    public static Sequence sequenceFromObject(Object object) {
        if (object == null) {
            return EmptySequence.getInstance();
        }
        if (object instanceof Iterator || object instanceof Iterable) {
            return SaxonHelper.sequenceFromIterator(object instanceof Iterable ? ((Iterable)object).iterator() : (Iterator)object);
        }
        if (object.getClass().isArray()) {
            return SaxonHelper.arrayItemFromIterator(Arrays.asList((Object[])object).iterator());
        }
        return SaxonHelper.itemFromObject(object);
    }

    private static Item itemFromObject(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        if (object instanceof String) {
            return new StringValue((CharSequence)((String)object));
        }
        if (object instanceof Integer) {
            return IntegerValue.makeIntegerValue((BigInteger)BigInteger.valueOf(((Integer)object).intValue()));
        }
        if (object instanceof Long) {
            return IntegerValue.makeIntegerValue((BigInteger)BigInteger.valueOf((Long)object));
        }
        if (object instanceof Float) {
            return FloatValue.makeFloatValue((float)((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DoubleValue.makeDoubleValue((double)((Double)object));
        }
        if (object instanceof BigDecimal) {
            return new BigDecimalValue((BigDecimal)object);
        }
        if (object instanceof Boolean) {
            return BooleanValue.get((boolean)((Boolean)object));
        }
        if (object instanceof URI) {
            return new AnyURIValue((CharSequence)((URI)object).toASCIIString());
        }
        if (object instanceof Locale) {
            return SaxonHelper.itemFromObject(((Locale)object).toLanguageTag());
        }
        if (object instanceof Map) {
            return SaxonHelper.mapItemFromMap((Map)object);
        }
        return new ObjectValue(object);
    }

    private static Sequence sequenceFromIterator(Iterator<?> iterator) {
        ArrayList<Item> list = new ArrayList<Item>();
        while (iterator.hasNext()) {
            list.add(SaxonHelper.itemFromObject(iterator.next()));
        }
        return new SequenceExtent(list);
    }

    private static MapItem mapItemFromMap(Map<?, ?> map) {
        HashTrieMap mapItem = new HashTrieMap();
        for (Object key : map.keySet()) {
            if (!(key instanceof String)) {
                throw new IllegalArgumentException();
            }
            mapItem = mapItem.addEntry((AtomicValue)new StringValue((CharSequence)((String)key)), SaxonHelper.sequenceFromObject(map.get(key)));
        }
        return mapItem;
    }

    private static ArrayItem arrayItemFromIterator(Iterator<?> iterator) {
        try {
            return SimpleArrayItem.makeSimpleArrayItem((SequenceIterator)SaxonHelper.sequenceFromIterator(iterator).iterate());
        }
        catch (XPathException e) {
            throw new RuntimeException(e);
        }
    }

    public static XdmValue xdmValueFromObject(Object object) {
        if (object == null) {
            return XdmValue.wrap((Sequence)EmptySequence.getInstance());
        }
        if (object instanceof String) {
            return new XdmAtomicValue((String)object);
        }
        if (object instanceof Integer) {
            return new XdmAtomicValue(((Integer)object).intValue());
        }
        if (object instanceof Boolean) {
            return new XdmAtomicValue(((Boolean)object).booleanValue());
        }
        if (object instanceof URI) {
            return new XdmAtomicValue((URI)object);
        }
        try {
            return XdmValue.wrap((Sequence)SaxonHelper.sequenceFromObject(object));
        }
        catch (IllegalArgumentException e) {
            return XdmValue.wrap((Sequence)new ObjectValue(object));
        }
    }

    public static QName jaxpQName(net.sf.saxon.s9api.QName name) {
        String prefix = name.getPrefix();
        String ns = name.getNamespaceURI();
        String localPart = name.getLocalName();
        if (prefix != null) {
            return new QName(ns, localPart, prefix);
        }
        return new QName(ns, localPart);
    }

    public static Iterable<XdmItem> axisIterable(final XdmNode node, final Axis axis) {
        return new Iterable<XdmItem>(){

            @Override
            public Iterator<XdmItem> iterator() {
                return node.axisIterator(axis);
            }
        };
    }

    public static XPathExpression compileExpression(String expression, Hashtable<String, String> namespaceBindings, Configuration configuration) throws XPathException {
        XPathEvaluator xpathEvaluator = new XPathEvaluator(configuration);
        xpathEvaluator.getStaticContext().setNamespaceResolver((NamespaceResolver)new MatchingNamespaceResolver(namespaceBindings));
        return xpathEvaluator.createPattern(expression);
    }

    public static boolean evaluateBoolean(XPathExpression expression, XdmNode contextNode) {
        try {
            XPathDynamicContext context = expression.createDynamicContext((Item)contextNode.getUnderlyingNode());
            return expression.effectiveBooleanValue(context);
        }
        catch (XPathException e) {
            return false;
        }
    }

    private SaxonHelper() {
    }

    public static class MatchingNamespaceResolver
    implements NamespaceResolver {
        private Hashtable<String, String> ns = new Hashtable();

        public MatchingNamespaceResolver(Hashtable<String, String> bindings) {
            this.ns = bindings;
        }

        public String getURIForPrefix(String prefix, boolean useDefault) {
            if ("".equals(prefix) && !useDefault) {
                return "";
            }
            return this.ns.get(prefix);
        }

        public Iterator<String> iteratePrefixes() {
            Vector<String> p = new Vector<String>();
            for (String pfx : this.ns.keySet()) {
                p.add(pfx);
            }
            return p.iterator();
        }
    }
}

