/*
 * Decompiled with CFR 0.152.
 */
package org.daisy.common.saxon;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.saxonica.xqj.pull.PullFromIterator;
import com.saxonica.xqj.pull.PullToStax;
import java.net.URI;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamException;
import net.sf.saxon.dom.DocumentOverNodeInfo;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.daisy.common.stax.BaseURIAwareXMLStreamReader;
import org.daisy.common.stax.DelegatingBaseURIAwareXMLStreamReader;
import org.daisy.common.transform.Mult;
import org.daisy.common.transform.TransformerException;
import org.daisy.common.transform.XMLInputValue;
import org.w3c.dom.Node;

public class SaxonInputValue
extends XMLInputValue<Void> {
    private SaxonInputValue backingValue = null;
    private XdmValue xdmValue = null;
    private final Iterator<XdmItem> xdmItemIterator;
    private boolean xdmItemIteratorSupplied = false;

    public SaxonInputValue(XdmValue value) {
        this(value, true);
    }

    private SaxonInputValue(XdmValue value, boolean sequence) {
        this((Iterator<? extends XdmItem>)value.iterator(), sequence);
        this.xdmValue = value;
    }

    public SaxonInputValue(NodeInfo value) {
        this((XdmValue)new XdmNode(value));
    }

    public SaxonInputValue(Iterator<? extends XdmItem> value) {
        this(value, true);
    }

    private SaxonInputValue(Iterator<? extends XdmItem> value, boolean sequence) {
        super(Iterators.transform(value, n -> {
            if (n instanceof XdmNode) {
                return DocumentOverNodeInfo.wrap((NodeInfo)((XdmNode)n).getUnderlyingNode());
            }
            throw new TransformerException((Throwable)new IllegalArgumentException("expected a node"));
        }), sequence);
        this.streamReader = SaxonInputValue.concat(Iterators.transform(value, SaxonInputValue.propagateCE(n -> {
            if (n instanceof XdmNode) {
                NodeInfo node = ((XdmNode)n).getUnderlyingNode();
                PullFromIterator provider = new PullFromIterator(node.iterate());
                provider.setPipelineConfiguration(new PipelineConfiguration(node.getConfiguration()));
                return new BaseURIAwarePullToStax((PullProvider)provider, node.getBaseURI() == null ? null : URI.create(node.getBaseURI()));
            }
            throw new IllegalArgumentException("expected a node");
        }, TransformerException::wrap)));
        this.xdmItemIterator = value;
    }

    protected SaxonInputValue(SaxonInputValue value, boolean sequence) {
        super((XMLInputValue)value, sequence);
        this.backingValue = value;
        this.xdmItemIterator = null;
    }

    public Iterator<XdmItem> asXdmItemIterator() throws NoSuchElementException {
        if (this.backingValue != null) {
            if (this.sequence) {
                return this.backingValue.asXdmItemIterator();
            }
            return SaxonInputValue.ensureSingleItem(this.backingValue.asXdmItemIterator());
        }
        if (this.valueSupplied()) {
            throw new NoSuchElementException();
        }
        this.xdmItemIteratorSupplied = true;
        return this.xdmItemIterator;
    }

    public BaseURIAwareXMLStreamReader asXMLStreamReader() throws NoSuchElementException {
        return super.asXMLStreamReader();
    }

    public Iterator<Node> asNodeIterator() throws NoSuchElementException {
        return super.asNodeIterator();
    }

    public Mult<SaxonInputValue> mult(final int limit) {
        if (this.xdmValue != null && this.valueSupplied()) {
            this.xdmItemIteratorSupplied = true;
            return () -> this;
        }
        return new Mult<SaxonInputValue>(){
            Iterable<XdmItem> xdmItemCache;
            int supplied;
            {
                this.xdmItemCache = SaxonInputValue.this.xdmValue == null ? SaxonInputValue.cache((Iterator)SaxonInputValue.iteratorOf((Supplier)new Supplier<XdmItem>(){
                    Iterator<XdmItem> it = null;

                    @Override
                    public XdmItem get() {
                        if (this.it == null) {
                            this.it = SaxonInputValue.this.asXdmItemIterator();
                        }
                        return this.it.next();
                    }
                }), (int)limit) : null;
                this.supplied = 0;
            }

            public SaxonInputValue get() throws NoSuchElementException {
                if (this.supplied >= limit) {
                    this.xdmItemCache = null;
                    throw new NoSuchElementException();
                }
                ++this.supplied;
                if (SaxonInputValue.this.xdmValue != null) {
                    return new SaxonInputValue(SaxonInputValue.this.xdmValue, SaxonInputValue.this.sequence);
                }
                return new SaxonInputValue(this.xdmItemCache.iterator(), SaxonInputValue.this.sequence);
            }
        };
    }

    public SaxonInputValue ensureSingleItem() {
        if (this.backingValue != null && !this.sequence) {
            return this;
        }
        return new SaxonInputValue(this, false);
    }

    protected boolean valueSupplied() {
        return super.valueSupplied() || this.xdmItemIteratorSupplied;
    }

    private static BaseURIAwareXMLStreamReader concat(final Iterator<BaseURIAwareXMLStreamReader> readers) {
        if (!readers.hasNext()) {
            return null;
        }
        return new DelegatingBaseURIAwareXMLStreamReader(){
            private BaseURIAwareXMLStreamReader reader = null;

            protected BaseURIAwareXMLStreamReader delegate() {
                if (this.reader == null) {
                    this.reader = (BaseURIAwareXMLStreamReader)readers.next();
                }
                return this.reader;
            }

            public boolean hasNext() throws XMLStreamException {
                return this.reader != null && this.reader.hasNext() || readers.hasNext();
            }

            public int next() throws XMLStreamException, NoSuchElementException {
                if (this.reader != null && this.reader.hasNext()) {
                    return this.reader.next();
                }
                if (readers.hasNext()) {
                    this.reader = (BaseURIAwareXMLStreamReader)readers.next();
                    return this.reader.getEventType();
                }
                throw new NoSuchElementException();
            }
        };
    }

    private static <T, R, E extends RuntimeException> Function<T, R> propagateCE(final ThrowingFunction<T, R> f, final Function<Throwable, E> newEx) {
        return new Function<T, R>(){

            public R apply(T t) throws RuntimeException {
                try {
                    return f.applyThrows(t);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw (RuntimeException)newEx.apply((Object)e);
                }
            }
        };
    }

    @FunctionalInterface
    private static interface ThrowingFunction<T, R>
    extends Function<T, R> {
        default public R apply(T t) {
            try {
                return this.applyThrows(t);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        public R applyThrows(T var1) throws Throwable;
    }

    private static class BaseURIAwarePullToStax
    extends PullToStax
    implements BaseURIAwareXMLStreamReader {
        private final URI baseURI;

        public BaseURIAwarePullToStax(PullProvider provider, URI baseURI) {
            super(provider);
            this.baseURI = baseURI;
        }

        public URI getBaseURI() throws XMLStreamException {
            return this.baseURI;
        }
    }
}

